/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog.lasercutter;

import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.PowerSpeedFocusFrequencyProperty;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.drivers.EpilogHelix;
import com.t_oster.liblasercut.drivers.EpilogZing;
import com.t_oster.liblasercut.drivers.LaosCutter;
import com.t_oster.liblasercut.drivers.Lasersaur;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.printdialog.lasercutter.LaserCutter;
import java.util.List;

public class LaserJobCreator {
    private EpilogZing epilogZing = null;
    private EpilogHelix epilogHelix = null;
    private LaosCutter laosCutter = null;
    private Lasersaur lasersaur = null;
    LaserCutter device;
    private RasterPart rp = null;
    private VectorPart vp = null;
    private VectorPart engravevp = null;

    public void setLaserCutter(LaserCutter device, String ipAddress) {
        this.device = device;
        int deviceNumber = device.returnDeviceNumber();
        switch (deviceNumber) {
            case 0: {
                this.epilogZing = new EpilogZing(ipAddress);
                break;
            }
            case 1: {
                this.epilogHelix = new EpilogHelix(ipAddress);
                break;
            }
            case 2: {
                this.laosCutter = new LaosCutter();
                this.laosCutter.setHostname(ipAddress);
                break;
            }
            case 3: {
                this.lasersaur = new Lasersaur();
            }
        }
    }

    public void newVectorPart(int DPI, int power, int speed, float focus, int frequency) {
        PowerSpeedFocusFrequencyProperty psffProperty = new PowerSpeedFocusFrequencyProperty();
        psffProperty.setProperty("power", (Object)power);
        psffProperty.setProperty("speed", (Object)speed);
        psffProperty.setProperty("focus", (Object)Float.valueOf(focus));
        psffProperty.setProperty("frequency", (Object)frequency);
        this.vp = new VectorPart((LaserProperty)psffProperty, (double)DPI);
    }

    public void newEngraveVectorPart(int DPI, int power, int speed, float focus, int frequency) {
        PowerSpeedFocusFrequencyProperty psffProperty = new PowerSpeedFocusFrequencyProperty();
        psffProperty.setProperty("power", (Object)power);
        psffProperty.setProperty("speed", (Object)speed);
        psffProperty.setProperty("focus", (Object)Float.valueOf(focus));
        psffProperty.setProperty("frequency", (Object)frequency);
        this.engravevp = new VectorPart((LaserProperty)psffProperty, (double)DPI);
    }

    public void addVerticesToVectorPart(List<Vector2D> newVertices) {
        if (newVertices.get(0) != null) {
            this.vp.moveto((int)newVertices.get(0).getComponent(0), (int)newVertices.get(0).getComponent(1));
            int i = 1;
            while (i < newVertices.size()) {
                this.vp.lineto((int)newVertices.get(i).getComponent(0), (int)newVertices.get(i).getComponent(1));
                ++i;
            }
            this.vp.lineto((int)newVertices.get(0).getComponent(0), (int)newVertices.get(0).getComponent(1));
        }
    }

    public void sendLaserjob(String name) {
        LaserJob job = new LaserJob(name, "", "CutCADApplet");
        if (this.rp != null) {
            job.addPart((JobPart)this.rp);
        }
        if (this.vp != null) {
            job.addPart((JobPart)this.vp);
        }
        if (this.engravevp != null) {
            job.addPart((JobPart)this.engravevp);
        }
        try {
            int deviceNumber = this.device.returnDeviceNumber();
            switch (deviceNumber) {
                case 0: {
                    System.out.println("Cutting on Epilog Zing");
                    this.epilogZing.sendJob(job);
                    break;
                }
                case 1: {
                    System.out.println("Cutting on Epilog Helix");
                    this.epilogHelix.sendJob(job);
                    break;
                }
                case 2: {
                    System.out.println("Cutting on LAOS");
                    this.laosCutter.sendJob(job);
                    break;
                }
                case 3: {
                    System.out.println("Cutting on lasersaur");
                    this.lasersaur.sendJob(job);
                }
            }
        }
        catch (IllegalJobException ije) {
            System.out.println(ije.toString());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }
}

