/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import de.mcp.cutcad.model.primitives.Cutout;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.printdialog.PrintInstance;
import de.mcp.cutcad.printdialog.PrintSubDialogWindow;
import de.mcp.cutcad.printdialog.lasercutter.LaserCutter;
import de.mcp.cutcad.printdialog.lasercutter.LaserJobCreator;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import processing.data.XML;

class PrintSubInstance {
    private ArrayList<Shape> shapesPlaced;
    private LaserJobCreator laserJob;
    private PrintSubDialogWindow printSubDialogWindow;
    private Frame printSubDialogFrame;
    private PrintInstance parent;
    private int dpi;

    PrintSubInstance(PrintInstance parent) {
        this.parent = parent;
        this.shapesPlaced = new ArrayList();
        this.laserJob = new LaserJobCreator();
    }

    void setLaserCutter(LaserCutter cutter, String ipAddress) {
        this.laserJob.setLaserCutter(cutter, ipAddress);
    }

    void placeShape(Shape shape) {
        this.shapesPlaced.add(shape);
    }

    void unplaceShape(Shape shape) {
        this.shapesPlaced.remove(shape);
    }

    ArrayList<Shape> getPlacedShapes() {
        return this.shapesPlaced;
    }

    void print(String printJobName) {
        this.printSubDialogWindow = this.createPrintSubDialog(printJobName);
    }

    void setDPI(int dpi) {
        this.dpi = dpi;
    }

    void sendLaserJob() {
        this.laserJob.newVectorPart(this.dpi, this.parent.getMaterial().getPower(), this.parent.getMaterial().getSpeed(), this.parent.getMaterial().getFocus(), this.parent.getMaterial().getFrequency());
        this.laserJob.newEngraveVectorPart(this.dpi, this.parent.getMaterial().getPower(), this.parent.getMaterial().getSpeed(), this.parent.getMaterial().getFocus(), this.parent.getMaterial().getFrequency());
        float scaleFactor = (float)this.dpi / 25.4f;
        int i = 0;
        while (i < this.shapesPlaced.size()) {
            List<Vector2D> vertices = this.shapesPlaced.get(i).getGShape().getVertices();
            ArrayList<Vector2D> newVertices = new ArrayList<Vector2D>();
            int j = 0;
            while (j < vertices.size()) {
                newVertices.add(new Vector2D(vertices.get(j)));
                ++j;
            }
            Vector2D position = this.shapesPlaced.get(i).getGShape().getPosition2D();
            int j2 = 0;
            while (j2 < newVertices.size()) {
                ((Vector2D)newVertices.get(j2)).set((((Vector2D)newVertices.get(j2)).getComponent(0) + position.getComponent(0)) * scaleFactor, (((Vector2D)newVertices.get(j2)).getComponent(1) + position.getComponent(1)) * scaleFactor);
                ++j2;
            }
            this.laserJob.addVerticesToVectorPart(newVertices);
            for (Cutout c : this.shapesPlaced.get(i).getGShape().getCutouts()) {
                newVertices = c.getVectors();
                int j3 = 0;
                while (j3 < newVertices.size()) {
                    ((Vector2D)newVertices.get(j3)).set(((Vector2D)newVertices.get(j3)).add(position).scale(scaleFactor));
                    ++j3;
                }
                this.laserJob.addVerticesToVectorPart(newVertices);
            }
            ++i;
        }
        this.laserJob.sendLaserjob(this.parent.getMaterial().getMaterialName());
    }

    void nextJob() {
        this.printSubDialogFrame.setVisible(false);
        this.parent.printNext();
    }

    private PrintSubDialogWindow createPrintSubDialog(String printJobName) {
        this.printSubDialogFrame = new Frame(printJobName);
        PrintSubDialogWindow tempPrintSubDialog = new PrintSubDialogWindow(this, printJobName, 200, 200);
        this.printSubDialogFrame.add((Component)((Object)tempPrintSubDialog));
        tempPrintSubDialog.init();
        tempPrintSubDialog.setSize(250, 310);
        this.printSubDialogFrame.setTitle(printJobName);
        this.printSubDialogFrame.setSize(tempPrintSubDialog.getWidth(), tempPrintSubDialog.getHeight());
        this.printSubDialogFrame.setLocation(100, 100);
        this.printSubDialogFrame.setResizable(false);
        this.printSubDialogFrame.setVisible(true);
        this.printSubDialogFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PrintSubInstance.this.printSubDialogWindow.destroy();
                PrintSubInstance.this.printSubDialogFrame.setVisible(false);
                PrintSubInstance.this.parent.printNext();
            }
        });
        return tempPrintSubDialog;
    }

    void printSVG(String exportPath) {
        double widthInPx = 600.0;
        double heightInPx = 300.0;
        String output = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"600.0mm\" height=\"300.0mm\">";
        int i = 0;
        while (i < this.shapesPlaced.size()) {
            List<Vector2D> vertices = this.shapesPlaced.get(i).getGShape().getVertices();
            Vector2D position = this.shapesPlaced.get(i).getGShape().getPosition2D();
            int j = 0;
            while (j < vertices.size()) {
                output = j == vertices.size() - 1 ? String.valueOf(output) + "<line x1=\"" + (vertices.get(j).getComponent(0) + position.getComponent(0)) + "mm\" y1=\"" + (vertices.get(j).getComponent(1) + position.getComponent(1)) + "mm\" x2= \"" + (vertices.get(0).getComponent(0) + position.getComponent(0)) + "mm\" y2= \"" + (vertices.get(0).getComponent(1) + position.getComponent(1)) + "mm\" style=\"stroke:rgb(0,0,0);stroke-width:1mm\" />" : String.valueOf(output) + "<line x1=\"" + (vertices.get(j).getComponent(0) + position.getComponent(0)) + "mm\" y1=\"" + (vertices.get(j).getComponent(1) + position.getComponent(1)) + "mm\" x2= \"" + (vertices.get(j + 1).getComponent(0) + position.getComponent(0)) + "mm\" y2= \"" + (vertices.get(j + 1).getComponent(1) + position.getComponent(1)) + "mm\" style=\"stroke:rgb(0,0,0);stroke-width:1mm\" />";
                ++j;
            }
            for (Cutout c : this.shapesPlaced.get(i).getGShape().getCutouts()) {
                vertices = c.getVectors();
                int j2 = 0;
                while (j2 < vertices.size()) {
                    output = j2 == vertices.size() - 1 ? String.valueOf(output) + "<line x1=\"" + (vertices.get(j2).getComponent(0) + position.getComponent(0)) + "mm\" y1=\"" + (vertices.get(j2).getComponent(1) + position.getComponent(1)) + "mm\" x2= \"" + (vertices.get(0).getComponent(0) + position.getComponent(0)) + "mm\" y2= \"" + (vertices.get(0).getComponent(1) + position.getComponent(1)) + "mm\" style=\"stroke:rgb(0,0,0);stroke-width:1mm\" />" : String.valueOf(output) + "<line x1=\"" + (vertices.get(j2).getComponent(0) + position.getComponent(0)) + "mm\" y1=\"" + (vertices.get(j2).getComponent(1) + position.getComponent(1)) + "mm\" x2= \"" + (vertices.get(j2 + 1).getComponent(0) + position.getComponent(0)) + "mm\" y2= \"" + (vertices.get(j2 + 1).getComponent(1) + position.getComponent(1)) + "mm\" style=\"stroke:rgb(0,0,0);stroke-width:1mm\" />";
                    ++j2;
                }
            }
            ++i;
        }
        output = String.valueOf(output) + "</svg>";
        try {
            XML xml = XML.parse((String)output);
            xml.save(new File(String.valueOf(exportPath) + ".svg"), "");
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    boolean checkOverlap() {
        int i = 0;
        while (i < this.shapesPlaced.size()) {
            int j = i + 1;
            while (j < this.shapesPlaced.size()) {
                if (this.shapesPlaced.get(i).getGShape().overlapsWith(this.shapesPlaced.get(j).getGShape())) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

