/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import controlP5.ControlEvent;
import controlP5.ControlP5;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.printdialog.PrintDialogInstance;
import de.mcp.cutcad.printdialog.WidgetContainer;
import de.mcp.cutcad.view.Transformation;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import toxi.geom.Rect;

class PrintDialogWindow
extends PApplet {
    private static final long serialVersionUID = 1L;
    private ControlP5 cp5;
    private int w;
    private int h;
    private int bedWidth;
    private int bedHeight;
    private boolean dragging;
    private double[] dpi;
    private PGraphics objectLayout;
    private WidgetContainer printDialogWidgets;
    private PrintDialogInstance printDialogInstance;
    private Vector2D originalMousePosition;
    private Rect view;

    public PrintDialogWindow(int theWidth, int theHeight, PrintDialogInstance printDialogInstance) {
        this.printDialogInstance = printDialogInstance;
        this.w = theWidth;
        this.h = theHeight;
        this.bedWidth = this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnBedWidth();
        this.bedHeight = this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnBedHeight();
        this.dragging = false;
        this.view = new Rect(0.0f, 0.0f, (float)this.bedWidth, (float)this.bedHeight);
        this.originalMousePosition = new Vector2D(0.0f, 0.0f);
    }

    public void setup() {
        this.size(this.h, this.w);
        this.frameRate(25.0f);
        this.cp5 = new ControlP5((PApplet)this);
        this.objectLayout = this.createGraphics(this.bedWidth, this.bedHeight);
        this.printDialogWidgets = new WidgetContainer(this.cp5, this.printDialogInstance);
        this.dpi = this.printDialogWidgets.setupButtons(this.h, this.w, this.bedHeight, this.bedWidth);
        this.prepareExitHandler();
    }

    public void draw() {
        this.background(255);
        this.drawObjectLayout();
    }

    public void destroy() {
        this.printDialogInstance.persistSettings();
        super.destroy();
    }

    private void prepareExitHandler() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("SHUTDOWN HOOK");
                PrintDialogWindow.this.printDialogInstance.persistSettings();
            }
        }));
    }

    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.isGroup() && theEvent.getName().equals("unplacedShapesList")) {
            int objectIndex = (int)theEvent.getGroup().getValue();
            this.shapeListHandler(objectIndex);
        } else if (theEvent.isGroup() && theEvent.getName().equals("cutterBox")) {
            int objectIndex = (int)theEvent.getGroup().getValue();
            this.cutterBoxHandler(objectIndex);
        } else if (theEvent.isGroup() && theEvent.getName().equals("dpiBox")) {
            int objectIndex = (int)theEvent.getGroup().getValue();
            this.dpiListHandler(objectIndex);
        } else if (theEvent.isController() && theEvent.getName().equals("Use address")) {
            this.addressEnteredHandler();
        } else if (theEvent.isController() && theEvent.getName().equals("Start cutting")) {
            this.printHandler(false);
        } else if (theEvent.isController() && theEvent.getName().equals("Export as SVG")) {
            this.printHandler(true);
        } else if (theEvent.isController() && theEvent.getName().equals("Add extra job")) {
            this.addJobHandler();
        } else if (theEvent.isController() && theEvent.getName().equals("yes")) {
            this.confirmHandler();
        } else if (theEvent.isController() && theEvent.getName().equals("no")) {
            this.declineHandler();
        } else if (theEvent.isController()) {
            int objectIndex = theEvent.getController().getId();
            this.selectInstanceHandler(objectIndex);
        }
    }

    private void shapeListHandler(int objectIndex) {
        this.printDialogInstance.placeShape(objectIndex);
        this.printDialogWidgets.updateListBox();
    }

    private void cutterBoxHandler(int objectIndex) {
        this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().setDevice(objectIndex);
        this.bedWidth = this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnBedWidth();
        this.bedHeight = this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnBedHeight();
        this.objectLayout = this.createGraphics(this.bedWidth, this.bedHeight);
        this.view = new Rect(0.0f, 0.0f, (float)this.bedWidth, (float)this.bedHeight);
        this.printDialogWidgets.setCutterSelected(this.printDialogInstance.getLaserCutterSettings().getSelectedCutter().returnDevice());
        this.printDialogInstance.getLaserCutterSettings().setDPI(0);
        this.dpi = this.printDialogWidgets.showDPIBox();
    }

    private void dpiListHandler(int objectIndex) {
        this.printDialogInstance.getLaserCutterSettings().setDPI((int)this.dpi[objectIndex]);
        this.printDialogWidgets.setDPISelected(String.valueOf(Integer.toString(this.printDialogInstance.getLaserCutterSettings().getDPI())) + " DPI");
    }

    private void addressEnteredHandler() {
        this.printDialogInstance.getLaserCutterSettings().setAddress(this.printDialogWidgets.getCutterAddress());
        this.printDialogWidgets.setAddressEntered(this.printDialogInstance.getLaserCutterSettings().getAddress());
    }

    public void printHandler(boolean SVG) {
        String result = this.printDialogInstance.print(SVG);
        if (!result.equals("passed")) {
            this.printDialogWidgets.setStatusLabelText(result);
        }
    }

    private void addJobHandler() {
        if (this.printDialogInstance.printInstancesNotEmpty()) {
            this.printDialogInstance.addSubInstance();
            this.printDialogWidgets.createButtons();
        }
    }

    private void confirmHandler() {
        this.printDialogWidgets.activateConfirm(false);
        this.printDialogWidgets.setStatusLabelText("");
        String result = this.printDialogInstance.continuePrint();
        if (!result.equals("passed")) {
            this.printDialogWidgets.setStatusLabelText(result);
            this.printDialogWidgets.activateAll(true);
        }
    }

    private void declineHandler() {
        this.printDialogWidgets.activateConfirm(false);
        this.printDialogWidgets.activateAll(true);
        this.printDialogWidgets.setStatusLabelText("");
    }

    private void selectInstanceHandler(int objectIndex) {
        this.printDialogWidgets.setButtonUnactive();
        this.printDialogInstance.selectInstanceByButtonID(objectIndex);
        this.printDialogWidgets.setActiveButton();
        this.printDialogWidgets.updateListBox();
    }

    void printComplete() {
        this.printDialogWidgets.activateAll(true);
    }

    public void confirmationPrint() {
        this.printDialogWidgets.activateAll(false);
        this.printDialogWidgets.activateConfirm(true);
    }

    void drawObjectLayout() {
        this.objectLayout.beginDraw();
        this.objectLayout.background(100);
        ArrayList<Object> drawShapes = new ArrayList();
        Transformation t = new Transformation(1.0f, new Vector2D(0.0f, 0.0f));
        if (this.printDialogInstance.printInstancesNotEmpty()) {
            drawShapes = this.printDialogInstance.getPlacedShapes();
        }
        int i = 0;
        while (i < drawShapes.size()) {
            ((Shape)drawShapes.get(i)).getGShape().draw2D(this.objectLayout, t);
            ++i;
        }
        this.objectLayout.endDraw();
        this.image((PImage)this.objectLayout, 0.0f, 0.0f);
    }

    public void mouseMoved() {
        if (this.printDialogInstance.printInstancesNotEmpty()) {
            Vector2D position = new Vector2D(this.mouseX, this.mouseY);
            Vector2D relativePosition = this.positionRelativeToView(position);
            for (Shape s : this.printDialogInstance.getPlacedShapes()) {
                s.getGShape().setSelected(s.getGShape().mouseOver(relativePosition));
            }
        }
    }

    public void mouseDragged() {
        if (this.printDialogInstance.printInstancesNotEmpty()) {
            for (Shape s : this.printDialogInstance.getPlacedShapes()) {
                if (!s.getGShape().isSelected() || !this.dragging) continue;
                Vector2D position = new Vector2D(this.mouseX, this.mouseY);
                Vector2D currentMousePosition = this.positionRelativeToView(position);
                s.getGShape().translate2D(currentMousePosition.sub(this.originalMousePosition));
                this.originalMousePosition.set(currentMousePosition);
            }
        }
    }

    public void mousePressed() {
        if (this.printDialogInstance.printInstancesNotEmpty()) {
            Vector2D mousePosition = new Vector2D(this.mouseX, this.mouseY);
            ArrayList<Shape> placedShapes = this.printDialogInstance.getPlacedShapes();
            ArrayList<Shape> shapes = new ArrayList<Shape>();
            int i = 0;
            while (i < placedShapes.size()) {
                shapes.add(placedShapes.get(i));
                ++i;
            }
            for (Shape s : shapes) {
                if (s.getGShape().isSelected() && this.mouseButton == 37) {
                    this.dragging = true;
                    Vector2D currentMousePosition = this.positionRelativeToView(mousePosition);
                    this.originalMousePosition.set(currentMousePosition);
                    continue;
                }
                if (!s.getGShape().isSelected() || this.mouseButton != 39) continue;
                this.printDialogInstance.unplaceShape(s);
                this.printDialogWidgets.updateListBox();
            }
        }
    }

    public void mouseReleased() {
        if (this.mouseButton == 37) {
            this.dragging = false;
        }
    }

    private Vector2D positionRelativeToView(Vector2D inPosition) {
        return inPosition.sub(this.view.getTopLeft());
    }

    public void setSize(int theHeight, int theWidth) {
        this.w = theWidth;
        this.h = theHeight;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }
}

