/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.printdialog.PrintDialogWindow;
import de.mcp.cutcad.printdialog.PrintInstance;
import de.mcp.cutcad.printdialog.Printer;
import de.mcp.cutcad.printdialog.SettingsLoader;
import de.mcp.cutcad.printdialog.lasercutter.LaserCutterSettings;
import java.util.ArrayList;

class PrintDialogInstance {
    private ArrayList<PrintInstance> printInstances;
    private LaserCutterSettings laserCutterSettings;
    private Printer printer;
    private PrintDialogWindow parent;
    private int selectedInstance;

    PrintDialogInstance(ArrayList<PrintInstance> printInstances, LaserCutterSettings lasercutterSettings) {
        this.printInstances = printInstances;
        if (printInstances.size() > 0) {
            this.selectedInstance = 0;
        }
        this.laserCutterSettings = lasercutterSettings;
    }

    LaserCutterSettings getLaserCutterSettings() {
        return this.laserCutterSettings;
    }

    void printComplete() {
        this.parent.printComplete();
    }

    void confirmationPrint() {
        this.parent.confirmationPrint();
    }

    String continuePrint() {
        return this.printer.continuePrint();
    }

    String print(boolean SVG) {
        this.printer = new Printer(this.printInstances, this.laserCutterSettings, this);
        if (SVG) {
            return this.printer.printSVG();
        }
        return this.printer.print();
    }

    ArrayList<Shape> getUnplacedShapes() {
        return this.printInstances.get(this.selectedInstance).getUnplacedShapes();
    }

    void setSelectedInstance(int selectedInstance) {
        this.selectedInstance = selectedInstance;
    }

    int getSelectedInstance() {
        return this.selectedInstance;
    }

    boolean printInstancesNotEmpty() {
        return this.printInstances.size() > 0;
    }

    void placeShape(int index) {
        Shape toBePlacedShape = this.printInstances.get(this.selectedInstance).getUnplacedShapes().get(index);
        this.printInstances.get(this.selectedInstance).placeShape(toBePlacedShape);
    }

    void addSubInstance() {
        this.printInstances.get(this.selectedInstance).addSubInstance();
    }

    void selectInstanceByButtonID(int objectIndex) {
        boolean instanceFound = false;
        int instance = 0;
        int subInstance = 0;
        while (!instanceFound) {
            if (subInstance + this.printInstances.get(instance).getNumberOfSubInstances() > objectIndex) {
                instanceFound = true;
                continue;
            }
            subInstance += this.printInstances.get(instance).getNumberOfSubInstances();
            ++instance;
        }
        subInstance = objectIndex - subInstance;
        this.selectedInstance = instance;
        this.printInstances.get(this.selectedInstance).setActiveSubInstance(subInstance);
    }

    int activeButtonNumber() {
        int buttonNumber = 0;
        int i = 0;
        while (i < this.selectedInstance) {
            buttonNumber += this.printInstances.get(i).getNumberOfSubInstances();
            ++i;
        }
        return buttonNumber += this.printInstances.get(this.selectedInstance).getSelectedSubInstance();
    }

    ArrayList<PrintInstance> getPrintInstances() {
        return this.printInstances;
    }

    ArrayList<Shape> getPlacedShapes() {
        return this.printInstances.get(this.selectedInstance).getPlacedShapes();
    }

    void unplaceShape(Shape s) {
        this.printInstances.get(this.selectedInstance).unplaceShape(s);
    }

    public void setPrintDialogWindow(PrintDialogWindow parent) {
        this.parent = parent;
    }

    public void persistSettings() {
        SettingsLoader settingsLoader = new SettingsLoader();
        settingsLoader.persistSettings(this.laserCutterSettings);
    }
}

