/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import de.mcp.cutcad.printdialog.PrintInstance;
import de.mcp.cutcad.printdialog.Printer;
import java.util.ArrayList;

class PrintConstraintChecker {
    private ArrayList<PrintInstance> toBeCheckedInstances;
    private Printer parent;
    private String overlapMessage;

    PrintConstraintChecker(ArrayList<PrintInstance> toBeCheckedInstances, Printer parent) {
        this.toBeCheckedInstances = toBeCheckedInstances;
        this.parent = parent;
    }

    public String checkPrintConstraints() {
        this.overlapMessage = "";
        if (this.toBeCheckedInstances.size() <= 0) {
            return "There are no shapes that can be printed";
        }
        return this.checkPlacedShapes();
    }

    private String checkPlacedShapes() {
        boolean conditionsMet = false;
        boolean placedShapeNoMaterial = false;
        boolean overLapped = false;
        int i = 0;
        while (i < this.toBeCheckedInstances.size()) {
            if (this.toBeCheckedInstances.get(i).checkPlacedShapes()) {
                if (!this.checkOverlap(i)) {
                    if (this.toBeCheckedInstances.get(i).getMaterial().getMaterialName().equals("Nothing 0,5 mm")) {
                        placedShapeNoMaterial = true;
                    } else {
                        conditionsMet = true;
                    }
                } else {
                    overLapped = true;
                    conditionsMet = false;
                }
            }
            ++i;
        }
        if (!conditionsMet) {
            if (overLapped) {
                return this.overlapMessage;
            }
            if (placedShapeNoMaterial) {
                return "No shape has been placed with a material assigned";
            }
            return "No shape has been placed";
        }
        if (placedShapeNoMaterial) {
            this.parent.confirmationPrint(0);
            return "There are object placed without material assigned, continue?";
        }
        return this.checkUnplacedShapes();
    }

    private boolean checkOverlap(int printInstanceIndex) {
        boolean overLapped = false;
        String result = this.toBeCheckedInstances.get(printInstanceIndex).checkOverlap();
        if (!result.equals("no overlap")) {
            this.overlapMessage = !this.overlapMessage.equals("") ? String.valueOf(this.overlapMessage) + ", " + result : String.valueOf(this.overlapMessage) + result;
            overLapped = true;
        }
        return overLapped;
    }

    String checkUnplacedShapes() {
        boolean unplacedShapesFound = false;
        String result = "";
        int i = 0;
        while (i < this.toBeCheckedInstances.size()) {
            if (this.toBeCheckedInstances.get(i).getUnplacedShapes().size() > 0) {
                result = result.equals("") ? "there are unplaced shapes for material(s): " + this.toBeCheckedInstances.get(i).getMaterial().getMaterialName() : String.valueOf(result) + ", " + this.toBeCheckedInstances.get(i).getMaterial().getMaterialName();
                unplacedShapesFound = true;
            }
            ++i;
        }
        if (unplacedShapesFound) {
            this.parent.confirmationPrint(1);
            return result;
        }
        return "passed";
    }
}

