/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model.shapes;

import de.mcp.cutcad.model.primitives.GShape;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import java.util.ArrayList;
import toxi.geom.Rect;

public class Trapezium
extends Shape {
    private static final long serialVersionUID = 8534996513132236907L;
    private int sizeXTop;
    private int sizeXBottom;
    private int sizeY;
    private static int counter = 0;
    private GShape basic;
    private ArrayList<Vector2D> basicShape;

    public Trapezium(Vector3D position, int sizeX, int sizeY) {
        this.sizeXTop = sizeX / 20 * 10;
        this.sizeXBottom = sizeX / 10 * 10;
        this.sizeY = (int)Math.sqrt(Math.pow(sizeY, 2.0) + Math.pow((this.sizeXBottom - this.sizeXTop) / 2, 2.0)) / 10 * 10;
        this.basicShape = new ArrayList();
        this.basicShape.add(new Vector2D(0.0f, 0.0f));
        this.basicShape.add(new Vector2D(sizeX, 0.0f));
        this.basicShape.add(new Vector2D(sizeX, sizeY));
        this.basicShape.add(new Vector2D(0.0f, sizeY));
        this.basic = new GShape(this.basicShape, position, this);
        this.basic.setName("Trapezium " + counter);
        ++counter;
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public void setName(String theValue) {
        this.getGShape().setName(theValue);
    }

    @Override
    public int getValue(int index) {
        if (index == 0) {
            return this.sizeXTop / 10;
        }
        if (index == 1) {
            return this.sizeXBottom / 10;
        }
        return this.sizeY / 10;
    }

    @Override
    public int getControlType(int index) {
        return 1;
    }

    @Override
    public String getNameOfControl(int index) {
        if (index == 0) {
            return "Top";
        }
        if (index == 1) {
            return "Bottom";
        }
        return "Side";
    }

    public void setValue0(int size) {
        this.sizeXTop = size * 10;
        this.recalculate();
    }

    public void setValue1(int size) {
        this.sizeXBottom = size * 10;
        this.recalculate();
    }

    public void setValue2(int size) {
        this.sizeY = size * 10;
        this.recalculate();
    }

    @Override
    public void recalculate() {
        if (Math.abs(this.sizeXTop - this.sizeXBottom) / 2 + 1 > this.sizeY) {
            this.sizeY = Math.abs(this.sizeXTop - this.sizeXBottom) / 2 + 1;
        }
        this.basicShape.set(1, new Vector2D(this.sizeXTop, 0.0f));
        this.basicShape.set(2, new Vector2D((float)this.sizeXTop / 2.0f + (float)(this.sizeXBottom / 2), (float)Math.sqrt(Math.pow(this.sizeY, 2.0) - Math.pow((this.sizeXBottom - this.sizeXTop) / 2, 2.0))));
        this.basicShape.set(3, new Vector2D(((float)this.sizeXTop - (float)this.sizeXBottom) / 2.0f, (float)Math.sqrt(Math.pow(this.sizeY, 2.0) - Math.pow((this.sizeXBottom - this.sizeXTop) / 2, 2.0))));
        this.basic.recalculate(this.basicShape);
    }

    public void setSize(Vector2D newSize) {
        this.sizeXTop = (int)newSize.x() / 20 * 10;
        this.sizeXBottom = (int)newSize.x() / 10 * 10;
        this.sizeY = (int)Math.sqrt(Math.pow((int)newSize.y(), 2.0) + Math.pow((this.sizeXBottom - this.sizeXTop) / 2, 2.0)) / 10 * 10;
        this.recalculate();
    }

    public void setShape(GShape gshape) {
        this.basic = gshape;
    }

    @Override
    public GShape getGShape() {
        return this.basic;
    }

    public boolean mouseOver(Vector2D mousePosition) {
        return this.basic.mouseOver(mousePosition);
    }

    public Rect getBoundingBox() {
        return null;
    }

    @Override
    public Shape copy() {
        Trapezium copy = new Trapezium(new Vector3D(this.basic.getPosition3D()), this.sizeXTop, this.sizeY);
        copy.setShape(this.basic.copy(copy));
        return copy;
    }

    @Override
    public Shape copyBaseForm() {
        Trapezium copy = new Trapezium(new Vector3D(this.basic.getPosition3D()), this.sizeXTop, this.sizeY);
        copy.setValue0(this.getValue(0));
        copy.setValue1(this.getValue(1));
        copy.setValue2(this.getValue(2));
        return copy;
    }
}

