/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model.shapes;

import de.mcp.cutcad.model.primitives.GShape;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import java.util.ArrayList;
import toxi.geom.Rect;

public class SymmetricPolygon
extends Shape {
    private static final long serialVersionUID = 4464413451997462017L;
    private int size;
    private int number;
    private static int counter = 0;
    private GShape basic;
    private ArrayList<Vector2D> basicShape;

    public SymmetricPolygon(Vector3D position, int sizeX, int sizeY) {
        this.size = (sizeX + sizeY) / 2 / 10 * 10;
        this.number = 3;
        this.basicShape = new ArrayList();
        this.basicShape.add(new Vector2D(0.0f, 0.0f));
        this.basicShape.add(new Vector2D(this.size, 0.0f));
        this.basicShape.add(new Vector2D(this.size, this.size));
        this.basic = new GShape(this.basicShape, position, this);
        this.basic.setName("SymmetricPolygon " + counter);
        ++counter;
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public void setName(String theValue) {
        this.getGShape().setName(theValue);
    }

    @Override
    public int getValue(int index) {
        if (index == 0) {
            return this.size / 10;
        }
        return this.number;
    }

    @Override
    public int getControlType(int index) {
        if (index == 0) {
            return 1;
        }
        return 3;
    }

    @Override
    public String getNameOfControl(int index) {
        if (index == 0) {
            return "Length of edges";
        }
        return "Number of edges";
    }

    @Override
    public void recalculate() {
        if (this.number < 3) {
            this.number = 3;
        }
        float alpha = (float)Math.PI * 2 / (float)this.number;
        float beta = ((float)Math.PI - alpha) / 2.0f;
        Vector2D diameter = new Vector2D((float)((double)this.size / Math.sin(alpha) * Math.sin(beta)), 0.0f);
        this.basicShape.clear();
        int i = 0;
        while (i < this.number) {
            this.basicShape.add(diameter.getRotated((float)i * alpha).add(new Vector2D(diameter.x(), diameter.y())));
            ++i;
        }
        this.basic.recalculate(this.basicShape);
    }

    public void setValue0(int size) {
        this.size = size * 10;
        this.recalculate();
    }

    public void setValue1(int number) {
        this.number = number;
        this.recalculate();
    }

    public void setSize(Vector2D newSize) {
        this.size = (int)((newSize.x() + newSize.y()) / 2.0f) / 10 * 10;
        this.recalculate();
    }

    public void setShape(GShape shape) {
        this.basic = shape;
    }

    @Override
    public GShape getGShape() {
        return this.basic;
    }

    public boolean mouseOver(Vector2D mousePosition) {
        return this.basic.mouseOver(mousePosition);
    }

    public Rect getBoundingBox() {
        return null;
    }

    @Override
    public Shape copy() {
        SymmetricPolygon copy = new SymmetricPolygon(new Vector3D(this.basic.getPosition3D()), this.size, this.size);
        copy.setShape(this.basic.copy(copy));
        return copy;
    }

    @Override
    public Shape copyBaseForm() {
        SymmetricPolygon copy = new SymmetricPolygon(new Vector3D(this.basic.getPosition3D()), this.size, this.size);
        copy.setValue0(this.getValue(0));
        copy.setValue1(this.getValue(1));
        return copy;
    }
}

