/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model.shapes;

import de.mcp.cutcad.model.primitives.GShape;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import java.io.Serializable;
import java.util.ArrayList;
import toxi.geom.Rect;

public class Rectangle
extends Shape
implements Serializable {
    private static final long serialVersionUID = -6511783713655746647L;
    private int sizeX;
    private int sizeY;
    private static int counter = 0;
    private GShape basic;
    private ArrayList<Vector2D> basicShape;

    public Rectangle(Vector3D position, int sizeX, int sizeY) {
        this.sizeX = sizeX / 10 * 10;
        this.sizeY = sizeY / 10 * 10;
        this.basicShape = new ArrayList();
        this.basicShape.add(new Vector2D(0.0f, 0.0f));
        this.basicShape.add(new Vector2D(sizeX, 0.0f));
        this.basicShape.add(new Vector2D(sizeX, sizeY));
        this.basicShape.add(new Vector2D(0.0f, sizeY));
        this.basic = new GShape(this.basicShape, position, this);
        this.basic.setName("Rectangle " + counter);
        ++counter;
    }

    public void setName(String theValue) {
        this.getGShape().setName(theValue);
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    @Override
    public int getValue(int index) {
        if (index == 0) {
            return this.sizeX / 10;
        }
        return this.sizeY / 10;
    }

    @Override
    public int getControlType(int index) {
        return 1;
    }

    @Override
    public String getNameOfControl(int index) {
        if (index == 0) {
            return "Width";
        }
        return "Heigth";
    }

    @Override
    public void recalculate() {
        this.basicShape.set(1, new Vector2D(this.sizeX, 0.0f));
        this.basicShape.set(2, new Vector2D(this.sizeX, this.sizeY));
        this.basicShape.set(3, new Vector2D(0.0f, this.sizeY));
        this.basic.recalculate(this.basicShape);
    }

    public void setValue0(int size) {
        this.sizeX = size * 10;
        this.recalculate();
    }

    public void setValue1(int size) {
        this.sizeY = size * 10;
        this.recalculate();
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSize(Vector2D newSize) {
        this.sizeX = (int)newSize.x() / 10 * 10;
        this.sizeY = (int)newSize.y() / 10 * 10;
        this.recalculate();
    }

    public void setShape(GShape shape) {
        this.basic = shape;
    }

    @Override
    public GShape getGShape() {
        return this.basic;
    }

    public boolean mouseOver(Vector2D mousePosition) {
        return this.basic.mouseOver(mousePosition);
    }

    public Rect getBoundingBox() {
        return null;
    }

    @Override
    public Shape copy() {
        Rectangle copy = new Rectangle(new Vector3D(this.basic.getPosition3D()), this.sizeX, this.sizeY);
        copy.setShape(this.basic.copy(copy));
        return copy;
    }

    @Override
    public Shape copyBaseForm() {
        Rectangle copy = new Rectangle(new Vector3D(this.basic.getPosition3D()), this.sizeX, this.sizeY);
        copy.setValue0(this.getValue(0));
        copy.setValue1(this.getValue(1));
        return copy;
    }
}

