/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model.primitives;

import de.mcp.cutcad.model.primitives.Vector2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;

public class Vector3D
implements Serializable {
    private static final long serialVersionUID = -4325576947506131537L;
    private transient Vec3D vector;

    public Vector3D() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vector3D(Vector3D vector) {
        this(vector.x(), vector.y(), vector.z());
    }

    public Vector3D(float x, float y, float z) {
        this(new Vec3D(x, y, z));
    }

    public Vector3D(Vec3D vector) {
        this.vector = vector;
    }

    public Vector3D copy() {
        return new Vector3D(this.vector.copy());
    }

    public boolean equals(Object o) {
        if (o instanceof Vector3D) {
            Vector3D otherVector = (Vector3D)o;
            return this.equals(otherVector.getVec3D());
        }
        if (o instanceof Vec3D) {
            return this.vector.equals(o);
        }
        return false;
    }

    public float x() {
        return this.vector.x();
    }

    public float y() {
        return this.vector.y();
    }

    public float z() {
        return this.vector.z();
    }

    public Vec3D getVec3D() {
        return this.vector;
    }

    public Vector3D getNormalized() {
        return new Vector3D(this.vector.getNormalized());
    }

    public Vector3D add(Vector3D vector) {
        return new Vector3D(this.vector.add(vector.getVec3D()));
    }

    public Vector3D addSelf(Vector3D vector) {
        this.vector.addSelf(vector.getVec3D());
        return this;
    }

    public Vector3D sub(Vector3D vector) {
        Vec3D otherVector = vector.getVec3D();
        return new Vector3D(this.vector.sub(otherVector));
    }

    public Vector3D scale(float s) {
        return new Vector3D(this.vector.scale(s));
    }

    public Vector3D cross(Vector3D vector) {
        Vec3D otherVector = vector.getVec3D();
        return new Vector3D(this.vector.cross(otherVector));
    }

    public Vector2D to2DXY() {
        return new Vector2D(this.vector.to2DXY());
    }

    public float angleBetween(Vector3D vector, boolean bool) {
        return this.vector.angleBetween((ReadonlyVec3D)vector.getVec3D(), bool);
    }

    public boolean equalsWithTolerance(Vector3D vector, float tolerance) {
        return this.vector.equalsWithTolerance((ReadonlyVec3D)vector.getVec3D(), tolerance);
    }

    public Vector3D rotateAroundAxis(Vector3D axis, float angle) {
        Vec3D axisVec3D = axis.getVec3D();
        return new Vector3D(this.vector.rotateAroundAxis((ReadonlyVec3D)axisVec3D, angle));
    }

    public boolean isZeroVector() {
        return this.vector.isZeroVector();
    }

    public Vector3D invert() {
        return new Vector3D(this.vector.invert());
    }

    public Vector3D normalize() {
        return new Vector3D(this.vector.normalize());
    }

    public Vector3D normalizeTo(float n) {
        return new Vector3D(this.vector.normalizeTo(n));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        float x = ois.readFloat();
        float y = ois.readFloat();
        float z = ois.readFloat();
        this.vector = new Vec3D(x, y, z);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeFloat(this.vector.x());
        oos.writeFloat(this.vector.y());
        oos.writeFloat(this.vector.z());
    }
}

