/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model.primitives;

import de.mcp.cutcad.algorithm.CreateTenons;
import de.mcp.cutcad.model.primitives.GShape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import de.mcp.cutcad.view.Drawable2D;
import de.mcp.cutcad.view.Drawable3D;
import de.mcp.cutcad.view.Transformation;
import java.io.Serializable;
import java.util.ArrayList;
import processing.core.PGraphics;
import toxi.geom.Polygon2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

public class Edge
implements Drawable2D,
Drawable3D,
Serializable {
    private static final long serialVersionUID = 924861921334437216L;
    private GShape gShape;
    private Vector3D p3D1;
    private Vector3D p3D2;
    private Vector2D v1;
    private Vector2D v2;
    private ArrayList<Vector2D> tenons;
    private float scalingFactor;
    private float scalingFactor3D;
    private float boundingBoxSize;
    private boolean isHighlighted;
    private boolean isLocked;
    private boolean isSelected;
    transient ArrayList<Vec2D> definingPoints;

    public Edge(GShape gShape, Vector3D p3D1, Vector3D p3D2, Vector2D v1, Vector2D v2) {
        this.gShape = gShape;
        this.p3D1 = p3D1;
        this.p3D2 = p3D2;
        this.v1 = v1;
        this.v2 = v2;
        CreateTenons.createOutlineOfEdge(this);
        this.isHighlighted = false;
        this.isSelected = false;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public GShape getGShape() {
        return this.gShape;
    }

    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.isHighlighted = highlighted;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public Vector2D getV1() {
        return this.v1;
    }

    public Vector2D getV2() {
        return this.v2;
    }

    public Vector3D getP3D1() {
        return this.p3D1;
    }

    public Vector3D getP3D2() {
        return this.p3D2;
    }

    public ArrayList<Vector2D> getTenons() {
        return this.tenons;
    }

    public void setLocked(boolean locked) {
        this.isLocked = locked;
    }

    public void setP3D1(Vector3D v) {
        this.p3D1 = v;
    }

    public void setP3D2(Vector3D v) {
        this.p3D2 = v;
    }

    public void setV1(Vector2D v) {
        this.getV1().set(v);
    }

    public void setV2(Vector2D v) {
        this.getV2().set(v);
    }

    public void setTenons(ArrayList<Vector2D> tenons) {
        this.tenons = tenons;
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        this.scalingFactor = t.getScale();
        this.boundingBoxSize = 4.0f / this.scalingFactor;
        if (this.isHighlighted()) {
            p.stroke(255.0f, 0.0f, 0.0f);
            p.noFill();
            p.strokeWeight(2.0f);
            p.beginShape();
            for (Vec2D vector : this.definingPoints) {
                p.vertex(vector.x(), vector.y());
            }
            p.endShape(2);
            p.strokeWeight(1.0f);
            p.fill(255);
            p.stroke(0);
        } else if (this.isSelected()) {
            p.stroke(0.0f, 255.0f, 0.0f);
            p.noFill();
            p.strokeWeight(2.0f);
            p.beginShape();
            for (Vec2D vector : this.definingPoints) {
                p.vertex(vector.x(), vector.y());
            }
            p.endShape(2);
            p.strokeWeight(1.0f);
            p.fill(255);
            p.stroke(0);
        }
    }

    @Override
    public void draw3D(PGraphics p, Transformation t) {
        this.scalingFactor3D = t.getScale();
        this.createBorderBox();
        if (this.isHighlighted()) {
            Vector3D offset = this.getGShape().getNormalVector().normalizeTo(this.getGShape().getThickness() / 2 + 4);
            p.stroke(255.0f, 0.0f, 0.0f);
            p.noFill();
            p.strokeWeight(2.0f);
            p.beginShape();
            Vector3D vector = this.p3D1.copy().add(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            vector = this.p3D2.copy().add(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            vector = this.p3D2.copy().sub(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            vector = this.p3D1.copy().sub(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            p.endShape(2);
            p.strokeWeight(1.0f);
            p.fill(255);
            p.stroke(0);
        } else if (this.isSelected()) {
            Vector3D offset = this.getGShape().getNormalVector().normalizeTo(this.getGShape().getThickness() / 2 + 4);
            p.stroke(0.0f, 255.0f, 0.0f);
            p.noFill();
            p.strokeWeight(2.0f);
            p.beginShape();
            Vector3D vector = this.p3D1.copy().add(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            vector = this.p3D2.copy().add(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            vector = this.p3D2.copy().sub(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            vector = this.p3D1.copy().sub(offset).scale(this.scalingFactor3D);
            p.vertex(vector.x(), vector.y(), vector.z());
            p.endShape(2);
            p.strokeWeight(1.0f);
            p.fill(255);
            p.stroke(0);
        }
    }

    public Vector2D getMid() {
        return new Vector2D((this.getV1().x() + this.getV2().x()) / 2.0f, (this.getV1().y() + this.getV2().y()) / 2.0f);
    }

    public boolean mouseOver(Vector2D mousePosition) {
        this.createBorderBox();
        Polygon2D borders = new Polygon2D(this.definingPoints);
        return borders.containsPoint((ReadonlyVec2D)mousePosition.scale(this.scalingFactor).getVec2D());
    }

    private void createBorderBox() {
        Vector2D perpendicularVector = this.getV2().sub(this.getV1()).perpendicular().getNormalizedTo(this.boundingBoxSize);
        this.definingPoints = new ArrayList();
        this.definingPoints.add(this.getV1().sub(perpendicularVector).add(this.getGShape().getPosition2D()).scale(this.scalingFactor).getVec2D());
        this.definingPoints.add(this.getV2().sub(perpendicularVector).add(this.getGShape().getPosition2D()).scale(this.scalingFactor).getVec2D());
        this.definingPoints.add(this.getV2().add(perpendicularVector).add(this.getGShape().getPosition2D()).scale(this.scalingFactor).getVec2D());
        this.definingPoints.add(this.getV1().add(perpendicularVector).add(this.getGShape().getPosition2D()).scale(this.scalingFactor).getVec2D());
    }

    public float getLength() {
        return this.getV2().distanceTo(this.getV1());
    }

    public void scale2D(float scaleFactor) {
        this.v1 = this.v1.scale(scaleFactor);
        this.v2 = this.v2.scale(scaleFactor);
        ArrayList<Vector2D> newTenons = new ArrayList<Vector2D>();
        int i = 0;
        while (i < this.tenons.size()) {
            newTenons.add(this.tenons.get(i).scale(scaleFactor));
            ++i;
        }
        this.tenons = newTenons;
    }
}

