/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model;

import de.mcp.cutcad.application.Pluggable;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.TriangleMesh;

public class STLMesh
implements Pluggable {
    private TriangleMesh STLMesh;
    private float X = 0.0f;
    private float Y = 0.0f;
    private float Z = 0.0f;
    private float rotX;
    private float rotY;
    private float rotZ;
    private float rotDelX;
    private float rotDelY;
    private float rotDelZ;
    private boolean changedPos = false;
    private boolean changedRot;
    private boolean stlImported = false;

    public TriangleMesh getSTLMesh() {
        return this.STLMesh;
    }

    public void setSTLMesh(TriangleMesh sTLMesh) {
        this.STLMesh = sTLMesh;
        this.changedPos = true;
        this.stlImported = true;
    }

    private void setX(float x) {
        this.X = x;
        this.changedPos = true;
    }

    private void setY(float y) {
        this.Y = y;
        this.changedPos = true;
    }

    private void setZ(float z) {
        this.Z = z;
        this.changedPos = true;
    }

    public void setValue0(int size) {
        this.setX(size * 10);
    }

    public void setValue1(int size) {
        this.setY(size * 10);
    }

    public void setValue2(int size) {
        this.setZ(size * 10);
    }

    private void setRotX(float rotX) {
        this.rotDelX = rotX - this.rotX;
        this.rotX = rotX;
        this.changedRot = true;
    }

    private void setRotY(float rotY) {
        this.rotDelY = rotY - this.rotY;
        this.rotY = rotY;
        this.changedRot = true;
    }

    private void setRotZ(float rotZ) {
        this.rotDelZ = rotZ - this.rotZ;
        this.rotZ = rotZ;
        this.changedRot = true;
    }

    public void setValue3(int size) {
        this.setRotX(size);
    }

    public void setValue4(int size) {
        this.setRotY(size);
    }

    public void setValue5(int size) {
        this.setRotZ(size);
    }

    public boolean isPosChanged() {
        return this.changedPos;
    }

    public boolean isStlImported() {
        return this.stlImported;
    }

    public boolean isRotChanged() {
        return this.changedRot;
    }

    @Override
    public int getNumberOfControls() {
        return 6;
    }

    @Override
    public int getValue(int i) {
        switch (i) {
            case 0: {
                return (int)(this.X / 10.0f);
            }
            case 1: {
                return (int)(this.Y / 10.0f);
            }
            case 2: {
                return (int)(this.Z / 10.0f);
            }
            case 3: {
                return (int)this.rotX;
            }
            case 4: {
                return (int)this.rotY;
            }
            case 5: {
                return (int)this.rotZ;
            }
        }
        return 0;
    }

    @Override
    public int getControlType(int index) {
        if (index < 3) {
            return 2;
        }
        return 0;
    }

    @Override
    public String getNameOfControl(int index) {
        switch (index) {
            case 0: {
                return "Position X";
            }
            case 1: {
                return "Position Y";
            }
            case 2: {
                return "Position Z";
            }
            case 3: {
                return "Rotation X";
            }
            case 4: {
                return "Rotation Y";
            }
            case 5: {
                return "Rotation Z";
            }
        }
        return "error";
    }

    public void center() {
        this.STLMesh.center((ReadonlyVec3D)new Vec3D(this.X, this.Y, this.Z));
        this.changedPos = false;
    }

    public void rotate() {
        this.STLMesh.rotateX((float)Math.toRadians(this.rotDelX));
        this.STLMesh.rotateY((float)Math.toRadians(this.rotDelY));
        this.STLMesh.rotateZ((float)Math.toRadians(this.rotDelZ));
        this.rotDelX = 0.0f;
        this.rotDelY = 0.0f;
        this.rotDelZ = 0.0f;
        this.changedRot = false;
    }

    @Override
    public void setActive(boolean b) {
    }
}

