/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model;

import de.mcp.cutcad.algorithm.CreateTenons;
import de.mcp.cutcad.algorithm.RotateAdjectantShapes;
import de.mcp.cutcad.application.Pluggable;
import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.GShape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import de.mcp.cutcad.view.Drawable2D;
import de.mcp.cutcad.view.Transformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import processing.core.PGraphics;
import toxi.geom.Polygon2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

public class Connection
implements Drawable2D,
Serializable,
Pluggable {
    private static final long serialVersionUID = 4881854804310087106L;
    private Edge masterEdge;
    private Edge slaveEdge;
    private float angle = 400.0f;
    private boolean isSelected;
    private boolean isActive;
    private static List<Connection> connections;
    private float tolerance = 5.0f;
    private float scalingFactor;
    private float boundingBoxSize;

    public Connection(List<Connection> connections) {
        Connection.connections = connections;
        this.isSelected = false;
        this.isActive = false;
    }

    public Connection(Edge masterEdge, Edge slaveEdge, List<Connection> connections) {
        this.masterEdge = masterEdge;
        this.slaveEdge = slaveEdge;
        Connection.connections = connections;
        this.isSelected = false;
    }

    public static List<Connection> getConnections() {
        return connections;
    }

    public Edge getMasterEdge() {
        return this.masterEdge;
    }

    public Edge getSlaveEdge() {
        return this.slaveEdge;
    }

    public void setMasterEdge(Edge e) {
        this.masterEdge = e;
    }

    public void setSlaveEdge(Edge e) {
        this.slaveEdge = e;
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        this.scalingFactor = t.getScale();
        this.boundingBoxSize = 4.0f / this.scalingFactor;
        Vector2D mid1 = this.getMasterEdge().getMid().add(this.getMasterEdge().getGShape().getPosition2D()).scale(this.scalingFactor);
        Vector2D mid2 = this.getSlaveEdge().getMid().add(this.getSlaveEdge().getGShape().getPosition2D()).scale(this.scalingFactor);
        if (this.isSelected) {
            p.stroke(255.0f, 0.0f, 0.0f);
        } else if (this.isActive) {
            p.stroke(125.0f, 0.0f, 0.0f);
        } else {
            p.stroke(60.0f, 60.0f, 60.0f);
        }
        p.line(mid1.x(), mid1.y(), mid2.x(), mid2.y());
        p.stroke(0);
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean mouseOver(Vector2D mousePosition) {
        Vector2D mid1 = this.getMasterEdge().getMid().add(this.getMasterEdge().getGShape().getPosition2D());
        Vector2D mid2 = this.getSlaveEdge().getMid().add(this.getSlaveEdge().getGShape().getPosition2D());
        Vector2D perpendicularVector = mid1.sub(mid2).perpendicular().getNormalizedTo(this.boundingBoxSize);
        ArrayList<Vec2D> definingPoints = new ArrayList<Vec2D>();
        definingPoints.add(mid1.sub(perpendicularVector).scale(this.scalingFactor).getVec2D());
        definingPoints.add(mid2.sub(perpendicularVector).scale(this.scalingFactor).getVec2D());
        definingPoints.add(mid2.add(perpendicularVector).scale(this.scalingFactor).getVec2D());
        definingPoints.add(mid1.add(perpendicularVector).scale(this.scalingFactor).getVec2D());
        Polygon2D borders = new Polygon2D(definingPoints);
        return borders.containsPoint((ReadonlyVec2D)mousePosition.scale(this.scalingFactor).getVec2D());
    }

    public void undoConnection() {
        CreateTenons.createOutlineOfEdge(this.masterEdge);
        CreateTenons.createOutlineOfEdge(this.slaveEdge);
        this.lockConnection(false);
        if (this.masterEdge.getGShape().getNumberOfConnections() == 0) {
            this.masterEdge.getGShape().recalculate(this.masterEdge.getGShape().getVertices());
        }
        if (this.slaveEdge.getGShape().getNumberOfConnections() == 0) {
            this.slaveEdge.getGShape().recalculate(this.slaveEdge.getGShape().getVertices());
        }
        if (this.masterEdge.getGShape().getNumberOfConnections() == 1) {
            this.recalculateConnectedEdge(this.masterEdge);
        }
        if (this.slaveEdge.getGShape().getNumberOfConnections() == 1) {
            this.recalculateConnectedEdge(this.slaveEdge);
        }
    }

    private void recalculateConnectedEdge(Edge edge) {
        GShape shape = edge.getGShape();
        for (Edge e : shape.getEdges()) {
            for (Connection c : Connection.getConnections()) {
                if (c == this) continue;
                if (c.getMasterEdge() == e) {
                    this.connectEdges(c.getSlaveEdge(), c.getMasterEdge(), (float)Math.PI);
                }
                if (c.getSlaveEdge() != e) continue;
                this.connectEdges(c.getMasterEdge(), c.getSlaveEdge(), (float)Math.PI);
            }
        }
    }

    public String connect() {
        if (this.masterEdge.getGShape() == this.slaveEdge.getGShape()) {
            return "Do not connect two sides of the same shape!";
        }
        if (this.masterEdge.isLocked() || this.slaveEdge.isLocked()) {
            return "At least one edge is already connected!";
        }
        if (Math.abs(this.masterEdge.getLength() - this.slaveEdge.getLength()) > this.tolerance) {
            return "Edges have different length!";
        }
        if (this.slaveEdge.getGShape().getNumberOfConnections() == 0) {
            this.connectEdges(this.masterEdge, this.slaveEdge, (float)Math.PI);
            this.lockConnection(true);
            return "Connection created!";
        }
        if (this.masterEdge.getGShape().getNumberOfConnections() == 0) {
            this.connectEdges(this.slaveEdge, this.masterEdge, (float)Math.PI);
            this.lockConnection(true);
            return "Connection created!";
        }
        if (this.isEqualEdge(this.masterEdge, this.slaveEdge)) {
            CreateTenons.createOutlineOfEdge(this.masterEdge, this.slaveEdge);
            this.lockConnection(true);
            return "Connection created!";
        }
        if ((this.masterEdge.getGShape().getNumberOfConnections() == 1 || this.slaveEdge.getGShape().getNumberOfConnections() == 1) && (this.masterEdge.getP3D1().equalsWithTolerance(this.slaveEdge.getP3D1(), this.tolerance) || this.masterEdge.getP3D1().equalsWithTolerance(this.slaveEdge.getP3D2(), this.tolerance) || this.masterEdge.getP3D2().equalsWithTolerance(this.slaveEdge.getP3D1(), this.tolerance) || this.masterEdge.getP3D2().equalsWithTolerance(this.slaveEdge.getP3D2(), this.tolerance))) {
            if (RotateAdjectantShapes.rotateBothShapes(this, this.masterEdge, this.slaveEdge)) {
                return "Connection created!";
            }
            return "Couldn't rotate the shapes until both edges are at the same position";
        }
        return "I'm sorry,... I'm afraid I can't do that.";
    }

    private boolean isEqualEdge(Edge masterEdge, Edge slaveEdge) {
        if (masterEdge.getP3D1().equalsWithTolerance(slaveEdge.getP3D2(), this.tolerance) && masterEdge.getP3D2().equalsWithTolerance(slaveEdge.getP3D1(), this.tolerance)) {
            return true;
        }
        return masterEdge.getP3D1().equalsWithTolerance(slaveEdge.getP3D1(), this.tolerance) && masterEdge.getP3D2().equalsWithTolerance(slaveEdge.getP3D2(), this.tolerance);
    }

    public void lockConnection(boolean locked) {
        int addNumber = locked ? 1 : -1;
        this.slaveEdge.getGShape().addNumberOfConnections(addNumber);
        this.masterEdge.getGShape().addNumberOfConnections(addNumber);
        this.slaveEdge.setLocked(locked);
        this.masterEdge.setLocked(locked);
    }

    public void setAngle(float angle) {
        if (this.slaveEdge.getGShape().getNumberOfConnections() <= 1) {
            this.angle = angle;
            this.connectEdges(this.masterEdge, this.slaveEdge, (float)(Math.toRadians(angle) - Math.PI));
        } else if (this.masterEdge.getGShape().getNumberOfConnections() <= 1) {
            this.angle = angle;
            this.connectEdges(this.slaveEdge, this.masterEdge, (float)(Math.toRadians(angle) - Math.PI));
        }
    }

    public void connectEdges(Edge masterEdge, Edge slaveEdge, float angle) {
        GShape master = masterEdge.getGShape();
        GShape slave = slaveEdge.getGShape();
        this.alignEdges(slave, masterEdge, slaveEdge);
        Vector3D toOrigin = slaveEdge.getP3D1().scale(-1.0f);
        slave.translate3D(toOrigin);
        this.alignShapes(master, slave, masterEdge, slaveEdge);
        Vector3D rotationAxis = slaveEdge.getP3D2().getNormalized();
        slave.rotateAroundAxis(rotationAxis, (float)((double)angle - Math.PI));
        Vector3D toMaster = masterEdge.getP3D1().sub(slaveEdge.getP3D1());
        slave.translate3D(toMaster);
        if (!masterEdge.getP3D2().equals(slaveEdge.getP3D2())) {
            Vector3D newToMaster = masterEdge.getP3D1().sub(slaveEdge.getP3D2());
            slave.translate3D(newToMaster);
        }
        CreateTenons.createOutlineOfEdge(masterEdge, slaveEdge);
    }

    private void alignEdges(GShape slave, Edge masterEdge, Edge slaveEdge) {
        Vector3D masterEdgeDirection = masterEdge.getP3D2().sub(masterEdge.getP3D1());
        Vector3D slaveEdgeDirection = slaveEdge.getP3D2().sub(slaveEdge.getP3D1());
        float angle = this.safeAngleBetween(masterEdgeDirection, slaveEdgeDirection);
        Vector3D normalVector = slaveEdgeDirection.cross(masterEdgeDirection).getNormalized();
        while (normalVector.equals(new Vector3D(0.0f, 0.0f, 0.0f))) {
            normalVector = masterEdgeDirection.cross(new Vector3D((float)Math.random(), (float)Math.random(), (float)Math.random())).getNormalized();
        }
        slave.rotateAroundAxis(normalVector, (float)(Math.PI + (double)angle));
    }

    private float safeAngleBetween(Vector3D masterEdgeDirection, Vector3D slaveEdgeDirection) {
        float angle = slaveEdgeDirection.angleBetween(masterEdgeDirection, true);
        if (Float.isNaN(angle)) {
            angle = slaveEdgeDirection.add(masterEdgeDirection).equalsWithTolerance(new Vector3D(0.0f, 0.0f, 0.0f), 0.1f) ? (float)Math.PI : 0.0f;
        }
        return angle;
    }

    private void alignShapes(GShape master, GShape slave, Edge masterEdge, Edge slaveEdge) {
        Vector3D slaveEdgeDirection = slaveEdge.getP3D2().getNormalized();
        float angleBetweenNormals = this.calculateAngleBetweenNormals(master, slave);
        slave.rotateAroundAxis(slaveEdgeDirection, angleBetweenNormals);
        if (this.calculateAngleBetweenNormals(master, slave) > 0.001f) {
            slave.rotateAroundAxis(slaveEdgeDirection, -2.0f * angleBetweenNormals);
        }
    }

    private float calculateAngleBetweenNormals(GShape master, GShape slave) {
        Vector3D masterNormal = master.getNormalVector();
        Vector3D slaveNormal = slave.getNormalVector();
        return this.safeAngleBetween(masterNormal, slaveNormal);
    }

    public float getAngle() {
        if (this.angle == 400.0f) {
            this.angle = (float)Math.toDegrees(this.calculateAngleBetweenNormals(this.masterEdge.getGShape(), this.slaveEdge.getGShape()));
        }
        return this.angle;
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public int getNumberOfControls() {
        return 1;
    }

    @Override
    public int getValue(int index) {
        return (int)this.getAngle();
    }

    @Override
    public int getControlType(int index) {
        return 0;
    }

    @Override
    public String getNameOfControl(int index) {
        return "Angle";
    }

    public void setValue0(int size) {
        this.setAngle(size);
    }
}

