/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model;

import de.mcp.cutcad.model.Material;
import java.io.File;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.data.XML;

public class AllMaterials
extends PApplet {
    private static final long serialVersionUID = -8801211971447138231L;
    private static ArrayList<Material> materials = new ArrayList();
    private static int baseMaterialIndex = 0;
    private static String baseMaterialName;
    private static int baseMaterialThickness;

    public AllMaterials() {
        XML setting = this.loadXML("Settings.xml");
        baseMaterialThickness = setting.getChild("standardMaterial").getChild("thickness").getIntContent() / 10;
        baseMaterialName = setting.getChild("standardMaterial").getChild("name").getContent();
    }

    public void addMaterialsFromFile(String path) {
        if (materials.isEmpty()) {
            materials.add(new Material("Nothing", 5, this.color(255, 255, 255, 0), 0, 100, 0, 500));
        }
        File[] files = new File(path).listFiles();
        int i = 0;
        while (i < files.length) {
            XML material = this.loadXML(String.valueOf(path) + File.separator + files[i].getName());
            XML identity = material.getChild("identity");
            String name = identity.getContent();
            int redColor = identity.getInt("red");
            int blueColor = identity.getInt("green");
            int greenColor = identity.getInt("blue");
            int alphaChannel = identity.getInt("alpha");
            int materialColor = this.color(redColor, blueColor, greenColor, alphaChannel);
            XML[] differentThickness = material.getChildren("thickness");
            int j = 0;
            while (j < differentThickness.length) {
                int thickness = differentThickness[j].getInt("value") / 10;
                int power = differentThickness[j].getChild("cut").getChild("power").getIntContent();
                int speed = differentThickness[j].getChild("cut").getChild("speed").getIntContent();
                int focus = differentThickness[j].getChild("cut").getChild("focus").getIntContent();
                int frequency = differentThickness[j].getChild("cut").getChild("frequency").getIntContent();
                materials.add(new Material(name, thickness, materialColor, power, speed, focus, frequency));
                if (name.equals(baseMaterialName) && thickness == baseMaterialThickness) {
                    baseMaterialIndex = materials.size() - 1;
                }
                ++j;
            }
            ++i;
        }
    }

    public void addMaterialsFromVisicutFile() {
    }

    public static ArrayList<Material> getMaterials() {
        return materials;
    }

    public static void setBaseMaterial(Material material) {
        baseMaterialIndex = materials.indexOf(material);
    }

    public static Material getBaseMaterial() {
        return materials.get(baseMaterialIndex);
    }
}

