/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.objectManipulation;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.Connection;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Cutout;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;

public class SelectTool
extends Tool {
    boolean dragging = false;
    boolean draggingCutout = false;
    Vector2D originalMousePosition = new Vector2D(0.0f, 0.0f);

    public SelectTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
    }

    @Override
    public String getIconName() {
        return "Select.svg";
    }

    @Override
    public void mouseButtonPressed(Vector2D position, int button) {
        Vector2D currentMousePosition;
        boolean noneSelected = true;
        for (Shape shape : this.objectContainer.allShapes()) {
            if (this.view.containsPoint(position) && shape.getGShape().isSelected() && button == 37) {
                this.application.properties.show();
                this.application.properties.plugTo(shape);
                continue;
            }
            if (!this.view.containsPoint(position) || !shape.getGShape().isSelected() || button != 39) continue;
            this.dragging = true;
            currentMousePosition = this.view.positionRelativeToView(position);
            this.originalMousePosition.set(currentMousePosition);
            noneSelected = false;
        }
        for (Cutout cutout : this.objectContainer.allCutouts()) {
            if (this.view.containsPoint(position) && cutout.isSelected() && button == 37) {
                this.application.properties.show();
                this.application.properties.plugTo(cutout);
                continue;
            }
            if (!this.view.containsPoint(position) || !cutout.isSelected() || button != 39) continue;
            this.draggingCutout = true;
            currentMousePosition = this.view.positionRelativeToView(position);
            this.originalMousePosition.set(currentMousePosition);
            noneSelected = false;
        }
        for (Connection connection : this.objectContainer.allConnections()) {
            if (!this.view.containsPoint(position) || !connection.isSelected() || button != 37) continue;
            this.application.properties.show();
            this.application.properties.plugTo(connection);
        }
        if (this.view.containsPoint(position) && button == 39 && noneSelected) {
            this.dragging = true;
            Vector2D vector2D = this.view.positionRelativeToView(position);
            this.originalMousePosition.set(vector2D);
        }
    }

    @Override
    public void mouseButtonReleased(Vector2D position, int button) {
        if (button == 39) {
            this.dragging = false;
            this.draggingCutout = false;
        }
    }

    @Override
    public void mouseMoved(Vector2D position) {
        if (this.view.containsPoint(position)) {
            Vector2D currentMousePosition;
            Vector2D relativePosition = this.view.positionRelativeToView(position);
            this.application.displayMousePosition(relativePosition.scale(0.1f));
            boolean noneSelected = true;
            for (Shape shape : this.objectContainer.allShapes()) {
                shape.getGShape().setSelected(shape.getGShape().mouseOver(relativePosition));
                if (!shape.getGShape().isSelected() || !this.dragging) continue;
                currentMousePosition = this.view.positionRelativeToView(position);
                shape.getGShape().translate2D(currentMousePosition.sub(this.originalMousePosition));
                this.originalMousePosition.set(currentMousePosition);
                noneSelected = false;
            }
            for (Cutout cutout : this.objectContainer.allCutouts()) {
                cutout.setSelected(cutout.mouseOver(relativePosition));
                if (cutout.isSelected()) {
                    cutout.getMasterShape().getGShape().setSelected(false);
                }
                if (!cutout.isSelected() || !this.draggingCutout) continue;
                currentMousePosition = this.view.positionRelativeToView(position);
                cutout.translate2D(currentMousePosition.sub(this.originalMousePosition));
                this.originalMousePosition.set(currentMousePosition);
                noneSelected = false;
            }
            for (Connection connection : this.objectContainer.allConnections()) {
                connection.setSelected(connection.mouseOver(relativePosition));
                if (!connection.isSelected()) continue;
                noneSelected = false;
            }
            if (noneSelected && this.dragging) {
                Vector2D vector2D = this.view.positionRelativeToView(position);
                this.application.transform2D.translate(vector2D.sub(this.originalMousePosition));
                this.originalMousePosition.set(this.view.positionRelativeToView(position));
            }
        } else {
            for (Shape s : this.objectContainer.allShapes()) {
                s.getGShape().setSelected(false);
            }
        }
    }

    @Override
    public void toolWasSelected() {
        this.application.displayStatus("Click left on a shape to select it, drag a shape with the right mouse button to move it and drag anywhere on the 2D view to move the camera");
        super.toolWasSelected();
    }

    @Override
    public void toolWasUnselected() {
        this.application.displayStatus("");
        this.application.properties.hide();
        super.toolWasUnselected();
    }
}

