/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.objectManipulation;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.GShape;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.shapes.CopyShape;
import de.mcp.cutcad.view.Transformation;
import processing.core.PGraphics;

public class CopyTool
extends Tool {
    GShape master;
    Vector2D lastMousePosition = new Vector2D(0.0f, 0.0f);
    boolean selected = false;
    Shape copyShape;
    Shape previewShape;

    public CopyTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
    }

    @Override
    public String getIconName() {
        return "Copy.svg";
    }

    @Override
    public void mouseButtonPressed(Vector2D position, int button) {
        if (this.view.containsPoint(position)) {
            if (!this.selected) {
                for (Shape s : this.objectContainer.allShapes()) {
                    if (!s.getGShape().isSelected() || button != 37) continue;
                    this.application.displayStatus("Shape selected! Use the left mouse button to create copies or use the right mouse button to clear the selection");
                    this.master = s.getGShape();
                    this.previewShape = new CopyShape(this.master.getVertices(), this.lastMousePosition, this.master.getName());
                    this.previewShape.getGShape().setMaterial(this.master.getMaterial());
                    this.selected = true;
                }
            } else if (button == 39) {
                this.application.displayStatus("Select the shape you want to copy");
                this.copyShape = null;
                this.selected = false;
                this.previewShape = null;
            } else {
                this.application.displayStatus("Copy created! Use the left mouse button to create copies or use the right mouse button to clear the selection");
                Shape copy = this.master.copyCompleteStructure();
                copy.getGShape().setPosition2D(this.lastMousePosition);
                copy.recalculate();
                this.objectContainer.addShape(copy);
            }
        }
    }

    @Override
    public void mouseMoved(Vector2D position) {
        if (this.view.containsPoint(position)) {
            this.lastMousePosition = this.view.positionRelativeToView(position);
            this.application.displayMousePosition(this.lastMousePosition.scale(0.1f));
            for (Shape s : this.objectContainer.allShapes()) {
                s.getGShape().setSelected(s.getGShape().mouseOver(this.lastMousePosition));
            }
        } else {
            for (Shape s : this.objectContainer.allShapes()) {
                s.getGShape().setSelected(false);
            }
        }
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        if (this.selected) {
            this.previewShape.getGShape().setPosition2D(this.lastMousePosition);
            this.previewShape.getGShape().draw2D(p, t);
        }
    }

    @Override
    public void toolWasSelected() {
        this.application.displayStatus("Select the shape you want to copy");
        super.toolWasSelected();
    }

    @Override
    public void toolWasUnselected() {
        this.application.displayStatus("");
        this.copyShape = null;
        this.selected = false;
        this.previewShape = null;
        super.toolWasUnselected();
    }
}

