/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.objectManipulation;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.Connection;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.view.Transformation;
import processing.core.PGraphics;

public class ConnectTool
extends Tool {
    boolean selectedFirst = false;
    Vector2D lastMousePosition;
    Connection previewConnection;
    private float scalingFactor;
    private String lastMessage;

    public ConnectTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
    }

    @Override
    public String getIconName() {
        return "Connect.svg";
    }

    @Override
    public void mouseButtonPressed(Vector2D position, int button) {
        for (Edge e : this.objectContainer.allEdges()) {
            if (!e.isHighlighted() || button != 37) continue;
            if (!this.selectedFirst) {
                this.application.displayStatus("Select another edge to connect it to the first edge");
                this.lastMessage = "Select another edge to connect it to the first edge";
                this.previewConnection = new Connection(this.objectContainer.allConnections());
                this.previewConnection.setMasterEdge(e);
                e.setSelected(true);
                this.selectedFirst = true;
                continue;
            }
            this.previewConnection.setSlaveEdge(e);
            String connectMessage = this.previewConnection.connect();
            if (connectMessage == "Connection created!") {
                this.application.displayStatus("Connection created! If you want to create another connection, select another edge");
                this.lastMessage = "Connection created! If you want to create another connection, select another edge";
                this.objectContainer.addConnection(this.previewConnection);
            } else {
                this.application.displayStatus("Could not create the connection!");
                this.application.displayStatus(connectMessage);
                this.lastMessage = connectMessage;
            }
            this.previewConnection.getMasterEdge().setSelected(false);
            this.previewConnection = null;
            this.selectedFirst = false;
        }
    }

    @Override
    public void mouseMoved(Vector2D position) {
        this.application.displayStatus(this.lastMessage);
        this.lastMousePosition = position;
        Vector2D relativePosition = this.view.positionRelativeToView(position);
        this.application.displayMousePosition(relativePosition.scale(0.1f));
        for (Edge e : this.objectContainer.allEdges()) {
            Edge firstEdge;
            if (e.mouseOver(relativePosition)) {
                this.application.displayStatus("Length of this edge: " + e.getLength() / 10.0f + " mm");
            }
            boolean canBeSelected = e.mouseOver(relativePosition);
            if (this.previewConnection != null && (firstEdge = this.previewConnection.getMasterEdge()) != null) {
                canBeSelected = canBeSelected && Math.abs(firstEdge.getLength() - e.getLength()) < 5.0f;
            }
            e.setHighlighted(canBeSelected);
        }
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        this.scalingFactor = t.getScale();
        if (this.selectedFirst) {
            Vector2D mid = this.previewConnection.getMasterEdge().getMid().add(this.previewConnection.getMasterEdge().getGShape().getPosition2D());
            p.stroke(255.0f, 0.0f, 0.0f);
            Vector2D lineStart = mid.scale(this.scalingFactor);
            Vector2D lineEnd = this.view.positionRelativeToView(this.lastMousePosition).scale(this.scalingFactor);
            p.line(lineStart.x(), lineStart.y(), lineEnd.x(), lineEnd.y());
            p.stroke(0);
        }
    }

    @Override
    public void toolWasSelected() {
        this.application.displayStatus("Select an edge to create a connection");
        this.lastMessage = "Select an edge to create a connection";
        super.toolWasSelected();
    }

    @Override
    public void toolWasUnselected() {
        this.application.displayStatus("");
        this.lastMessage = "";
        this.selectedFirst = false;
        if (this.previewConnection != null) {
            this.previewConnection.getMasterEdge().setSelected(false);
        }
        this.previewConnection = null;
        super.toolWasUnselected();
    }
}

