/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.objectImport;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.STLMesh;
import de.mcp.cutcad.view.FileDialogDelegate;
import de.mcp.cutcad.view.OpenFileDialog;
import java.io.File;
import processing.core.PApplet;
import toxi.geom.mesh.STLReader;
import toxi.geom.mesh.TriangleMesh;

public class ImportSTLTool
extends Tool
implements FileDialogDelegate {
    private STLMesh mesh;

    public ImportSTLTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
        this.mesh = container.getSTLMesh();
    }

    @Override
    public String getIconName() {
        return "LoadSTL.svg";
    }

    @Override
    public void toolWasSelected() {
        super.toolWasSelected();
        OpenFileDialog dialog = new OpenFileDialog(this);
        dialog.showDialog("Select a STL file to process:");
    }

    @Override
    public boolean canStaySelected() {
        return false;
    }

    @Override
    public void fileWasSelected(File theFile) {
        if (theFile != null && PApplet.checkExtension((String)theFile.getAbsolutePath()).equals("stl")) {
            String filePath = theFile.getPath();
            TriangleMesh loadedMesh = this.importMeshFromPath(filePath);
            this.mesh.setSTLMesh(loadedMesh.scale(10.0f));
        }
    }

    private TriangleMesh importMeshFromPath(String thePath) {
        STLReader stlReader = new STLReader();
        TriangleMesh theMesh = (TriangleMesh)stlReader.loadBinary(thePath, STLReader.TRIANGLEMESH);
        return theMesh;
    }
}

