/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.drawing;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.shapes.SymmetricPolygon;
import de.mcp.cutcad.view.Transformation;
import processing.core.PGraphics;

public class SymmetricPolygonTool
extends Tool {
    boolean isDrawing = false;
    Vector2D startCoord;
    SymmetricPolygon previewRectangle;

    public SymmetricPolygonTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
    }

    @Override
    public String getIconName() {
        return "DrawSymmetricPolygon.svg";
    }

    @Override
    public void mouseButtonPressed(Vector2D position, int button) {
        if (this.view.containsPoint(position)) {
            this.application.displayStatus("Use the mouse to drag the symmetric polygon to the size that you want");
            this.isDrawing = true;
            this.startCoord = this.view.positionRelativeToView(position);
            this.previewRectangle = new SymmetricPolygon(this.startCoord.to3DXY(), 0, 0);
        }
    }

    @Override
    public void mouseButtonReleased(Vector2D position, int button) {
        if (this.isDrawing && this.view.containsPoint(position)) {
            if (this.view.positionRelativeToView(position).equals(this.startCoord)) {
                this.previewRectangle = null;
                this.isDrawing = false;
            } else {
                this.application.displayStatus("Symmetric polygon created! If you want to add another rectangle, click and hold the left mousebutton anywhere on the 2D view");
                Vector2D endCoord = this.view.positionRelativeToView(position);
                Vector2D rectSize = endCoord.sub(this.startCoord);
                this.previewRectangle.setSize(rectSize);
                this.objectContainer.addShape(this.previewRectangle);
                this.previewRectangle = null;
                this.isDrawing = false;
            }
        }
    }

    @Override
    public void mouseMoved(Vector2D position) {
        Vector2D relativePosition = this.view.positionRelativeToView(position);
        this.application.displayMousePosition(relativePosition.scale(0.1f));
        if (this.isDrawing) {
            Vector2D endCoord = this.view.positionRelativeToView(position);
            Vector2D rectSize = endCoord.sub(this.startCoord);
            this.previewRectangle.setSize(rectSize);
        }
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        if (this.previewRectangle != null) {
            this.previewRectangle.getGShape().draw2D(p, t);
        }
    }

    @Override
    public void toolWasSelected() {
        this.application.displayStatus("To draw a symmetric polygon, click and hold the left mousebutton anywhere on the 2D view");
        super.toolWasSelected();
    }

    @Override
    public void toolWasUnselected() {
        this.application.displayStatus("");
        super.toolWasUnselected();
    }
}

