/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.DropdownList;
import controlP5.Numberbox;
import controlP5.Textfield;
import controlP5.Textlabel;
import de.mcp.cutcad.application.NumberInputBox;
import de.mcp.cutcad.application.Pluggable;
import de.mcp.cutcad.model.AllMaterials;
import de.mcp.cutcad.model.Material;
import de.mcp.cutcad.model.primitives.Shape;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.event.KeyEvent;

public class Properties
extends PApplet {
    private static final long serialVersionUID = 1L;
    private ArrayList<Controller<?>> controllers = new ArrayList();
    private ArrayList<Material> materials = AllMaterials.getMaterials();
    private ArrayList<Numberbox> numberBoxes;
    private ArrayList<Textlabel> controlNames;
    private ArrayList<Textlabel> controlUnits;
    private Textfield shapeName;
    private Textlabel nameLabel;
    private DropdownList setMaterial;
    private Pluggable currentlyPluggedTo = null;
    private boolean hidden = false;

    public Properties(ControlP5 cp5, int posX, int posY, int sizeX, int sizeY) {
        this.nameLabel = (Textlabel)((Textlabel)cp5.addTextlabel("nameLabel").setColor(0).setText("Name").setPosition((float)(sizeX - 390), (float)((sizeY - 10) / 2))).setSize(50, 20);
        this.shapeName = (Textfield)((Textfield)((Textfield)((Textfield)((Textfield)((Textfield)cp5.addTextfield("setName").setPosition((float)(sizeX - 350), (float)((sizeY - 25) / 2))).setSize(100, 25)).setColorForeground(this.color(120))).setColorActive(this.color(80))).setColorBackground(this.color(150))).setLabelVisible(false);
        this.numberBoxes = new ArrayList();
        this.numberBoxes.add(new NumberInputBox(this, cp5, "setValue0"));
        this.numberBoxes.add(new NumberInputBox(this, cp5, "setValue1"));
        this.numberBoxes.add(new NumberInputBox(this, cp5, "setValue2"));
        this.numberBoxes.add(new NumberInputBox(this, cp5, "setValue3"));
        this.numberBoxes.add(new NumberInputBox(this, cp5, "setValue4"));
        this.numberBoxes.add(new NumberInputBox(this, cp5, "setValue5"));
        this.controlNames = new ArrayList();
        this.controlNames.add(cp5.addTextlabel("setName0"));
        this.controlNames.add(cp5.addTextlabel("setName1"));
        this.controlNames.add(cp5.addTextlabel("setName2"));
        this.controlNames.add(cp5.addTextlabel("setName3"));
        this.controlNames.add(cp5.addTextlabel("setName4"));
        this.controlNames.add(cp5.addTextlabel("setName5"));
        this.controlUnits = new ArrayList();
        this.controlUnits.add(cp5.addTextlabel("setUnit0"));
        this.controlUnits.add(cp5.addTextlabel("setUnit1"));
        this.controlUnits.add(cp5.addTextlabel("setUnit2"));
        this.controlUnits.add(cp5.addTextlabel("setUnit3"));
        this.controlUnits.add(cp5.addTextlabel("setUnit4"));
        this.controlUnits.add(cp5.addTextlabel("setUnit5"));
        int i = 0;
        while (i < this.numberBoxes.size()) {
            ((Numberbox)((Numberbox)((Numberbox)((Numberbox)((Numberbox)((Numberbox)this.numberBoxes.get(i).setPosition((float)(50 + i * 100), 18.0f)).setSize(50, 20)).setColorForeground(this.color(120))).setColorActive(this.color(80))).setColorBackground(this.color(150))).setDecimalPrecision(1)).setDirection(0).setLabelVisible(false);
            this.controllers.add((Controller)this.numberBoxes.get(i));
            this.numberBoxes.get(i).plugTo((Object)this);
            ((Textlabel)this.controlUnits.get(i).setPosition((float)(101 + i * 100), 25.0f)).setColor(this.color(0));
            ((Textlabel)this.controlNames.get(i).setPosition((float)(60 + i * 100), 5.0f)).setColor(this.color(0));
            ++i;
        }
        this.setMaterial = ((DropdownList)((DropdownList)cp5.addDropdownList("setMaterial").setPosition((float)(sizeX - 225), (float)((sizeY - 25) / 2 + 25))).setSize(200, 400).setItemHeight(25).setBarHeight(25)).setColorForeground(this.color(0)).setColorActive(this.color(0)).setColorBackground(this.color(150));
        this.setMaterial.getCaptionLabel().getStyle().setMarginTop(7);
        for (Material m : this.materials) {
            this.setMaterial.addItem(m.getMaterialName(), this.materials.indexOf(m));
        }
    }

    public void changeMaterial(float materialNumber) {
        if (this.currentlyPluggedTo instanceof Shape) {
            Shape s = (Shape)this.currentlyPluggedTo;
            s.getGShape().setMaterial(this.materials.get((int)materialNumber));
        }
    }

    public void unplugAll() {
        if (this.currentlyPluggedTo != null) {
            for (Numberbox n : this.numberBoxes) {
                n.unplugFrom((Object)this.currentlyPluggedTo);
            }
            this.shapeName.unplugFrom((Object)this.currentlyPluggedTo);
            this.currentlyPluggedTo.setActive(false);
        }
        this.hideAll();
    }

    public void plugTo(Pluggable p) {
        this.unplugAll();
        int i = 0;
        while (i < p.getNumberOfControls()) {
            int value = p.getValue(i);
            ((Numberbox)((Numberbox)this.numberBoxes.get(i).plugTo((Object)p)).setRange(this.getMinimum(p.getControlType(i)), this.getMaximum(p.getControlType(i))).setCaptionLabel(p.getNameOfControl(i))).setValue((float)value).show();
            this.controlUnits.get(i).setText(this.getUnit(p.getControlType(i))).show();
            this.controlNames.get(i).setText(p.getNameOfControl(i)).show();
            ++i;
        }
        p.setActive(true);
        this.currentlyPluggedTo = p;
        if (p instanceof Shape) {
            Shape s = (Shape)p;
            this.shapeName.plugTo((Object)p);
            this.shapeName.setText(s.getName());
            this.shapeName.show();
            this.nameLabel.show();
            int i2 = 0;
            while (i2 < p.getNumberOfControls()) {
                if (s.getGShape().getNumberOfConnections() > 0) {
                    this.lockAll();
                } else {
                    this.unlockAll();
                }
                ++i2;
            }
            this.setMaterial.setCaptionLabel(s.getGShape().getMaterial().getMaterialName());
            this.setMaterial.show();
            s.getGShape().setActive(true);
        } else {
            this.unlockAll();
        }
    }

    private void unlockAll() {
        int i = 0;
        while (i < this.controllers.size()) {
            this.controllers.get(i).unlock();
            ++i;
        }
    }

    private void lockAll() {
        int i = 0;
        while (i < this.controllers.size()) {
            this.controllers.get(i).lock();
            ++i;
        }
    }

    private void hideAll() {
        this.setMaterial.hide();
        this.shapeName.hide();
        this.nameLabel.hide();
        for (Numberbox n : this.numberBoxes) {
            n.hide();
        }
        for (Textlabel t : this.controlUnits) {
            t.hide();
        }
        for (Textlabel t : this.controlNames) {
            t.hide();
        }
    }

    public void hide() {
        for (Controller<?> c : this.controllers) {
            c.hide();
        }
        this.shapeName.hide();
        this.nameLabel.hide();
        this.setMaterial.hide();
        this.hidden = true;
    }

    public void show() {
        for (Controller<?> c : this.controllers) {
            c.show();
        }
        this.shapeName.show();
        this.nameLabel.show();
        this.setMaterial.show();
        this.hidden = false;
    }

    private float getMaximum(int type) {
        if (type == 0) {
            return 360.0f;
        }
        if (type == 1) {
            return 600.0f;
        }
        if (type == 2) {
            return 300.0f;
        }
        if (type == 3) {
            return 16.0f;
        }
        return 0.0f;
    }

    private float getMinimum(int type) {
        if (type == 0) {
            return 0.0f;
        }
        if (type == 1) {
            return 2.0f;
        }
        if (type == 2) {
            return -300.0f;
        }
        if (type == 3) {
            return 3.0f;
        }
        return 0.0f;
    }

    private String getUnit(int type) {
        if (type == 0) {
            return "degree";
        }
        if (type == 1) {
            return "mm";
        }
        if (type == 2) {
            return "mm";
        }
        if (type == 3) {
            return "";
        }
        return "";
    }

    public void drawProperties(PApplet p) {
        p.fill(180);
        if (this.hidden) {
            this.unplugAll();
        }
    }

    public void keyEvent(KeyEvent k) {
        for (Numberbox n : this.numberBoxes) {
            n.keyEvent(k);
        }
    }
}

