/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application;

import controlP5.Numberbox;
import java.util.regex.Pattern;
import processing.core.PApplet;
import processing.event.KeyEvent;

public class NumberInputBoxKeyEventHelper {
    private String text = "";
    private Numberbox n;
    private PApplet p;
    private boolean active;

    public NumberInputBoxKeyEventHelper(PApplet p, Numberbox theNumberbox) {
        this.p = p;
        this.n = theNumberbox;
        p.registerMethod("keyEvent", (Object)this);
        this.text = this.n.getValueLabel().getText();
    }

    public void keyEvent(KeyEvent k) {
        if (k.getAction() == 1 && this.active) {
            if (k.getKey() == '\n') {
                this.submit();
                return;
            }
            if (k.getKeyCode() == 8) {
                this.text = this.text.isEmpty() ? "" : this.text.substring(0, this.text.length() - 1);
            } else if (k.getKey() < '\u00ff') {
                String regex = "\\d+([.]\\d{0,2})?";
                if (Pattern.matches("\\d+([.]\\d{0,2})?", String.valueOf(this.text) + k.getKey())) {
                    this.text = String.valueOf(this.text) + k.getKey();
                }
            }
            this.n.getValueLabel().setText(this.text);
        }
    }

    public void setActive(boolean b) {
        this.active = b;
        if (this.active) {
            this.n.setColorValueLabel(this.n.getColor().getActive());
            this.text = this.n.getValueLabel().getText();
        } else {
            this.n.setColorValueLabel(this.p.color(255));
            this.n.getValueLabel().setText(String.format("%.0f", Float.valueOf(this.n.getValue())));
        }
    }

    private void submit() {
        if (!this.text.isEmpty()) {
            this.n.setValue(Float.parseFloat(this.text));
        } else {
            this.n.getValueLabel().setText("" + this.n.getValue());
        }
        this.setActive(false);
    }
}

