/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog.lasercutter;

public class LaserCutter {
    private int device;

    public LaserCutter(String device) {
        this.setDevice(device);
    }

    public LaserCutter() {
        this.device = -1;
    }

    public String returnDevice() {
        switch (this.device) {
            case 0: {
                return "epilogZing";
            }
            case 1: {
                return "epilogHelix";
            }
            case 2: {
                return "laosCutter";
            }
            case 3: {
                return "lasersaur";
            }
        }
        return "no selected";
    }

    public int returnDeviceNumber() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device.equals("epilogZing") ? 0 : (device.equals("epilogHelix") ? 1 : (device.equals("laosCutter") ? 2 : (device.equals("lasersaur") ? 3 : -1)));
    }

    public void setDevice(int device) {
        this.device = device > 3 ? -1 : device;
    }

    public int returnBedWidth() {
        switch (this.device) {
            case 0: {
                return 600;
            }
            case 1: {
                return 600;
            }
            case 2: {
                return 300;
            }
            case 3: {
                return 250;
            }
        }
        return 600;
    }

    public int returnBedHeight() {
        switch (this.device) {
            case 0: {
                return 300;
            }
            case 1: {
                return 300;
            }
            case 2: {
                return 210;
            }
            case 3: {
                return 280;
            }
        }
        return 300;
    }

    public final double[] returnDPI() {
        switch (this.device) {
            case 0: {
                return new double[]{100.0, 200.0, 250.0, 400.0, 500.0, 1000.0};
            }
            case 1: {
                return new double[]{75.0, 150.0, 200.0, 300.0, 400.0, 600.0, 1200.0};
            }
            case 2: {
                return new double[]{100.0, 200.0, 300.0, 500.0, 600.0, 1000.0, 1200.0};
            }
            case 3: {
                return new double[]{500.0};
            }
        }
        return new double[]{500.0};
    }
}

