/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.printdialog;

import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.printdialog.PrintDialogInstance;
import de.mcp.cutcad.printdialog.PrintDialogWindow;
import de.mcp.cutcad.printdialog.PrintInstance;
import de.mcp.cutcad.printdialog.SettingsLoader;
import de.mcp.cutcad.printdialog.lasercutter.LaserCutterSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;

public class PrintDialog {
    private List<Shape> shapes;
    private ArrayList<Shape> preparedShapes;
    private ArrayList<PrintInstance> printInstances;
    private PrintDialogInstance printDialogInstance;
    private LaserCutterSettings laserCutterSettings;
    private PrintDialogWindow printDialogWindow;
    private Frame printDialogFrame;

    public PrintDialog(List<Shape> shapes) {
        this.shapes = shapes;
    }

    public void preparePrintDialog() {
        this.copyShapes();
        this.calculateInstances();
        this.loadPrintSettings();
        this.printDialogInstance = new PrintDialogInstance(this.printInstances, this.laserCutterSettings);
        this.printDialogWindow = this.addPrintDialogFrame(1100, 650, this.printInstances);
    }

    private void loadPrintSettings() {
        SettingsLoader settingsLoader = new SettingsLoader();
        settingsLoader.loadSettingFile();
        this.laserCutterSettings = settingsLoader.settingsExists() ? settingsLoader.loadSettings() : new LaserCutterSettings();
    }

    private void copyShapes() {
        this.preparedShapes = new ArrayList();
        int i = 0;
        while (i < this.shapes.size()) {
            Shape copy = this.shapes.get(i).copy();
            copy.getGShape().setPosition2D(new Vector2D(100.0f, 100.0f));
            copy.getGShape().scale2D(0.1f);
            copy.getGShape().setScalingFactor(1.0f);
            this.preparedShapes.add(copy);
            ++i;
        }
    }

    private void calculateInstances() {
        this.printInstances = new ArrayList();
        int i = 0;
        while (i < this.preparedShapes.size()) {
            if (!this.preparedShapes.get(i).getGShape().getMaterial().getMaterialName().equals("Nothing 0,5 mm")) {
                int j = 0;
                boolean found = false;
                while (j < this.printInstances.size() && !found) {
                    if (this.printInstances.get(j).getMaterial().getMaterialName().equals(this.preparedShapes.get(i).getGShape().getMaterial().getMaterialName())) {
                        this.printInstances.get(j).addShape(this.preparedShapes.get(i));
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    this.printInstances.add(new PrintInstance(this.preparedShapes.get(i), this.preparedShapes.get(i).getGShape().getMaterial()));
                }
            }
            ++i;
        }
    }

    private PrintDialogWindow addPrintDialogFrame(int theWidth, int theHeight, ArrayList<PrintInstance> printInstances) {
        this.printDialogFrame = new Frame("Print dialog");
        PrintDialogWindow tempPrintDialogWindow = new PrintDialogWindow(theWidth, theHeight, this.printDialogInstance);
        this.printDialogFrame.add((Component)((Object)tempPrintDialogWindow));
        tempPrintDialogWindow.init();
        tempPrintDialogWindow.setSize(theHeight, theWidth);
        this.printDialogFrame.setTitle("Print dialog");
        this.printDialogFrame.setSize(tempPrintDialogWindow.getWidth(), tempPrintDialogWindow.getHeight());
        this.printDialogFrame.setLocation(100, 100);
        this.printDialogFrame.setResizable(false);
        this.printDialogFrame.setVisible(true);
        this.printDialogWindow = tempPrintDialogWindow;
        this.printDialogInstance.setPrintDialogWindow(this.printDialogWindow);
        this.printDialogFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PrintDialog.this.printDialogWindow.destroy();
                PrintDialog.this.printDialogFrame.setVisible(false);
            }
        });
        return tempPrintDialogWindow;
    }
}

