/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model.primitives;

import de.mcp.cutcad.algorithm.CreateTenons;
import de.mcp.cutcad.model.AllMaterials;
import de.mcp.cutcad.model.Connection;
import de.mcp.cutcad.model.Material;
import de.mcp.cutcad.model.primitives.Cutout;
import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import de.mcp.cutcad.view.Drawable2D;
import de.mcp.cutcad.view.Drawable3D;
import de.mcp.cutcad.view.Transformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import processing.core.PGraphics;
import toxi.geom.Line2D;
import toxi.geom.Polygon2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;
import toxi.geom.Vec3D;

public class GShape
implements Drawable2D,
Drawable3D,
Serializable {
    private static final long serialVersionUID = -328360113782680890L;
    private int numberOfConnections;
    private Vector2D position2D;
    private Vector3D position3D;
    private boolean isSelected;
    private boolean isActive;
    private List<Vector2D> vertices;
    private List<Vector3D> vertices3D;
    private List<Cutout> cutouts = new ArrayList<Cutout>();
    private List<Edge> edges;
    private Shape shape;
    private Material material;
    private String name;
    private float scalingFactor;
    private float scalingFactor3D;

    public GShape(List<Vector2D> initVertices, Vector3D position, Shape shape) {
        this.position2D = position.to2DXY();
        this.position3D = position;
        this.isSelected = false;
        this.isActive = false;
        this.shape = shape;
        this.numberOfConnections = 0;
        this.material = AllMaterials.getBaseMaterial();
        this.vertices = initVertices;
        this.edges = new ArrayList<Edge>();
        this.vertices3D = new ArrayList<Vector3D>();
        for (Vector2D v : this.vertices) {
            this.vertices3D.add(v.add(this.position2D).to3DXY());
        }
        int i = 0;
        while (i < this.vertices.size()) {
            this.edges.add(new Edge(this, this.vertices3D.get(i), this.vertices3D.get((i + 1) % this.vertices.size()), this.vertices.get(i), this.vertices.get((i + 1) % this.vertices.size())));
            ++i;
        }
    }

    public List<Cutout> getCutouts() {
        return this.cutouts;
    }

    public void setScalingFactor(float factor) {
        this.scalingFactor = factor;
    }

    public float getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor3D(float factor) {
        this.scalingFactor3D = factor;
    }

    public float getScalingFactor3D() {
        return this.scalingFactor3D;
    }

    public void recalculate(List<Vector2D> basicShape) {
        if (this.numberOfConnections == 0) {
            this.vertices = basicShape;
            this.edges.clear();
            this.vertices3D.clear();
            for (Vector2D v : this.vertices) {
                this.vertices3D.add(v.add(this.position2D).to3DXY());
            }
            int i = 0;
            while (i < this.vertices.size()) {
                this.edges.add(new Edge(this, this.vertices3D.get(i), this.vertices3D.get((i + 1) % this.vertices.size()), this.vertices.get(i), this.vertices.get((i + 1) % this.vertices.size())));
                ++i;
            }
        }
    }

    public void addCutout(GShape cutout) {
        this.cutouts.add(new Cutout(this, cutout));
    }

    public void removeCutout(Cutout cutout) {
        this.cutouts.remove(cutout);
    }

    public int getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public void addNumberOfConnections(int connections) {
        this.numberOfConnections += connections;
    }

    public Shape getShape() {
        return this.shape;
    }

    public int getThickness() {
        return this.material.getMaterialThickness();
    }

    public Material getMaterial() {
        return this.material;
    }

    public Vector3D getPosition3D() {
        return this.position3D;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public List<Vector2D> getVertices() {
        return this.vertices;
    }

    public boolean overlapsWith(GShape s) {
        if (this.noLineIntersections(this.getVerticesIncludingPosition2D(), s.getVerticesIncludingPosition2D())) {
            return this.containsAtLeastOnePointFromList(s.getVerticesIncludingPosition2D()) || s.containsAtLeastOnePointFromList(this.getVerticesIncludingPosition2D());
        }
        return true;
    }

    private boolean noLineIntersections(List<Vec2D> vectors1, List<Vec2D> vectors2) {
        List<Line2D> lines1 = this.createListOfLines(vectors1);
        List<Line2D> lines2 = this.createListOfLines(vectors2);
        for (Line2D x : lines1) {
            for (Line2D y : lines2) {
                if (!x.intersectLine(y).getType().equals((Object)Line2D.LineIntersection.Type.valueOf((String)"INTERSECTING"))) continue;
                return false;
            }
        }
        return true;
    }

    private List<Line2D> createListOfLines(List<Vec2D> vectors) {
        ArrayList<Line2D> lines = new ArrayList<Line2D>();
        int i = 0;
        while (i < vectors.size() - 1) {
            lines.add(new Line2D(vectors.get(i), vectors.get(i + 1)));
            ++i;
        }
        lines.add(new Line2D(vectors.get(vectors.size() - 1), vectors.get(0)));
        return lines;
    }

    private boolean containsAtLeastOnePointFromList(List<Vec2D> points) {
        Polygon2D thisShape = new Polygon2D(this.getVerticesIncludingPosition2D());
        for (Vec2D v : points) {
            if (!thisShape.containsPoint((ReadonlyVec2D)v)) continue;
            return true;
        }
        return false;
    }

    private List<Vec2D> getVerticesIncludingPosition2D() {
        ArrayList<Vec2D> vectors = new ArrayList<Vec2D>();
        for (Vector2D v : this.getVertices()) {
            vectors.add(v.add(this.position2D).getVec2D());
        }
        return vectors;
    }

    private Vector2D correctIntersection(Edge edge) {
        int index = this.edges.indexOf(edge);
        index = index == 0 ? this.edges.size() - 1 : index - 1;
        Edge edge1 = this.edges.get(index);
        Edge edge2 = edge;
        Vector2D firstVectorOfEdge1 = edge1.getTenons().get(0);
        Vector2D secondVectorOfEdge1 = edge1.getTenons().get(1);
        Vector2D firstVectorOfEdge2 = edge2.getTenons().get(1);
        Vector2D secondVectorOfEdge2 = edge2.getTenons().get(0);
        Line2D firstTenonOfEdge1 = new Line2D(firstVectorOfEdge1.getVec2D(), secondVectorOfEdge1.getVec2D());
        firstTenonOfEdge1 = firstTenonOfEdge1.toRay2D().toLine2DWithPointAtDistance(10000.0f);
        Line2D firstTenonOfEdge2 = new Line2D(firstVectorOfEdge2.getVec2D(), secondVectorOfEdge2.getVec2D());
        if (String.valueOf(firstTenonOfEdge1.intersectLine(firstTenonOfEdge2 = firstTenonOfEdge2.toRay2D().toLine2DWithPointAtDistance(10000.0f)).getType()).equals("INTERSECTING")) {
            return new Vector2D(firstTenonOfEdge1.intersectLine(firstTenonOfEdge2).getPos());
        }
        return firstVectorOfEdge2;
    }

    public ArrayList<Vector2D> getTenons() {
        ArrayList<Vector2D> allVectors = new ArrayList<Vector2D>();
        for (Edge e : this.edges) {
            allVectors.add(this.correctIntersection(e));
            int i = 1;
            while (i < e.getTenons().size() - 1) {
                allVectors.add(e.getTenons().get(i));
                ++i;
            }
        }
        allVectors.add((Vector2D)allVectors.get(allVectors.size() - 1));
        return allVectors;
    }

    private ArrayList<Vector3D> transformTo3D(boolean isTop, ArrayList<Vector2D> vectors2D) {
        GShape helperShape = new GShape(this.vertices, this.position3D, this.getShape());
        GShape master = this;
        GShape slave = helperShape;
        Edge masterEdge = this.getEdges().get(0);
        Edge slaveEdge = helperShape.getEdges().get(0);
        Vector3D masterEdgeDirection = masterEdge.getP3D2().sub(masterEdge.getP3D1());
        Vector3D slaveEdgeDirection = slaveEdge.getP3D2().sub(slaveEdge.getP3D1());
        float angleBetweenEdges = this.safeAngleBetween(slaveEdgeDirection, masterEdgeDirection);
        Vector3D normalVector = slaveEdgeDirection.cross(masterEdgeDirection).getNormalized();
        while (normalVector.equals(new Vec3D(0.0f, 0.0f, 0.0f))) {
            normalVector = masterEdgeDirection.cross(new Vector3D((float)Math.random(), (float)Math.random(), (float)Math.random())).getNormalized();
        }
        slave.rotateAroundAxis(normalVector, angleBetweenEdges);
        slaveEdgeDirection = slaveEdge.getP3D2().sub(slaveEdge.getP3D1());
        Vector3D toOrigin = slaveEdge.getP3D1().scale(-1.0f).copy();
        slave.translate3D(toOrigin);
        Vector3D rotationAxis = slaveEdge.getP3D2().getNormalized();
        float angleBetweenNormals = this.calculateAngleBetweenNormals(master, slave);
        slave.rotateAroundAxis(rotationAxis, angleBetweenNormals);
        if (this.calculateAngleBetweenNormals(master, slave) > 0.001f) {
            slave.rotateAroundAxis(rotationAxis, -2.0f * angleBetweenNormals);
            angleBetweenNormals = -angleBetweenNormals;
        }
        Vector3D toMaster = masterEdge.getP3D1().sub(slaveEdge.getP3D1()).copy();
        int offsetZ = isTop ? this.getThickness() / 2 : -this.getThickness() / 2;
        ArrayList<Vector3D> vectors3D = new ArrayList<Vector3D>();
        for (Vector2D v : vectors2D) {
            vectors3D.add(v.to3DXY().add(this.position3D).addSelf(new Vector3D(0.0f, 0.0f, offsetZ)));
        }
        int i = 0;
        while (i < vectors3D.size()) {
            vectors3D.set(i, vectors3D.get(i).rotateAroundAxis(normalVector, angleBetweenEdges));
            vectors3D.set(i, vectors3D.get(i).addSelf(toOrigin));
            vectors3D.set(i, vectors3D.get(i).rotateAroundAxis(rotationAxis, angleBetweenNormals));
            vectors3D.set(i, vectors3D.get(i).addSelf(toMaster).scale(this.scalingFactor3D));
            ++i;
        }
        return vectors3D;
    }

    private float safeAngleBetween(Vector3D masterEdgeDirection, Vector3D slaveEdgeDirection) {
        float angle = slaveEdgeDirection.angleBetween(masterEdgeDirection, true);
        if (Float.isNaN(angle)) {
            angle = slaveEdgeDirection.add(masterEdgeDirection).equalsWithTolerance(new Vector3D(0.0f, 0.0f, 0.0f), 0.1f) ? (float)Math.PI : 0.0f;
        }
        return angle;
    }

    private float calculateAngleBetweenNormals(GShape master, GShape slave) {
        Vector3D masterNormal = master.getNormalVector();
        Vector3D slaveNormal = slave.getNormalVector();
        return this.safeAngleBetween(masterNormal, slaveNormal);
    }

    public Vector2D get2Dperpendicular(Vector2D v1, Vector2D v2) {
        for (Vector2D v3 : this.vertices) {
            if (v3.sub(v1).to3DXY().cross(v2.sub(v1).to3DXY()).isZeroVector()) continue;
            Vector3D normal = v3.sub(v1).to3DXY().cross(v2.sub(v1).to3DXY());
            return new Vector2D(normal.cross(v2.sub(v1).to3DXY()).invert().add(v1.to3DXY()).normalize().to2DXY());
        }
        return new Vector2D(0.0f, 1.0f);
    }

    public Vector3D get3Dperpendicular(Vector3D v1, Vector3D v2) {
        for (Vector3D v3 : this.vertices3D) {
            if (v3.sub(v1).cross(v2.sub(v1)).isZeroVector()) continue;
            Vector3D normal = v3.sub(v1).cross(v2.sub(v1));
            return normal.cross(v2.sub(v1)).invert().add(v1).normalize();
        }
        return new Vector3D(0.0f, 0.0f, 1.0f);
    }

    public Vector2D getPosition2D() {
        return this.position2D;
    }

    public void setMaterial(Material material) {
        this.material = material;
        if (this.getNumberOfConnections() > 0) {
            for (Edge e : this.edges) {
                for (Connection c : Connection.getConnections()) {
                    if (c.getMasterEdge() == e) {
                        CreateTenons.createOutlineOfEdge(c.getSlaveEdge(), e);
                        continue;
                    }
                    if (c.getSlaveEdge() != e) continue;
                    CreateTenons.createOutlineOfEdge(c.getMasterEdge(), e);
                }
            }
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public void scale2D(float scaleFactor) {
        this.position2D = this.position2D.scale(scaleFactor);
        ArrayList<Vector2D> newVertices = new ArrayList<Vector2D>();
        int i = 0;
        while (i < this.vertices.size()) {
            newVertices.add(this.vertices.get(i).scale(scaleFactor));
            ++i;
        }
        this.vertices = newVertices;
        i = 0;
        while (i < this.edges.size()) {
            this.edges.get(i).scale2D(scaleFactor);
            ++i;
        }
        i = 0;
        while (i < this.cutouts.size()) {
            this.cutouts.get(i).scale2D(scaleFactor);
            ++i;
        }
    }

    public void setPosition2D(Vector2D position) {
        this.position2D = position;
    }

    public void translate2D(Vector2D direction) {
        this.position2D.addSelf(direction);
    }

    public void rotateAroundAxis(Vector3D rotationAxis, float theta) {
        for (Vector3D v : this.vertices3D) {
            v.rotateAroundAxis(rotationAxis, theta);
        }
    }

    public void translate3D(Vector3D translationVector) {
        for (Vector3D v : this.vertices3D) {
            v.addSelf(translationVector);
        }
    }

    public Vector3D getNormalVector() {
        return this.edges.get(0).getP3D1().sub(this.edges.get(0).getP3D2()).cross(this.edges.get(1).getP3D1().sub(this.edges.get(1).getP3D2())).getNormalized();
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        this.scalingFactor = t.getScale();
        this.createCover2D(p, this.getTenons(), this.position2D);
        for (Edge e : this.edges) {
            e.draw2D(p, t);
        }
    }

    @Override
    public void draw3D(PGraphics p, Transformation t) {
        this.scalingFactor3D = t.getScale();
        if (!this.getMaterial().getMaterialName().equals("Nothing 0,5 mm")) {
            this.createCover3D(p, true);
            this.createCover3D(p, false);
            this.createSides(p, this.getTenons());
            for (Cutout cutout : this.cutouts) {
                this.createSides(p, cutout.getVectors());
            }
            for (Edge e : this.edges) {
                e.draw3D(p, t);
            }
        }
    }

    private void createSides(PGraphics p, ArrayList<Vector2D> vectors) {
        this.setFillColor(p);
        ArrayList<Vector3D> top = this.transformTo3D(true, vectors);
        ArrayList<Vector3D> bottom = this.transformTo3D(false, vectors);
        int i = 0;
        while (i < top.size() - 1) {
            p.beginShape();
            p.vertex(top.get(i).x(), top.get(i).y(), top.get(i).z());
            p.vertex(top.get(i + 1).x(), top.get(i + 1).y(), top.get(i + 1).z());
            p.vertex(bottom.get(i + 1).x(), bottom.get(i + 1).y(), bottom.get(i + 1).z());
            p.vertex(bottom.get(i).x(), bottom.get(i).y(), bottom.get(i).z());
            p.endShape(2);
            ++i;
        }
        p.beginShape();
        p.vertex(top.get(top.size() - 1).x(), top.get(top.size() - 1).y(), top.get(top.size() - 1).z());
        p.vertex(top.get(0).x(), top.get(0).y(), top.get(0).z());
        p.vertex(bottom.get(0).x(), bottom.get(0).y(), bottom.get(0).z());
        p.vertex(bottom.get(top.size() - 1).x(), bottom.get(top.size() - 1).y(), bottom.get(top.size() - 1).z());
        p.endShape(2);
    }

    private void createCover3D(PGraphics p, boolean isTop) {
        this.setFillColor(p);
        p.beginShape();
        for (Vector3D vector : this.transformTo3D(isTop, this.getTenons())) {
            p.vertex(vector.x(), vector.y(), vector.z());
        }
        for (Cutout cutout : this.cutouts) {
            p.beginContour();
            for (Vector3D vector : this.transformTo3D(isTop, cutout.getVectors())) {
                p.vertex(vector.x(), vector.y(), vector.z());
            }
            p.endContour();
        }
        p.endShape(2);
        p.beginShape();
        for (Cutout cutout : this.cutouts) {
            if (cutout.getSlaveShape().getGShape().getMaterial().getMaterialName().equals("Nothing 0,5 mm")) continue;
            p.fill(cutout.getSlaveShape().getGShape().getMaterial().getMaterialColor());
            for (Vector3D vector : this.transformTo3D(isTop, cutout.getVectors())) {
                p.vertex(vector.x(), vector.y(), vector.z());
            }
        }
        p.endShape(2);
    }

    private void createCover2D(PGraphics p, ArrayList<Vector2D> vectors, Vector2D position) {
        this.setFillColor(p);
        p.beginShape();
        for (Vector2D vector : this.getTenons()) {
            Vector2D scaledPosition = vector.add(this.getPosition2D()).scale(this.scalingFactor);
            p.vertex(scaledPosition.x(), scaledPosition.y());
        }
        for (Cutout cutout : this.cutouts) {
            p.beginContour();
            for (Vector2D vector : cutout.getVectors()) {
                Vector2D scaledPosition = vector.add(this.getPosition2D()).scale(this.scalingFactor);
                p.vertex(scaledPosition.x(), scaledPosition.y());
            }
            p.endContour();
        }
        p.endShape(2);
    }

    private void setFillColor(PGraphics p) {
        p.strokeWeight(1.0f);
        if (this.isSelected()) {
            p.stroke(255.0f, 0.0f, 0.0f);
        } else if (this.isActive) {
            p.stroke(125.0f, 0.0f, 0.0f);
        } else {
            p.stroke(0);
        }
        p.fill(this.getMaterial().getMaterialColor());
    }

    public boolean mouseOver(Vector2D mousePosition) {
        ArrayList<Vec2D> vec2DList = new ArrayList<Vec2D>();
        for (Vector2D vertex : this.vertices) {
            vec2DList.add(vertex.getVec2D());
        }
        Polygon2D test = new Polygon2D(vec2DList);
        return test.containsPoint((ReadonlyVec2D)mousePosition.sub(this.position2D).getVec2D());
    }

    public GShape copy(Shape shape) {
        GShape copy = new GShape(this.getTenons(), new Vector3D(this.position3D), shape);
        copy.setMaterial(this.material);
        copy.setName(this.getName());
        copy.removeAllCutouts();
        for (Cutout c : this.cutouts) {
            copy.addCutout(new GShape(c.getVectors(), new Vector3D(0.0f, 0.0f, 0.0f), shape));
            copy.getCutouts().get(copy.getCutouts().size() - 1).setValue0(0);
            copy.getCutouts().get(copy.getCutouts().size() - 1).setValue1(0);
        }
        return copy;
    }

    public Shape copyCompleteStructure() {
        Shape copy = this.getShape().copyBaseForm();
        copy.getGShape().recalculate(this.vertices);
        copy.getGShape().setMaterial(this.material);
        copy.getGShape().setName("CopyOf" + this.getName());
        copy.getGShape().removeAllCutouts();
        for (Cutout c : this.cutouts) {
            copy.getGShape().addCutout(c.copyFor(copy.getGShape()));
        }
        return copy;
    }

    private void removeAllCutouts() {
        this.cutouts.clear();
    }

    public void addCutout(Cutout cutout) {
        this.cutouts.add(cutout);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

