/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model.primitives;

import de.mcp.cutcad.application.Pluggable;
import de.mcp.cutcad.model.AllMaterials;
import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.GShape;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.view.Drawable2D;
import de.mcp.cutcad.view.Transformation;
import java.io.Serializable;
import java.util.ArrayList;
import processing.core.PGraphics;
import toxi.geom.Polygon2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

public class Cutout
implements Drawable2D,
Serializable,
Pluggable {
    private static final long serialVersionUID = -3035265244890031332L;
    private Vector2D position;
    private float angle;
    private GShape master;
    private GShape slave;
    private boolean isSelected;
    private boolean isActive;
    private float scalingFactor;
    private float boundingBoxSize;

    public Cutout(GShape master, GShape slave) {
        this.master = master;
        this.slave = slave;
        slave.setMaterial(AllMaterials.getMaterials().get(0));
        this.angle = 0.0f;
        this.position = !master.overlapsWith(slave) ? new Vector2D(this.findCenter(master).sub(this.findCenter(slave))) : slave.getPosition2D().sub(master.getPosition2D());
        this.isSelected = false;
        this.isActive = false;
    }

    public void translate2D(Vector2D direction) {
        this.position.addSelf(direction);
    }

    public Cutout copyFor(GShape newMaster) {
        Cutout copy = new Cutout(newMaster, this.slave);
        copy.angle = this.angle;
        copy.position.set(this.position);
        this.isSelected = false;
        this.isActive = false;
        return copy;
    }

    public Shape getMasterShape() {
        return this.master.getShape();
    }

    public Shape getSlaveShape() {
        return this.slave.getShape();
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public ArrayList<Vector2D> getVectors() {
        ArrayList<Vector2D> modifiedVectors = new ArrayList<Vector2D>();
        Polygon2D findCenter = new Polygon2D();
        for (Vector2D v : this.slave.getTenons()) {
            findCenter.add(v.copy().getVec2D());
        }
        Vector2D center = new Vector2D(findCenter.getCentroid());
        for (Vector2D v : this.slave.getTenons()) {
            modifiedVectors.add(v.copy().sub(center).rotate((float)Math.toRadians(this.angle)).add(this.position).add(center));
        }
        return modifiedVectors;
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    @Override
    public int getValue(int index) {
        if (index == 0) {
            return (int)this.position.x() / 10;
        }
        if (index == 1) {
            return (int)this.position.y() / 10;
        }
        return (int)this.angle;
    }

    @Override
    public int getControlType(int index) {
        if (index == 0) {
            return 1;
        }
        if (index == 1) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getNameOfControl(int index) {
        if (index == 0) {
            return "X-Position";
        }
        if (index == 1) {
            return "Y-Position";
        }
        return "Angle";
    }

    public void setValue0(int size) {
        this.position.set(size * 10, this.position.y());
    }

    public void setValue1(int size) {
        this.position.set(this.position.x(), size * 10);
    }

    public void setValue2(int angle) {
        this.angle = angle;
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        this.scalingFactor = t.getScale();
        this.boundingBoxSize = 4.0f / this.scalingFactor;
        Vector2D mid1 = this.findCenter(this.slave).add(this.master.getPosition2D()).add(this.position).scale(this.scalingFactor);
        Vector2D mid2 = this.findCenter(this.slave).add(this.slave.getPosition2D()).scale(this.scalingFactor);
        if (this.isSelected) {
            p.stroke(255.0f, 0.0f, 0.0f);
        } else if (this.isActive) {
            p.stroke(125.0f, 0.0f, 0.0f);
        } else {
            p.stroke(0.0f, 60.0f, 0.0f);
        }
        p.line(mid1.x(), mid1.y(), mid2.x(), mid2.y());
        p.stroke(0);
    }

    public Vector2D findCenter(GShape shape) {
        Polygon2D findCenter = new Polygon2D();
        for (Edge e : shape.getEdges()) {
            findCenter.add(e.getV1().copy().getVec2D());
        }
        Vector2D center = new Vector2D(findCenter.getCentroid());
        return center;
    }

    public boolean mouseOver(Vector2D mousePosition) {
        Vector2D mid1 = this.findCenter(this.slave).add(this.master.getPosition2D()).add(this.position);
        Vector2D mid2 = this.findCenter(this.slave).add(this.slave.getPosition2D());
        Vector2D perpendicularVector = mid1.sub(mid2).perpendicular().getNormalizedTo(this.boundingBoxSize);
        ArrayList<Vec2D> definingPoints = new ArrayList<Vec2D>();
        for (Vector2D v : this.getVectors()) {
            definingPoints.add(v.add(this.master.getPosition2D()).getVec2D());
        }
        ArrayList<Vec2D> definingPointsLine = new ArrayList<Vec2D>();
        definingPointsLine.add(mid1.sub(perpendicularVector).scale(this.scalingFactor).getVec2D());
        definingPointsLine.add(mid2.sub(perpendicularVector).scale(this.scalingFactor).getVec2D());
        definingPointsLine.add(mid2.add(perpendicularVector).scale(this.scalingFactor).getVec2D());
        definingPointsLine.add(mid1.add(perpendicularVector).scale(this.scalingFactor).getVec2D());
        Polygon2D borders = new Polygon2D(definingPoints);
        if (borders.containsPoint((ReadonlyVec2D)mousePosition.getVec2D())) {
            return true;
        }
        borders = new Polygon2D(definingPointsLine);
        return borders.containsPoint((ReadonlyVec2D)mousePosition.scale(this.scalingFactor).getVec2D());
    }

    public void removeCutout() {
        this.master.removeCutout(this);
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void scale2D(float scaleFactor) {
        this.slave.scale2D(scaleFactor);
    }
}

