/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.model;

import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import de.mcp.cutcad.model.shapes.PolygonShape;
import geomerative.RG;
import geomerative.RPoint;
import java.io.File;
import java.util.ArrayList;
import processing.core.PApplet;
import toxi.geom.Polygon2D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Vec2D;

public class ImportSVG
extends PApplet {
    private static final long serialVersionUID = 1L;
    private RPoint[][] pointPaths;
    private float scalingInkscape = 2.8222222f;

    public ArrayList<Shape> createPathsFromSVG(File selection) {
        this.pointPaths = RG.loadShape((String)selection.getAbsolutePath()).getPointsInPaths();
        ArrayList<Shape> newShapes = new ArrayList<Shape>();
        int i = 0;
        while (i < this.pointPaths.length) {
            if (this.pointPaths[i] != null) {
                newShapes.add(this.createShapeFromPath(i));
            }
            ++i;
        }
        this.createCutouts(newShapes);
        return newShapes;
    }

    private void createCutouts(ArrayList<Shape> newShapes) {
        for (Shape original : newShapes) {
            for (Shape possibleCutout : newShapes) {
                boolean isCutout = true;
                ArrayList<Vec2D> vec2DVertices = new ArrayList<Vec2D>();
                for (Vector2D vertex : original.getGShape().getVertices()) {
                    vec2DVertices.add(vertex.getVec2D());
                }
                Polygon2D formOriginal = new Polygon2D(vec2DVertices);
                Vector2D offset = possibleCutout.getGShape().getPosition2D().sub(original.getGShape().getPosition2D());
                for (Vector2D v : possibleCutout.getGShape().getVertices()) {
                    if (formOriginal.containsPoint((ReadonlyVec2D)v.add(offset).getVec2D())) continue;
                    isCutout = false;
                }
                if (!isCutout) continue;
                original.getGShape().addCutout(possibleCutout.getGShape());
            }
        }
    }

    private Shape createShapeFromPath(int i) {
        ArrayList<Vector2D> path = new ArrayList<Vector2D>();
        float MinX = 2.1474836E9f;
        float MinY = 2.1474836E9f;
        int j = 0;
        while (j < this.pointPaths[i].length) {
            MinX = this.pointPaths[i][j].x < MinX ? this.pointPaths[i][j].x : MinX;
            MinY = this.pointPaths[i][j].y < MinY ? this.pointPaths[i][j].y : MinY;
            ++j;
        }
        Vector3D position = new Vector3D(MinX * this.scalingInkscape, MinY * this.scalingInkscape, 0.0f);
        int j2 = 0;
        while (j2 < this.pointPaths[i].length) {
            path.add(new Vector2D(this.pointPaths[i][j2].x * this.scalingInkscape - position.x(), this.pointPaths[i][j2].y * this.scalingInkscape - position.y()));
            ++j2;
        }
        while (Math.abs(((Vector2D)path.get(path.size() - 1)).x() - ((Vector2D)path.get(0)).x()) < 0.1f && Math.abs(path.get(path.size() - 1).y() - path.get(0).y()) < 0.1f) {
            path.remove(path.size() - 1);
        }
        PolygonShape pathShape = new PolygonShape(path, position);
        return pathShape;
    }
}

