/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.objectManipulation;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.Connection;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Cutout;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;

public class DeleteTool
extends Tool {
    boolean dragging = false;
    Vector2D originalMousePosition = new Vector2D(0.0f, 0.0f);

    public DeleteTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
    }

    @Override
    public String getIconName() {
        return "Delete.svg";
    }

    @Override
    public void mouseButtonPressed(Vector2D position, int button) {
        for (Shape s : this.objectContainer.allShapes()) {
            if (!this.view.containsPoint(position) || !s.getGShape().isSelected() || button != 37) continue;
            this.removeConnectionsContaining(s);
            this.removeCutoutsContaining(s);
            this.objectContainer.removeShape(s);
        }
        for (Connection c : this.objectContainer.allConnections()) {
            if (!this.view.containsPoint(position) || !c.isSelected() || button != 37) continue;
            c.undoConnection();
            this.objectContainer.removeConnection(c);
        }
        for (Cutout o : this.objectContainer.allCutouts()) {
            if (!this.view.containsPoint(position) || !o.isSelected() || button != 37) continue;
            o.removeCutout();
        }
    }

    private void removeConnectionsContaining(Shape s) {
        for (Connection c : this.objectContainer.allConnections()) {
            boolean shapeIsParentOfMasterEdge = c.getMasterEdge().getGShape().getShape().equals(s);
            boolean shapeIsParentOfSlaveEdge = c.getSlaveEdge().getGShape().getShape().equals(s);
            if (!shapeIsParentOfMasterEdge && !shapeIsParentOfSlaveEdge) continue;
            c.undoConnection();
            this.objectContainer.removeConnection(c);
        }
    }

    private void removeCutoutsContaining(Shape s) {
        for (Cutout c : this.objectContainer.allCutouts()) {
            if (c.getMasterShape() != s && c.getSlaveShape() != s) continue;
            c.removeCutout();
        }
    }

    @Override
    public void mouseMoved(Vector2D position) {
        if (this.view.containsPoint(position)) {
            Vector2D relativePosition = this.view.positionRelativeToView(position);
            this.application.displayMousePosition(relativePosition.scale(0.1f));
            for (Shape shape : this.objectContainer.allShapes()) {
                shape.getGShape().setSelected(shape.getGShape().mouseOver(relativePosition));
            }
            for (Connection connection : this.objectContainer.allConnections()) {
                connection.setSelected(connection.mouseOver(relativePosition));
            }
            for (Cutout cutout : this.objectContainer.allCutouts()) {
                cutout.setSelected(cutout.mouseOver(relativePosition));
            }
        }
    }

    @Override
    public void toolWasSelected() {
        this.application.displayStatus("Click on a shape or connection to delete it");
        super.toolWasSelected();
    }

    @Override
    public void toolWasUnselected() {
        this.application.displayStatus("");
        super.toolWasUnselected();
    }
}

