/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.objectManipulation;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.view.Transformation;
import processing.core.PGraphics;
import toxi.geom.Polygon2D;

public class CutoutTool
extends Tool {
    boolean dragging = false;
    boolean selectedFirst = false;
    Vector2D originalMousePosition = new Vector2D(0.0f, 0.0f);
    Vector2D relativePosition;
    Shape masterShape;
    private float scalingFactor;

    public CutoutTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
    }

    @Override
    public String getIconName() {
        return "Cutout.svg";
    }

    @Override
    public void mouseButtonPressed(Vector2D position, int button) {
        for (Shape s : this.objectContainer.allShapes()) {
            if (!this.view.containsPoint(position) || button != 37) continue;
            if (!this.selectedFirst && s.getGShape().isSelected()) {
                this.application.displayStatus("Now select the shape you want to add as a cutout");
                s.getGShape().setSelected(true);
                Vector2D currentMousePosition = this.view.positionRelativeToView(position);
                this.originalMousePosition.set(currentMousePosition);
                this.masterShape = s;
                this.selectedFirst = true;
                continue;
            }
            if (!this.selectedFirst || !s.getGShape().isSelected() || s == this.masterShape) continue;
            this.application.displayStatus("Cutout created! If you want to create another cutout, select the shape you want to add a cutout to");
            this.masterShape.getGShape().addCutout(s.getGShape());
            this.selectedFirst = false;
        }
    }

    @Override
    public void mouseButtonReleased(Vector2D position, int button) {
        if (button == 39) {
            this.dragging = false;
        }
    }

    @Override
    public void mouseMoved(Vector2D position) {
        if (this.view.containsPoint(position)) {
            this.relativePosition = this.view.positionRelativeToView(position);
            this.application.displayMousePosition(this.relativePosition.scale(0.1f));
            for (Shape s : this.objectContainer.allShapes()) {
                s.getGShape().setSelected(s.getGShape().mouseOver(this.relativePosition));
            }
        }
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        this.scalingFactor = t.getScale();
        if (this.selectedFirst) {
            Polygon2D findCenter = new Polygon2D();
            for (Edge e : this.masterShape.getGShape().getEdges()) {
                findCenter.add(e.getV1().copy().getVec2D());
            }
            Vector2D center = new Vector2D(findCenter.getCentroid());
            Vector2D mid = center.add(this.masterShape.getGShape().getPosition2D());
            p.stroke(255.0f, 0.0f, 0.0f);
            Vector2D lineStart = mid.scale(this.scalingFactor);
            Vector2D lineEnd = this.relativePosition.scale(this.scalingFactor);
            p.line(lineStart.x(), lineStart.y(), lineEnd.x(), lineEnd.y());
            p.stroke(0);
        }
    }

    @Override
    public void toolWasSelected() {
        this.application.displayStatus("First, select the shape you want to add a cutout to");
        super.toolWasSelected();
    }

    @Override
    public void toolWasUnselected() {
        this.application.displayStatus("");
        this.selectedFirst = false;
        super.toolWasUnselected();
    }
}

