/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application.tools.drawing;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import de.mcp.cutcad.model.shapes.PolygonShape;
import de.mcp.cutcad.view.Transformation;
import java.util.ArrayList;
import java.util.List;
import processing.core.PGraphics;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Rect;

public class PolygonTool
extends Tool {
    private List<Vector2D> vertices;
    private Vector2D lastKnownMousePositon;
    private float scalingFactor;
    private float boundingBoxSize;

    public PolygonTool(CutCADApplet application, ObjectContainer container) {
        super(application, container);
    }

    @Override
    public String getIconName() {
        return "DrawPolygon.svg";
    }

    @Override
    public void mouseButtonReleased(Vector2D position, int button) {
        if (!this.view.containsPoint(position)) {
            return;
        }
        if (this.vertices.size() > 1 && this.mouseOverCloseShape()) {
            this.application.displayStatus("Shape finished! If you want to create another shape, click the left mousebutton anywhere on the 2D view");
            PolygonShape newShape = new PolygonShape(this.vertices, new Vector3D());
            this.objectContainer.addShape(newShape);
            this.vertices = new ArrayList<Vector2D>();
        } else {
            this.application.displayStatus("Point added! To add another point, click anywhere on the 2D view. To finish the shape, click on the first point of the shape");
            this.vertices.add(this.lastKnownMousePositon);
        }
        if (button == 39) {
            this.vertices = new ArrayList<Vector2D>();
        }
    }

    private boolean mouseOverCloseShape() {
        Rect closeShapeRect = new Rect((ReadonlyVec2D)this.vertices.get(0).add(-this.boundingBoxSize, -this.boundingBoxSize).getVec2D(), (ReadonlyVec2D)this.vertices.get(0).add(this.boundingBoxSize, this.boundingBoxSize).getVec2D());
        return closeShapeRect.containsPoint((ReadonlyVec2D)this.lastKnownMousePositon.getVec2D());
    }

    @Override
    public void mouseMoved(Vector2D position) {
        this.lastKnownMousePositon = this.view.positionRelativeToView(position);
        this.application.displayMousePosition(this.lastKnownMousePositon.scale(0.1f));
    }

    @Override
    public void draw2D(PGraphics p, Transformation t) {
        this.scalingFactor = t.getScale();
        this.boundingBoxSize = 4.0f / this.scalingFactor;
        if (this.vertices.size() > 0) {
            this.drawCloseRect(p);
            int i = 0;
            while (i < this.vertices.size() - 1) {
                p.line(this.vertices.get(i).scale(this.scalingFactor).x(), this.vertices.get(i).scale(this.scalingFactor).y(), this.vertices.get(i + 1).scale(this.scalingFactor).x(), this.vertices.get(i + 1).scale(this.scalingFactor).y());
                ++i;
            }
            p.line(this.vertices.get(this.vertices.size() - 1).scale(this.scalingFactor).x(), this.vertices.get(this.vertices.size() - 1).scale(this.scalingFactor).y(), this.lastKnownMousePositon.scale(this.scalingFactor).x(), this.lastKnownMousePositon.scale(this.scalingFactor).y());
        }
        super.draw2D(p, t);
    }

    private void drawCloseRect(PGraphics p) {
        if (this.mouseOverCloseShape()) {
            p.stroke(255.0f, 0.0f, 0.0f);
        } else {
            p.stroke(0);
        }
        p.noFill();
        p.rect(this.vertices.get(0).scale(this.scalingFactor).x() - this.boundingBoxSize, this.vertices.get(0).scale(this.scalingFactor).y() - this.boundingBoxSize, 10.0f, 10.0f);
        p.stroke(0);
    }

    @Override
    public void toolWasSelected() {
        this.application.displayStatus("To start drawing a shape, click the left mousebutton anywhere on the 2D view");
        this.vertices = new ArrayList<Vector2D>();
        super.toolWasSelected();
    }

    @Override
    public void toolWasUnselected() {
        this.application.displayStatus("");
        super.toolWasUnselected();
    }
}

