/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.ShapeButton;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.view.Drawable2D;
import de.mcp.cutcad.view.DrawingView2D;
import de.mcp.cutcad.view.SVGIcon;
import de.mcp.cutcad.view.Transformation;
import java.util.Timer;
import java.util.TimerTask;
import processing.core.PGraphics;

public abstract class Tool
implements Drawable2D {
    protected DrawingView2D view;
    protected CutCADApplet application;
    protected ObjectContainer objectContainer;
    private ShapeButton button;

    public Tool(CutCADApplet application, ObjectContainer container) {
        this.view = application.drawingView2D;
        this.application = application;
        this.objectContainer = container;
        PGraphics p = this.application.createGraphics(40, 40);
        this.button = new ShapeButton(this.getIcon(), p, this.view.getTransformation());
    }

    public abstract String getIconName();

    public void mouseButtonPressed(Vector2D position, int button) {
    }

    public void mouseButtonReleased(Vector2D position, int button) {
    }

    public void mouseMoved(Vector2D position) {
    }

    public void toolWasSelected() {
        this.button.setSelected(true);
        if (!this.canStaySelected()) {
            Timer unselectTimer = new Timer();
            unselectTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Tool.this.toolWasUnselected();
                }
            }, 100L);
        }
    }

    public void toolWasUnselected() {
        this.button.setSelected(false);
    }

    @Override
    public void draw2D(PGraphics p, Transformation transform) {
    }

    public boolean canStaySelected() {
        return true;
    }

    public ShapeButton getButton() {
        return this.button;
    }

    private SVGIcon getIcon() {
        float iconScaling = 1.25f;
        SVGIcon icon = new SVGIcon(this.getIconName(), iconScaling);
        return icon;
    }
}

