/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.application;

import controlP5.ControlEvent;
import controlP5.ControlP5;
import de.mcp.cutcad.application.Properties;
import de.mcp.cutcad.application.Statusbar;
import de.mcp.cutcad.application.Tool;
import de.mcp.cutcad.application.Toolbar;
import de.mcp.cutcad.application.ToolbarDelegate;
import de.mcp.cutcad.model.AllMaterials;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.view.DrawingView2D;
import de.mcp.cutcad.view.DrawingView3D;
import de.mcp.cutcad.view.DrawingViewFrame;
import de.mcp.cutcad.view.Transformation;
import geomerative.RG;
import javax.swing.JOptionPane;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.event.MouseEvent;
import processing.opengl.PGraphics3D;

public class CutCADApplet
extends PApplet
implements ToolbarDelegate {
    private static final long serialVersionUID = 6945013714741954254L;
    int viewSizeX;
    int viewSizeY;
    ControlP5 cp5;
    Toolbar toolbar;
    public Properties properties;
    Statusbar statusbar;
    ObjectContainer container = new ObjectContainer();
    private Tool selectedTool;
    public Transformation transform2D = new Transformation(1.0f, new Vector2D(-50.0f, -50.0f));
    Transformation transform3D = new Transformation(1.0f, new Vector2D(0.0f, 0.0f));
    public DrawingView2D drawingView2D;
    public DrawingView3D drawingView3D;

    public void setup() {
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.ortho();
        int toolbarWidth = 40;
        this.viewSizeX = (this.displayWidth - toolbarWidth - 30) / 2;
        this.viewSizeY = this.displayHeight - 50 - 30;
        this.setup2DDrawingView(toolbarWidth, 50, this.viewSizeX, this.viewSizeY);
        int view3DPosX = toolbarWidth + this.viewSizeX + 15;
        int view3DPosY = 50;
        this.setup3DDrawingView(view3DPosX, view3DPosY, this.viewSizeX, this.viewSizeY);
        new AllMaterials().addMaterialsFromFile("materials");
        this.cp5 = new ControlP5((PApplet)this);
        this.createProperties();
        this.statusbar = new Statusbar();
        this.toolbar = Toolbar.createDefaultToolbar(this);
    }

    private void setup2DDrawingView(int originX, int originY, int width, int heigth) {
        DrawingViewFrame theFrame = new DrawingViewFrame();
        theFrame.origin = new Vector2D(originX, originY);
        theFrame.size = new Vector2D(width, heigth);
        PGraphics view2D = this.createGraphics(width, heigth, "processing.opengl.PGraphics3D");
        this.drawingView2D = new DrawingView2D(view2D, theFrame, this.transform2D, this);
    }

    private void setup3DDrawingView(int originX, int originY, int width, int height) {
        RG.init((PApplet)this);
        RG.ignoreStyles((boolean)false);
        RG.setPolygonizer((int)RG.ADAPTATIVE);
        DrawingViewFrame theFrame = new DrawingViewFrame();
        theFrame.origin = new Vector2D(originX, originY);
        theFrame.size = new Vector2D(width, height);
        PGraphics3D view3D = (PGraphics3D)this.createGraphics(width, height, "processing.opengl.PGraphics3D");
        this.drawingView3D = new DrawingView3D(view3D, theFrame, this.transform3D, this);
    }

    public void draw() {
        this.background(255);
        this.fill(0);
        this.drawingView2D.draw(this.container);
        this.drawingView3D.draw(this.container);
        this.properties.drawProperties(this);
        this.statusbar.drawStatusbar(this);
    }

    private void createProperties() {
        this.properties = new Properties(this.cp5, 0, 0, this.width, 50);
        this.properties.hide();
    }

    public void displayStatus(String status) {
        this.statusbar.setStatus(status);
    }

    public void displayMousePosition(Vector2D position) {
        this.statusbar.setMousePosition(position);
    }

    public void controlEvent(ControlEvent theEvent) {
        if (theEvent.isGroup() && theEvent.getGroup().getName() == "setMaterial") {
            this.properties.changeMaterial(theEvent.getGroup().getValue());
        }
    }

    @Override
    public void toolWasSelected(Tool theTool) {
        this.setSelectedTool(theTool);
    }

    void setSelectedTool(Tool theTool) {
        theTool.toolWasSelected();
        if (theTool.canStaySelected()) {
            if (this.selectedTool != null) {
                this.selectedTool.toolWasUnselected();
            }
            this.selectedTool = theTool;
        }
    }

    public Tool getSelectedTool() {
        return this.selectedTool;
    }

    public void mousePressed() {
        Vector2D mousePosition = new Vector2D(this.mouseX, this.mouseY);
        this.getSelectedTool().mouseButtonPressed(mousePosition, this.mouseButton);
    }

    public void mouseDragged() {
        this.getSelectedTool().mouseMoved(new Vector2D(this.mouseX, this.mouseY));
    }

    public void mouseReleased() {
        this.getSelectedTool().mouseButtonReleased(new Vector2D(this.mouseX, this.mouseY), this.mouseButton);
    }

    public void mouseMoved() {
        Vector2D mousePosition = new Vector2D(this.mouseX, this.mouseY);
        this.getSelectedTool().mouseMoved(mousePosition);
        this.drawingView3D.setInteractionEnabled(this.drawingView3D.mouseOver(mousePosition));
    }

    public void keyPressed() {
        int response;
        if (this.key == '+' && this.drawingView2D.mouseOver(new Vector2D(this.mouseX, this.mouseY))) {
            this.transform2D.scaleUp(0.01f);
        }
        if (this.key == '-' && this.drawingView2D.mouseOver(new Vector2D(this.mouseX, this.mouseY))) {
            this.transform2D.scaleDown(0.01f);
        }
        if (this.keyCode == 27 && this.container.hasUnsavedChanges() && ((response = JOptionPane.showConfirmDialog(null, "You have unsaved changes. Quit anyways?")) == 2 || response == 1)) {
            this.key = '\u0000';
        }
    }

    public void mouseWheel(MouseEvent event) {
        if (this.drawingView2D.mouseOver(new Vector2D(this.mouseX, this.mouseY))) {
            this.transform2D.scaleUp((float)(0.01 * (double)(-event.getAmount())));
        }
    }

    public static void main(String[] args) {
        PApplet.main((String[])new String[]{"de.mcp.cutcad.application.CutCADApplet"});
    }

    public boolean sketchFullScreen() {
        return true;
    }
}

