/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.algorithm;

import de.mcp.cutcad.algorithm.CreateTenons;
import de.mcp.cutcad.model.Connection;
import de.mcp.cutcad.model.primitives.Edge;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.model.primitives.Vector3D;
import de.mcp.cutcad.model.shapes.Rectangle;
import java.util.List;
import toxi.geom.Line3D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Vec3D;

public class RotateAdjectantShapes {
    private static float tolerance = 1.0f;
    private static Shape virtualShape = new Rectangle(new Vector3D(0.0f, 0.0f, 0.0f), 1, 1);
    private static Edge edgeA = new Edge(virtualShape.getGShape(), new Vector3D(1.0f, 1.0f, 1.0f), new Vector3D(1.0f, 1.0f, 1.0f), new Vector2D(1.0f, 1.0f), new Vector2D(1.0f, 1.0f));
    private static Edge edgeB = new Edge(virtualShape.getGShape(), new Vector3D(1.0f, 1.0f, 1.0f), new Vector3D(1.0f, 1.0f, 1.0f), new Vector2D(1.0f, 1.0f), new Vector2D(1.0f, 1.0f));
    private static Vector3D intersectionPoint = new Vector3D(0.0f, 0.0f, 0.0f);

    public static boolean rotateBothShapes(Connection connection, Edge masterEdge, Edge slaveEdge) {
        edgeA = masterEdge;
        edgeB = slaveEdge;
        if (RotateAdjectantShapes.getNormalVector(masterEdge, slaveEdge).isZeroVector()) {
            System.out.println("Error: Parallel Edges");
            return false;
        }
        Edge rotatingEdgeMaster = RotateAdjectantShapes.getRotatingEdge(masterEdge);
        Edge rotatingEdgeSlave = RotateAdjectantShapes.getRotatingEdge(slaveEdge);
        RotateAdjectantShapes.initialiseVirtualShape(masterEdge, slaveEdge);
        Edge rotateEdgeSlaveOfConnectingShape = virtualShape.getGShape().getEdges().get(1);
        Edge rotateEdgeMasterOfConnectingShape = virtualShape.getGShape().getEdges().get(0);
        if (masterEdge.getGShape().getNumberOfConnections() > 1) {
            connection.connectEdges(rotateEdgeSlaveOfConnectingShape, rotatingEdgeSlave, (float)Math.PI);
            float angle = RotateAdjectantShapes.rotateOnlyOneShape(slaveEdge, masterEdge);
            boolean couldConnect = RotateAdjectantShapes.tryToConnectOneEdge(connection, rotateEdgeSlaveOfConnectingShape, rotatingEdgeSlave, angle);
            if (!couldConnect) {
                connection.connectEdges(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeSlave), rotatingEdgeSlave, (float)Math.PI);
                CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeSlave), rotatingEdgeSlave);
                return false;
            }
            CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeSlave), rotatingEdgeSlave);
            CreateTenons.createOutlineOfEdge(masterEdge, slaveEdge);
            connection.lockConnection(true);
            return true;
        }
        if (slaveEdge.getGShape().getNumberOfConnections() > 1) {
            connection.connectEdges(rotateEdgeMasterOfConnectingShape, rotatingEdgeMaster, (float)Math.PI);
            float angle = RotateAdjectantShapes.rotateOnlyOneShape(masterEdge, slaveEdge);
            boolean couldConnect = RotateAdjectantShapes.tryToConnectOneEdge(connection, rotateEdgeMasterOfConnectingShape, rotatingEdgeMaster, angle);
            if (!couldConnect) {
                connection.connectEdges(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeMaster), rotatingEdgeMaster, (float)Math.PI);
                CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeMaster), rotatingEdgeMaster);
                return false;
            }
            CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeMaster), rotatingEdgeMaster);
            CreateTenons.createOutlineOfEdge(masterEdge, slaveEdge);
            connection.lockConnection(true);
            return true;
        }
        connection.connectEdges(rotateEdgeMasterOfConnectingShape, rotatingEdgeMaster, 0.0f);
        connection.connectEdges(rotateEdgeSlaveOfConnectingShape, rotatingEdgeSlave, 0.0f);
        intersectionPoint = RotateAdjectantShapes.findIntersectionPoint(masterEdge, slaveEdge);
        float angleMasterB = RotateAdjectantShapes.getRotationFor(masterEdge);
        float angleSlaveB = RotateAdjectantShapes.getRotationFor(slaveEdge);
        System.out.println("Angles " + angleMasterB + ", " + angleSlaveB);
        boolean couldConnect = RotateAdjectantShapes.tryToConnectBothEdges(connection, rotateEdgeMasterOfConnectingShape, rotatingEdgeMaster, angleMasterB, rotateEdgeSlaveOfConnectingShape, rotatingEdgeSlave, angleSlaveB);
        if (!couldConnect) {
            connection.connectEdges(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeMaster), rotatingEdgeMaster, (float)Math.PI);
            connection.connectEdges(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeSlave), rotatingEdgeSlave, (float)Math.PI);
            CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeMaster), rotatingEdgeMaster);
            CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeSlave), rotatingEdgeSlave);
            return false;
        }
        CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeMaster), rotatingEdgeMaster);
        CreateTenons.createOutlineOfEdge(RotateAdjectantShapes.getAlreadyConnectedEdge(rotatingEdgeSlave), rotatingEdgeSlave);
        CreateTenons.createOutlineOfEdge(masterEdge, slaveEdge);
        connection.lockConnection(true);
        return true;
    }

    private static Edge getOtherEdge(Edge edge) {
        return edge == edgeA ? edgeB : edgeA;
    }

    private static Vector3D getCommonPoint(Edge edge) {
        return RotateAdjectantShapes.compareEdges(edge, RotateAdjectantShapes.getOtherEdge(edge)) ? edge.getP3D1() : edge.getP3D2();
    }

    private static Vector3D getNotCommonPoint(Edge edge) {
        return RotateAdjectantShapes.compareEdges(edge, RotateAdjectantShapes.getOtherEdge(edge)) ? edge.getP3D2() : edge.getP3D1();
    }

    private static Edge getRotatingEdge(Edge edge) {
        List<Edge> edges = edge.getGShape().getEdges();
        int numberOfEdges = edges.size();
        if (RotateAdjectantShapes.compareEdges(edge, RotateAdjectantShapes.getOtherEdge(edge))) {
            return edges.get((edges.indexOf(edge) + numberOfEdges - 1) % numberOfEdges);
        }
        return edges.get((edges.indexOf(edge) + 1) % numberOfEdges);
    }

    private static Vector3D getPointOfRotatingEdge(Edge edge) {
        Edge rotatingEdge = RotateAdjectantShapes.getRotatingEdge(edge);
        return RotateAdjectantShapes.compareEdges(rotatingEdge, edge) ? rotatingEdge.getP3D2() : rotatingEdge.getP3D1();
    }

    private static boolean compareEdges(Edge edge1, Edge edge2) {
        boolean compareMasterP1ToSlaveP1 = edge1.getP3D1().equalsWithTolerance(edge2.getP3D1(), tolerance);
        boolean compareMasterP1ToSlaveP2 = edge1.getP3D1().equalsWithTolerance(edge2.getP3D2(), tolerance);
        return compareMasterP1ToSlaveP1 || compareMasterP1ToSlaveP2;
    }

    private static void initialiseVirtualShape(Edge masterEdge, Edge slaveEdge) {
        List<Edge> edges = virtualShape.getGShape().getEdges();
        edges.get(0).setP3D1(RotateAdjectantShapes.getRotatingEdge(masterEdge).getP3D2().copy());
        edges.get(0).setP3D2(RotateAdjectantShapes.getRotatingEdge(masterEdge).getP3D1().copy());
        edges.get(1).setP3D1(RotateAdjectantShapes.getRotatingEdge(slaveEdge).getP3D2().copy());
        edges.get(1).setP3D2(RotateAdjectantShapes.getRotatingEdge(slaveEdge).getP3D1().copy());
        edges.get(2).setP3D1(RotateAdjectantShapes.getRotatingEdge(masterEdge).getP3D1().copy());
        edges.get(2).setP3D2(RotateAdjectantShapes.getRotatingEdge(slaveEdge).getP3D2().copy());
        edges.get(3).setP3D1(RotateAdjectantShapes.getRotatingEdge(slaveEdge).getP3D2().copy());
        edges.get(3).setP3D2(RotateAdjectantShapes.getRotatingEdge(masterEdge).getP3D2().copy());
    }

    private static float rotateOnlyOneShape(Edge edgeA, Edge edgeB) {
        Vector3D directionEdge = RotateAdjectantShapes.getNotCommonPoint(edgeB).sub(RotateAdjectantShapes.getCommonPoint(edgeB));
        Vector3D directionRotatingEdge = RotateAdjectantShapes.getPointOfRotatingEdge(edgeA).sub(RotateAdjectantShapes.getCommonPoint(edgeA));
        Vector3D normalVectorSlave = directionEdge.cross(directionRotatingEdge).normalize();
        float angle = RotateAdjectantShapes.safeAngleBetween(virtualShape.getGShape().getNormalVector(), normalVectorSlave);
        return angle;
    }

    private static Vector3D findIntersectionPoint(Edge edge1, Edge edge2) {
        Line3D intersectionLine2;
        Line3D intersectionLine1 = RotateAdjectantShapes.getIntersectionLine(edge1);
        if (intersectionLine1.closestLineTo(intersectionLine2 = RotateAdjectantShapes.getIntersectionLine(edge2)).getType().equals((Object)Line3D.LineIntersection.Type.valueOf((String)"INTERSECTING"))) {
            return new Vector3D(intersectionLine1.closestLineTo(intersectionLine2).getLine().getMidPoint());
        }
        return RotateAdjectantShapes.getNotCommonPoint(edge1);
    }

    private static float safeAngleBetween(Vector3D masterEdgeDirection, Vector3D slaveEdgeDirection) {
        float angle = slaveEdgeDirection.angleBetween(masterEdgeDirection, true);
        if (Float.isNaN(angle)) {
            angle = slaveEdgeDirection.add(masterEdgeDirection).equalsWithTolerance(new Vector3D(0.0f, 0.0f, 0.0f), 0.1f) ? (float)Math.PI : 0.0f;
        }
        return angle;
    }

    private static Line3D getIntersectionLine(Edge edge) {
        Edge virtualEdgeA = virtualShape.getGShape().getEdges().get(0);
        Edge virtualEdgeB = virtualShape.getGShape().getEdges().get(1);
        Vector3D rotationAxis = RotateAdjectantShapes.getPointOfRotatingEdge(edge).sub(RotateAdjectantShapes.getCommonPoint(edge));
        Vector3D notCommonPoint = RotateAdjectantShapes.getNotCommonPoint(edge).sub(RotateAdjectantShapes.getCommonPoint(edge));
        float angle = RotateAdjectantShapes.safeAngleBetween(rotationAxis, notCommonPoint);
        Vector3D rotated = RotateAdjectantShapes.getNotCommonPoint(edge).sub(RotateAdjectantShapes.getCommonPoint(edge)).rotateAroundAxis(RotateAdjectantShapes.getNormalVector(virtualEdgeA, virtualEdgeB), -2.0f * angle).add(RotateAdjectantShapes.getCommonPoint(edge));
        if (RotateAdjectantShapes.safeAngleBetween(rotationAxis, rotated.sub(RotateAdjectantShapes.getCommonPoint(edge))) != angle) {
            rotated = RotateAdjectantShapes.getNotCommonPoint(edge).sub(RotateAdjectantShapes.getCommonPoint(edge)).rotateAroundAxis(RotateAdjectantShapes.getNormalVector(virtualEdgeA, virtualEdgeB), 2.0f * angle).add(RotateAdjectantShapes.getCommonPoint(edge));
        }
        return new Line3D(RotateAdjectantShapes.getNotCommonPoint(edge).getVec3D(), rotated.getVec3D());
    }

    private static float getRotationFor(Edge edge) {
        double lengthVectorToAxisMaster;
        Line3D rotationAxis = new Line3D(RotateAdjectantShapes.getPointOfRotatingEdge(edge).getVec3D(), RotateAdjectantShapes.getCommonPoint(edge).getVec3D()).toRay3D().toLine3DWithPointAtDistance(10000.0f);
        Vec3D intersectionWithRotationAxis = RotateAdjectantShapes.getIntersectionLine(edge).closestLineTo(rotationAxis).getLine().getMidPoint();
        double lengthIntersectionToAxisMaster = intersectionWithRotationAxis.distanceTo((ReadonlyVec3D)intersectionPoint.getVec3D());
        float angle = (float)Math.acos(lengthIntersectionToAxisMaster / (lengthVectorToAxisMaster = (double)intersectionWithRotationAxis.distanceTo((ReadonlyVec3D)RotateAdjectantShapes.getNotCommonPoint(edge).getVec3D())));
        if (Float.isNaN(angle)) {
            return (float)Math.PI;
        }
        return angle;
    }

    private static Edge getAlreadyConnectedEdge(Edge edge) {
        for (Connection c : Connection.getConnections()) {
            if (c.getMasterEdge() == edge) {
                return c.getSlaveEdge();
            }
            if (c.getSlaveEdge() != edge) continue;
            return c.getMasterEdge();
        }
        return edgeA;
    }

    private static Vector3D getNormalVector(Edge edge1, Edge edge2) {
        Vector3D directionEdge1 = RotateAdjectantShapes.getPointOfRotatingEdge(edge1).sub(RotateAdjectantShapes.getCommonPoint(edge1));
        Vector3D directionEdge2 = RotateAdjectantShapes.getPointOfRotatingEdge(edge2).sub(RotateAdjectantShapes.getCommonPoint(edge2));
        return directionEdge1.cross(directionEdge2).normalize();
    }

    private static boolean tryToConnectOneEdge(Connection connection, Edge masterEdge, Edge slaveEdge, float angle) {
        float newAngle;
        int i = 0;
        while (i < 9) {
            newAngle = (angle + 1.5707964f * (float)(i / 2)) * (float)Math.pow(-1.0, i + 1);
            connection.connectEdges(masterEdge, slaveEdge, newAngle);
            if (edgeA.getP3D1().equalsWithTolerance(edgeB.getP3D1(), tolerance) && edgeA.getP3D2().equalsWithTolerance(edgeB.getP3D2(), tolerance) || edgeA.getP3D1().equalsWithTolerance(edgeB.getP3D2(), tolerance) && edgeA.getP3D2().equalsWithTolerance(edgeB.getP3D1(), tolerance)) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < 9) {
            newAngle = (angle - 1.5707964f * (float)(i / 2)) * (float)Math.pow(-1.0, i + 1);
            connection.connectEdges(masterEdge, slaveEdge, newAngle);
            if (edgeA.getP3D1().equalsWithTolerance(edgeB.getP3D1(), tolerance) && edgeA.getP3D2().equalsWithTolerance(edgeB.getP3D2(), tolerance) || edgeA.getP3D1().equalsWithTolerance(edgeB.getP3D2(), tolerance) && edgeA.getP3D2().equalsWithTolerance(edgeB.getP3D1(), tolerance)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean tryToConnectBothEdges(Connection connection, Edge masterEdge1, Edge masterEdge2, float masterAngle, Edge slaveEdge1, Edge slaveEdge2, float slaveAngle) {
        boolean isCorrectAligned = false;
        int i = 1;
        while (i < 9) {
            float newAngle = (-masterAngle - 1.5707964f * (float)((i - 1) / 2)) * (float)Math.pow(-1.0, i);
            connection.connectEdges(masterEdge1, masterEdge2, newAngle);
            isCorrectAligned = RotateAdjectantShapes.tryToConnectOneEdge(connection, slaveEdge1, slaveEdge2, slaveAngle);
            if (isCorrectAligned) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

