/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.algorithm;

import de.mcp.cutcad.model.Connection;
import de.mcp.cutcad.model.primitives.Edge;
import java.util.ArrayList;
import java.util.HashMap;

public class GenerateEngravingIDs {
    private static char c1;
    private static char c2;

    public static HashMap<Edge, String> getEngravingIDMap(ArrayList<Connection> connections) {
        GenerateEngravingIDs.resetConnectionID();
        return GenerateEngravingIDs.createIDs(connections);
    }

    private static HashMap<Edge, String> createIDs(ArrayList<Connection> connections) {
        HashMap<Edge, String> result = new HashMap<Edge, String>();
        for (Connection c : connections) {
            result.put(c.getMasterEdge(), GenerateEngravingIDs.getConnectionID());
            result.put(c.getSlaveEdge(), GenerateEngravingIDs.getConnectionID());
            GenerateEngravingIDs.incrementConnectionID();
        }
        return result;
    }

    private static void incrementConnectionID() {
        if (c2 < 'Z') {
            c2 = (char)(c2 + '\u0001');
        } else if (c1 < 'Z') {
            c2 = (char)65;
            c1 = (char)(c1 + '\u0001');
        } else {
            GenerateEngravingIDs.resetConnectionID();
        }
    }

    private static String getConnectionID() {
        return "" + c1 + c2;
    }

    private static void resetConnectionID() {
        c1 = (char)65;
        c2 = (char)65;
    }
}

