/*jslint node: true, plusplus: true, nomen: true */
'use strict';

// This module is supposed to run in its own process and generate a source map from 
// original code to instrumented code
// It receives the code via inter-process-communication and applies the normal instrumentation to it
// using the utils module, which is also used by the runtime. 
// It just tells the utils to also generate a source map which takes a lot of time 
// (usually half of the complete instrumentation time) which is why we run it in a separate process
// when it's done it sends the raw source map string back to the requesting client and 

process.title = "LiveCoding-node sourceMap generation";

var utils = require("./utils");

function generateSourceMapForCode(theCode) {
    var generatedCodeAndRawSourceMap, sourceMapString;
    try {
        generatedCodeAndRawSourceMap = utils.instrumentCode(theCode, true);
        sourceMapString = String(generatedCodeAndRawSourceMap.rawSourceMap);
    } catch (exception) {
        // ignore any errors, if errors occur, we were simply not able to calculate the source map
        // all errors that do occur should also occur in the normal instrumentation and should thus be found and reported there
    }
    return sourceMapString;
}

process.on("message", function (msg) {
    var sourceMapString = generateSourceMapForCode(msg);
    if (sourceMapString !== undefined) {
        process.send({ type: "sourceMap", sourceMapString: sourceMapString });
    } else {
        process.send({type: "error", error: "Could not generate sourceMap!" });
    }
    process.exit(); // we are done here
});

//console.log("Started sourceMapGenerator!");