/*jslint node:true */

exports.timeExecution = function (func) {
    "use strict";
    var t = (new Date()).getTime();
    func();
    return ((new Date()).getTime() - t);
};


exports.extractInterestingValuesFromStack = function (stack) {
    "use strict";
    if (typeof stack.map !== "function") {
        return stack;
    }
    return stack.map(function (callItem) {
        return {
            line: callItem.getLineNumber(),
            column: callItem.getColumnNumber(),
            file: callItem.getFileName(),
            functionName: callItem.getFunctionName()
        };
    });
};

var loggedTimes = {};
function logExecutionTime(key, theFunction) {
    "use strict";
    var executionTime = exports.timeExecution(theFunction),
        oldTotal = loggedTimes[key] || 0;
    loggedTimes[key] = oldTotal + executionTime;
    console.log("Executed " + key + " in " + executionTime + "ms (total: " + loggedTimes[key] + "ms)");
}

function logTotals() {
    "use strict";
    console.log(loggedTimes);
}

exports.timeLogger = {
    logExecutionTime: logExecutionTime,
    logTotals: logTotals
};