/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */
/*global define, CodeMirror, brackets, less, $, XMLHttpRequest, document */

define(function (require, exports, module) {
    'use strict';
    var AppInit             = brackets.getModule("utils/AppInit");
    var EditorManager       = brackets.getModule("editor/EditorManager");
    var DocumentManager     = brackets.getModule("document/DocumentManager");
    var Editor              = brackets.getModule('editor/Editor');
    var TextRange           = brackets.getModule('document/TextRange').TextRange;
    var ExtensionUtils      = brackets.getModule("utils/ExtensionUtils");
    var LiveDataPane        = require('LiveDataPane');
    var LiveDataView        = require('LiveDataView');
    var LiveDataController  = require('LiveDataController');
    
    
    // initalization
    console.log("loading live coding preview!");
    ExtensionUtils.loadStyleSheet(module, "main.less");
    LiveDataController.setDataView(LiveDataView);
    LiveDataController.setPreviewPane(LiveDataPane);
    LiveDataView.setDataSource(LiveDataController);
    LiveDataView.setDelegate(LiveDataController);
    
    
    
    // called when the current document changes
    function _setupLiveCodingEditorForChangedDocument(theEvent) {
        var theCurrentDocument = DocumentManager.getCurrentDocument();
        if (theCurrentDocument !== null) {
            // make sure we have a live data preview pane for this document
            var $previewLinesContainer = LiveDataPane.setupLiveDataPreview();
            LiveDataView.setPreviewLinesContainer($previewLinesContainer);
        }
        LiveDataController.setDocumentToPreview(theCurrentDocument);
    }
    
    AppInit.appReady(function () {
        $("#status-indicators").append("<div id='lc-executing-status-indicator' title='Code is being executed!'>&nbsp;</div>");
        $("#main-toolbar .buttons").append("<a href='#' id='liveCodingToolbarButton' title='Live Execution Completed'></a>");
        $("#lc-executing-status-indicator").hide();
        $(DocumentManager).on("currentDocumentChange", _setupLiveCodingEditorForChangedDocument);
        // call the function that will be called when the current document changes. If there is already one it will be set up correctly.
        _setupLiveCodingEditorForChangedDocument(null);
    });
});