/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50, todo: true */
/*global define, CodeMirror, brackets, less, $, XMLHttpRequest, document, window */

define(function (require, exports, module) {
    "use strict";
    
    var Resizer             = brackets.getModule("utils/Resizer");
    
    var $assistantPane,
        $codeMirrorScrollView;
    
    
    function _updateResize(event) {
        $codeMirrorScrollView.width($codeMirrorScrollView.parent().width() - $assistantPane.width() - 30 - 10); // adjusted for margin of editor and margin of assitant pane. Yes, it's ugly. As soon as I find a nicer way, I'll do it that way.
        $(".CodeMirror:visible .CodeMirror-hscrollbar").width($assistantPane.offset().left - $codeMirrorScrollView.offset().left - $(".CodeMirror:visible .CodeMirror-gutters").width() - 2);
    }
    
    function _synchronizeScrolling($scrollView1, $scrollView2) {
        var scrolledInScrollView1 = false,
            scrolledInScrollView2 = false;
        
        $scrollView1.off("scroll.synchronizeScrolling");
        $scrollView2.off("scroll.synchronizeScrolling");
        
        $scrollView1.on("scroll.synchronizeScrolling", function () {
            if (scrolledInScrollView2) {
                // was scrolled by other scroll view
                // reset marker
                scrolledInScrollView2 = false;
                // do nothing else
            } else {
                // scrolling originated in this scroll view (set marker)
                scrolledInScrollView1 = true;
                // scroll the other scroll view
                $scrollView2.scrollTop($scrollView1.scrollTop());
            }
        });
        
        $scrollView2.on("scroll.synchronizeScrolling", function () {
            if (scrolledInScrollView1) {
                // was scrolled by other scroll view
                // reset marker
                scrolledInScrollView1 = false;
                // do nothing else
            } else {
                // scrolling originated in this scroll view
                scrolledInScrollView2 = true;
                // scroll the other scroll view
                $scrollView1.scrollTop($scrollView2.scrollTop());
            }
        });
        
        $scrollView1.scrollToFitSynchronizedScrollView = function () {
            scrolledInScrollView2 = true;
            $scrollView1.scrollTop($scrollView2.scrollTop());
        };
        $scrollView2.scrollToFitSynchronizedScrollView = function () {
            scrolledInScrollView1 = true;
            $scrollView2.scrollTop($scrollView1.scrollTop());
        };
    }
    
    
    function setupLiveDataPreview() {
        var $previewLinesContainer = $(".CodeMirror:visible .assistantPane-contentView");
        if ($previewLinesContainer.length > 0) {
            $assistantPane = $(".CodeMirror:visible .assistantPane");
            $previewLinesContainer.scrollView = $assistantPane;
            $codeMirrorScrollView = $(".CodeMirror:visible .CodeMirror-scroll");
            _synchronizeScrolling($codeMirrorScrollView, $assistantPane);
            return $previewLinesContainer;
        }
        
        // setup the assistant pane for the live coding preview
        $assistantPane = $(document.createElement('div')).attr("class", "assistantPane");
        //$assistantPane.css("background-color", "red");
        

        $codeMirrorScrollView = $(".CodeMirror:visible .CodeMirror-scroll");
        //$codeMirrorScrollView.wrap("<div/>");
        //var $codeMirrorScrollViewContainer = $codeMirrorScrollView.parent();
        $assistantPane.insertBefore($codeMirrorScrollView);
        
        var $previewLinesContainerContainer = $("<div class='CodeMirror-lines'>").appendTo($assistantPane);
        $previewLinesContainer = $("<div class='assistantPane-contentView'>").appendTo($previewLinesContainerContainer);
        
        $codeMirrorScrollView.css("width", "50%");
        //$codeMirrorScrollViewContainer.css("overflow", "hidden");
        Resizer.makeResizable($assistantPane[0], "horz", "left", 200, false);
        $assistantPane.on("panelResizeUpdate.LiveDataPane", _updateResize);
        _updateResize();
        
        _synchronizeScrolling($codeMirrorScrollView, $assistantPane);
        $previewLinesContainer.scrollView = $assistantPane;
        return $previewLinesContainer;
    }
    
    
    exports.setupLiveDataPreview = setupLiveDataPreview;
});