/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */
/*global define, CodeMirror, brackets, less, $, XMLHttpRequest, document, window, WebSocket */

define(function (require, exports, module) {
    "use strict";
    
    var wsURI = "ws://localhost:1234";
    
    var assignmentCallBack,
        websocket,
        pendingCodeToRun,
        idOfCurrentCode,
        messagesBatchesToProcess = [],
        indexOfNextMessagesBatchToProcess = 0,
        messagesReceived = 0,
        lastCodeSentTimestamp, executionWasStopped = true;
    
    var webSocketOpen = false,
        openingWebSocket = false;
    
    function _openSocket(callOnOpen, callOnMsg) {
        websocket = new WebSocket(wsURI);
        
        websocket.onclose = function (evt) {
            console.log("Closing websocket.");
            webSocketOpen = false;
            openingWebSocket = false;
            assignmentCallBack({
                type: "Server Connection",
                reason: "closed"
            });
        };
        websocket.onerror = function (evt) {
            console.log("Error: " + evt.data);
            webSocketOpen = false;
            openingWebSocket = false;
            assignmentCallBack({
                type: "Server Connection",
                reason: "error",
                message: "Error :" + evt.data,
                event: evt
            });
        };
        
        websocket.onopen = callOnOpen;
        websocket.onmessage = function (evt) { callOnMsg(evt.data); };
    }
    
    function _receivedMessage(message) {
        
        
        
        function correctLocationOfMessage(msg) {
            // massage the location into a format that fits us better
            function getAdjustedLocation(originalLocation) {
                var location = {start: {}, end: {}};
                // in the current format lines start at 1, but columns at 0. We normalize both to start at 0.
                location.start.line = originalLocation.start.line - 1;
                location.end.line = originalLocation.end.line - 1;
                
                // also the colum attribute for CodeMirror is called "ch" so we rename it
                location.start.ch = originalLocation.start.column;
                location.end.ch = originalLocation.end.column;
                return location;
            }
            
            if (msg.loc) {
                if ((msg.loc.start === undefined) || (msg.loc.end === undefined)
                        || (msg.loc.start.line === undefined) || (msg.loc.end.line === undefined)
                        || (msg.loc.start.column === undefined) || (msg.loc.end.column === undefined)) {
                    console.log(msg);
                    throw new TypeError("Location property of message does not have all required properties: " + msg.type);
                }
                
                msg.location = getAdjustedLocation(msg.loc);
                
                
                // some message have properties for which we have to adjust the locations as well
                if ((msg.type === "function enter") && (msg.argLocs)) {
                    msg.argumentLocations = msg.argLocs.map(getAdjustedLocation);
                } else if (msg.type === "function declaration") {
                    msg.bodyLocation = getAdjustedLocation(msg.bodyLoc);
                } else if (msg.type === "for-in-loop enter") {
                    msg.loopVarLocation = getAdjustedLocation(msg.loopVarLoc);
                }
            }
        }
        
        
        if (message.type === "variables init") {
            // split them up into individual messages
            message.vars.forEach(function (varInit) {
                varInit.type = "variable initilization";
                _receivedMessage(varInit);
            });
            return; // already processed this message completely
        } // else 
        if (message.hasOwnProperty("values")) { // split up into individual messages
            message.values.forEach(function (aValue) {
                _receivedMessage({
                    type: message.type,
                    value: aValue,
                    loc: message.loc
                });
            });
            return; // already processed this message completely
        } // else
        
        message.index = messagesReceived;
        correctLocationOfMessage(message);
        
        messagesReceived++;
        
        assignmentCallBack(message);
    }
    
    function _receivedMessagesBatch(receivedMessagesString) {
        if (executionWasStopped) {
            return;
        }
        //console.log(receivedMessagesString);
        if ((assignmentCallBack === undefined) || (assignmentCallBack === null)) {
            return;
        }
        // else
        
        var indexOfIDSeparator = receivedMessagesString.indexOf("#");
        if (indexOfIDSeparator === -1) {
            console.error("No id separator found in message string: '" + receivedMessagesString + "'");
            return;
        } // else
        
        var idOfCodeString = receivedMessagesString.substring(0, indexOfIDSeparator);
        var messageToProcess = receivedMessagesString.substring(indexOfIDSeparator + 1);
        
        if (parseInt(idOfCodeString, 10) === idOfCurrentCode) {
            // only if its a message belonging to the currently executed code
            messagesBatchesToProcess.push(messageToProcess);
            //console.log("received a batch of messages");
        }
    }
    
    function _runCodeAsynchronouslyAndReportResults(theCode) {
        executionWasStopped = false;
        if (!webSocketOpen) {
            if (openingWebSocket) {
                pendingCodeToRun = theCode;
            } else {
                openingWebSocket = true;
                pendingCodeToRun = theCode;
                var _callOnOpen = function () {
                    webSocketOpen = true;
                    console.log("Openend websocket to live coding evaluator.");
                    console.log("evaluating code for the first time");
                    idOfCurrentCode = Date.now();
                    var msg = {
                        id: idOfCurrentCode,
                        type: "code",
                        code: pendingCodeToRun,
                        options: {
                            disposeAfterExit: false
                        }
                    };
                    lastCodeSentTimestamp = Date.now();
                    websocket.send(JSON.stringify(msg));
                };
                
                _openSocket(_callOnOpen, _receivedMessagesBatch);
            }
        } else {
            // websocket is open, easy case, just send the code to evaluate
            console.log("evaluating new code");
            idOfCurrentCode = Date.now();
            var msg = {
                id: idOfCurrentCode,
                type: "code",
                code: theCode,
                options: {
                    disposeAfterExit: false
                }
            };
            lastCodeSentTimestamp = Date.now();
            websocket.send(JSON.stringify(msg));
            
            // every message we received until now is now obsolete
            messagesBatchesToProcess = [];
            indexOfNextMessagesBatchToProcess = 0;
        }
    }
    
    exports.setAssignmentCallback = function _setAssignmentCallback(newAssignmentCallBack) {
        assignmentCallBack = newAssignmentCallBack;
    };
    exports.runCodeAsynchronouslyAndReportResults = _runCodeAsynchronouslyAndReportResults;
    
    exports.stopExecution = function () {
        executionWasStopped = true;
        messagesBatchesToProcess = [];
        if (websocket) {
            websocket.send(JSON.stringify({type: "stopRuntime", runtimeID: idOfCurrentCode}));
        }
    };
    
    function _processMessages() {
        var nextMessagesBatchToProcess, messagesBatch;
        if (indexOfNextMessagesBatchToProcess < messagesBatchesToProcess.length) {
            nextMessagesBatchToProcess = messagesBatchesToProcess[indexOfNextMessagesBatchToProcess];
            messagesBatch = JSON.parse(nextMessagesBatchToProcess);
            
            //console.log("parsed json");
            switch (messagesBatch.type) {
            case "log":
            case "error":
                console[messagesBatch.type]("[brackets-livecoding-server]", messagesBatch.message);
                break;
            case "message array":
                console.log("Time til response was received: " + (Date.now() - lastCodeSentTimestamp));
                //console.log(messagesBatch.messages);
                // process the messages    
                messagesBatch.messages.forEach(function (message) { _receivedMessage(message); });
                break;
            default:
                console.error("[brackets-livecoding-server]", "Unknown message type: " + nextMessagesBatchToProcess);
            }
            
            // iteration step
            indexOfNextMessagesBatchToProcess++;
            
            // possibly cleanup of saved messages
            if (indexOfNextMessagesBatchToProcess === messagesBatchesToProcess) {
                // processed all the messages, reset the array and the index
                messagesBatchesToProcess = [];
                indexOfNextMessagesBatchToProcess = 0;
            }
        }
        window.setTimeout(_processMessages, 0);
    }
    window.setTimeout(_processMessages, 0);
});