/*jslint vars: true, plusplus: true, devel: true, nomen: true, indent: 4, maxerr: 50 */
/*global define, $, document, window, brackets, CodeMirror  */

define(function (require, exports, module) {
	"use strict";

	var _obfuscationPrefix	= "kklkjdie"; 

	function EvalDataGatherer() {}

	EvalDataGatherer.prototype						= new EvalDataGatherer(); 
	EvalDataGatherer.prototype.constructor			= EvalDataGatherer; 
	
	EvalDataGatherer.prototype._codeMirror			= null;
	EvalDataGatherer.prototype._sourceCode			= null; 
	EvalDataGatherer.prototype._functionStart		= 0;
	EvalDataGatherer.prototype._functionEnd			= 0;
	EvalDataGatherer.prototype._evalSourceCode		= null; 
	EvalDataGatherer.prototype._document			= null;
	EvalDataGatherer.prototype._parameters			= {};
	EvalDataGatherer.prototype.$sandboxIframe		= null;
	EvalDataGatherer.prototype.result				= [];
	EvalDataGatherer.prototype.oldResult			= [];
	EvalDataGatherer.prototype.loops				= [];
	EvalDataGatherer.prototype.oldLoops				= [];
	
	EvalDataGatherer.prototype.lexer				= CodeMirror.getMode(CodeMirror.defaults, "javascript");

	EvalDataGatherer.prototype.setDocumentAndRange = function (newDocument, start, end) {
		this._document		= newDocument; 
		this._functionStart = start; 
		this._functionEnd	= end;

		this._codeMirror = this._document._masterEditor._codeMirror;
		this._sourceCode = this._codeMirror.getRange({ line: this._functionStart.line, ch: this._functionStart.ch + 1 },
                                                     { line: this._functionEnd.line,   ch: this._functionEnd.ch - 1   });

		this._variablesInFunction();
	};

	EvalDataGatherer.prototype.setParameters = function (newParameters) {
		this._parameters = newParameters;
	};
    
    EvalDataGatherer.prototype.getParameters = function() {
        return this._parameters;
    }

	EvalDataGatherer.prototype._variablesInFunction = function () {
		var esprima = this._document.structure; 
		var declarationElements = esprima.elementsInRangeByType(this._functionStart, this._functionEnd, "VariableDeclaration");

		var result = [];
		for (var i = 0; i < declarationElements.length; i++) {
			var element = declarationElements[i];

			for (var j = 0; j < element.declarations.length; j++) {
				var decl = element.declarations[j];
				if (decl.id.name !== undefined) {
					result.push(decl.id.name);
				}
			}
		}

		var functionElement = esprima.functionForPosition(this._functionStart); 
		if (functionElement !== undefined) {
			for (i = 0; i < functionElement.params.length; i++) {
				var param = functionElement.params[i];
				result.push(param.name);
			}
		}

		return result;
	};

	//returns a var statement setting the parameter values
	EvalDataGatherer.prototype._sourceForInitialization = function () {
		var result = "document.write(\"<script src=\\\"thirdparty/jquery-1.7.min.js\\\"></script>\");\n";
		result += stringRepresentation.toString();

		result += "\nvar "; 
		for (var parameter in this._parameters) {
			result += parameter + " = " + this._parameters[parameter] + ", ";
		}

		result += "loopCounter = [], ";
		result += obfVarName("localValues") + " = [];";

		return result;
	};

	//returns the instrumentation source for getting the variables in lineNr line
	EvalDataGatherer.prototype._sourceForStoringVariablesInLine = function (variables, line, nrOfLoops) {
		var localValuesStore = obfVarName("localValues") + "[" + line + "]";
		var result = "";
		var i;

		if (nrOfLoops > 0) {
			for (i = 0; i < nrOfLoops; i++) {
				result += "if (loopCounter[" + (nrOfLoops - 1) + "] == 0) { " + localValuesStore + " = $.isArray(" + localValuesStore + ") ? " + localValuesStore + " : []; }\n";
				localValuesStore += "[loopCounter[" + i + "]]";
			}
		}

		result += localValuesStore + " = {"; 

		for (i = 0; i < variables.length; i++) {
			result += variables[i] + ": stringRepresentation(" + variables[i] + ")"; 
			if (i != variables.length - 1) {
				result += ", ";
			}
		}

		result += "};";

		return result;
	};

	//uses the lexer to insert instrumentation to the source
	EvalDataGatherer.prototype._instrumentSource  = function () {
		var result = this._sourceForInitialization(); 

		var lines						= CodeMirror.splitLines(this._sourceCode), 
			state						= CodeMirror.startState(this.lexer),
			loopEndings					= [], 
			loopEndInstrumentation		= [],
			lastInLineWasSemicolon		= false,
			lastInPrevLineWasSemicolon	= true, 
			variablesInLine				= [];

		this.oldLoops = this.loops;
		this.loops = [];

		for (var i = 0; i < lines.length; i++) {
			var stream			= new CodeMirror.StringStream(lines[i]), 
				afterLineCode	= null,
				loopFound		= false,
                lineHasReturnStatement = false,
				newForLoop;

			newForLoop = undefined;

			//skip blank lines
			if (lines[i] == /\s*/.exec(lines[i])) {
				result = addLineToString(result, lines[i]);
				continue; 
			}

			while (!stream.eol()) {
				var tokenDescription	= this.lexer.token(stream, state),
					token				= stream.current();

				// store the variables used in this line				
				if (tokenDescription && tokenDescription.indexOf("keyword") != -1) {
					// check if we are in a loop
					if ($.inArray(token, ["for", "while", "do"]) > -1) {
						// check if opening bracket for the loop is in this line or next
						// TODO: more robust implementation needed
						if (lines[i].indexOf("{") != -1) {
							loopEndings.push(CodeMirror.braceRangeFinder(this._codeMirror, i + this._functionStart.line) - this._functionStart.line); 
						} else {
							loopEndings.push(CodeMirror.braceRangeFinder(this._codeMirror, i + 1 + this._functionStart.line) - this._functionStart.line);
						}

						this.loops.push({ start: i, end: loopEndings.last() });

						result += "if (loopCounter[" + (loopEndings.length - 1) + "] == undefined) { loopCounter[" + (loopEndings.length - 1) + "] = 0; }";
						loopFound = true;

						if (token == "for") {
							newForLoop = lines[i];
							var forLoopDefRegexp = /for\s*\(([^;]*);/;
							var defPart = forLoopDefRegexp.exec(newForLoop);
							if (defPart.length == 2) {
								defPart = defPart[1];
							}
							result = addLineToString(result, defPart + ";");
							newForLoop = newForLoop.replace(forLoopDefRegexp, "for (;");
						}
					}
				}
                
                if ((tokenDescription === "keyword") && (token === "return")) {
                    lineHasReturnStatement = true;
                }

				if (token != /\s+/.exec(token)) {
					lastInLineWasSemicolon = /[;{}]\s*/.test(token);
				}

				stream.start = stream.pos;
			}

			if (lastInPrevLineWasSemicolon) {
				variablesInLine = this._variablesInFunction();

				if (loopFound) {
					afterLineCode = addLineToString(afterLineCode, this._sourceForStoringVariablesInLine(variablesInLine, i, loopEndings.length)); 
					var loopInstrumentation = "loopCounter[" + (loopEndings.length - 1) + "]++;";
					loopEndInstrumentation.push(loopInstrumentation); 
				} else {
					result = addLineToString(result, this._sourceForStoringVariablesInLine(variablesInLine, i, loopEndings.length));
				}
			}
			
			if (loopEndings.last() == i) {
				loopEndings.pop();
				result = addLineToString(result, loopEndInstrumentation.pop()); 
				afterLineCode = "loopCounter[" + loopEndings.length + "] = undefined;";
			}

			if (newForLoop !== undefined) {
				result = addLineToString(result, this._sourceForStoringVariablesInLine(variablesInLine, i, loopEndings.length));
				result = addLineToString(result, newForLoop);
			} else {
                if (lineHasReturnStatement) {
                    result = addLineToString(result, lines[i].replace(/return;?/, "/*return*/"))
                } else {
				    result = addLineToString(result, lines[i]);
                }
			}
			
			if (afterLineCode !== null) {
				if (newForLoop) {
					result = addLineToString(result, "if (loopCounter[" + (loopEndings.length - 1) + "] > 0) {");
				}
				result = addLineToString(result, afterLineCode); 
				if (newForLoop) {
					result = addLineToString(result, "}");
				}				
			}

			lastInPrevLineWasSemicolon = lastInLineWasSemicolon;
		}

		this._evalSourceCode = result;
		console.log(result);
	};

	EvalDataGatherer.prototype._evaluate = function () {
		// reset the sandbox 
		if (this.$sandboxIframe) {
			$(this.$sandboxIframe).remove(); 
			this.$sandboxIframe = null; 
		}
 
		this.$sandboxIframe = document.createElement('iframe');
		$(this.$sandboxIframe).css('display', 'none');
		$('body').append(this.$sandboxIframe); 
 
		var evalContext = this.$sandboxIframe.contentWindow; 

		evalContext.eval(this._evalSourceCode);

		this.result = evalContext[obfVarName("localValues")];
	};

	EvalDataGatherer.prototype.update = function () {
		if (! (this._codeMirror && this._sourceCode)) {
			return;
		}

		this.oldResult = this.result;
		this.result = []; 

		this._instrumentSource(); 
		this._evaluate();
	};

	// Utilities 

	//used in the instrumented source

	//to string method with special handling for arrays
	function stringRepresentation(variable) {
		if (variable === undefined) {
			return "";
		} else if ($.isArray(variable)) {
			return "[" + variable.toString() + "]"; 
		} else {
			return variable.toString();
		}
	}

	// used here

	//function to append another string as new line
	function addLineToString(string, line) {
		return (string !== null) ? string + "\n" + line : line;
	}

	// find a variable name for instrumentation vars that does not occur in the real source. 
	// currently using a trivial implementation with a fixed prefix
	function obfVarName(varName) {
		return (_obfuscationPrefix + "_" + varName);
	}

	// eliminate duplicates in an array
	function eliminateDuplicates(arr) {
		var i,
			len = arr.length,
			out = [],
			obj = {};

		for (i = 0; i < len; i++) {
			obj[arr[i]] = 0;
		}
		for (i in obj) {
			out.push(i);
		}
		return out;
	}

	// add a method to array for quick access to the last element
	if (!Array.prototype.last) {
		Array.prototype.last = function () {
			return (this.length > 0) ? this[this.length - 1] : undefined;
		};
	}

	module.exports = EvalDataGatherer;
});