/*
*** This example shows how to send a Vector Path to a lasercutter, using PShape shapes and LibLasercut
 *** For more information about LibLasercut, visit https://github.com/t-oster/LibLaserCut
 */
import com.t_oster.liblasercut.dithering.*;
import com.t_oster.liblasercut.vectoroptimizers.*;
import com.t_oster.liblasercut.utils.*;
import com.t_oster.liblasercut.drivers.*;
import com.t_oster.liblasercut.laserscript.*;
import com.t_oster.liblasercut.platform.*;
import com.t_oster.liblasercut.examples.*;
import com.t_oster.liblasercut.*;


String IP_ADDRESS = "137.226.56.228";//SET THE IP ADDRESS !!!

EpilogZing lasercutter = null;
PowerSpeedFocusFrequencyProperty psffProperty = null;
RasterPart rp = null;//raster part of the job. not used in this examples
VectorPart vp = null;//vector part of the job.
int dpi = 500;

PShape leftShape;//rectangle
PShape rightShape;//triangle

void setup()
{
  size(1024, 768, P2D);
  smooth();

  //set up your laser cutter
  lasercutter = new EpilogZing(IP_ADDRESS);

  //SET THE PROPERTIES FOR YOUR MATERIAL. EXAMPLE: cardboard, 3mm: 70 power, 100 speed, 0 focus, 500Hz.
  psffProperty = new PowerSpeedFocusFrequencyProperty();
  psffProperty.setProperty("power", 70);
  psffProperty.setProperty("speed", 100);
  psffProperty.setProperty("focus", 0.0f);
  psffProperty.setProperty("frequency", 500);

  createShapes();
  createParts();
  sendLaserjob();
}

//show the shapes on the screen
void draw()
{
  shape(leftShape, 0, 0);
  shape(rightShape, 0, 0);
}

//create the shapes... instead, you could also read svg files, etc.
void createShapes()
{
  leftShape = createShape();
  rightShape = createShape();

  leftShape.beginShape();
  leftShape.fill(255);
  leftShape.vertex(0, 0);
  leftShape.vertex(100, 0);
  leftShape.vertex(100, 100);
  leftShape.vertex(0, 100);
  leftShape.vertex(0, 0);
  leftShape.endShape();

  rightShape.beginShape();
  rightShape.fill(255);  
  rightShape.vertex(150, 0);
  rightShape.vertex(250, 0);
  rightShape.vertex(200, 100);
  rightShape.vertex(150, 0);
  rightShape.endShape();
}


void createParts()
{              
  vp = new VectorPart( psffProperty, dpi);

  //the same two shapes that we preview in the draw() method:
  addShapeToVectorPart(vp, leftShape);
  addShapeToVectorPart(vp, rightShape);
}


//this method adds all vertices of the PShape s to a VectorPart vPart.
void addShapeToVectorPart(VectorPart vPart, PShape s)
{
  for (int i = 0; i < s.getVertexCount(); i++) 
  {
    PVector v = s.getVertex(i);
    if ( i == 0)
    {
      vPart.moveto((int) v.x, (int) v.y);
    }
    else
    {
      vPart.lineto((int) v.x, (int) v.y);
    }
  }
}

//send the job to the laser cutter
void sendLaserjob()
{
  LaserJob job = new LaserJob("Processing", "123", "username");//title, name, user
  if (rp != null)
  {
    job.addPart(rp);
  }
  if (vp != null)
  {
    job.addPart(vp);
  }
  try
  {
    lasercutter.sendJob(job);
  }
  catch(IllegalJobException ije)
  {
    println(ije.toString());
  }
  catch(Exception e)
  {
    println(e.toString());
  }
}

