/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.vectoroptimizers;

import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.VectorCommand;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.platform.Point;
import com.t_oster.liblasercut.platform.Rectangle;
import com.t_oster.liblasercut.vectoroptimizers.FileVectorOptimizer;
import com.t_oster.liblasercut.vectoroptimizers.InnerFirstVectorOptimizer;
import com.t_oster.liblasercut.vectoroptimizers.NearestVectorOptimizer;
import com.t_oster.liblasercut.vectoroptimizers.SmallestFirstVectorOptimizer;
import java.util.LinkedList;
import java.util.List;

public abstract class VectorOptimizer {
    public static VectorOptimizer create(OrderStrategy s) {
        switch (s) {
            case FILE: {
                return new FileVectorOptimizer();
            }
            case NEAREST: {
                return new NearestVectorOptimizer();
            }
            case INNER_FIRST: {
                return new InnerFirstVectorOptimizer();
            }
            case SMALLEST_FIRST: {
                return new SmallestFirstVectorOptimizer();
            }
        }
        throw new IllegalArgumentException("Unknown Order Strategy: " + (Object)((Object)s));
    }

    protected List<Element> divide(VectorPart vp) {
        LinkedList<Element> result = new LinkedList<Element>();
        Element cur = null;
        Point lastMove = null;
        LaserProperty lastProp = null;
        boolean stop = false;
        block5: for (VectorCommand cmd : vp.getCommandList()) {
            switch (cmd.getType()) {
                case MOVETO: {
                    lastMove = new Point(cmd.getX(), cmd.getY());
                    stop = true;
                    continue block5;
                }
                case LINETO: {
                    if (stop) {
                        stop = false;
                        if (cur != null) {
                            result.add(cur);
                        }
                        cur = new Element();
                        cur.start = lastMove;
                        cur.prop = lastProp;
                    }
                    cur.moves.add(new Point(cmd.getX(), cmd.getY()));
                    continue block5;
                }
                case SETPROPERTY: {
                    lastProp = cmd.getProperty();
                    stop = true;
                }
            }
        }
        if (cur != null) {
            result.add(cur);
        }
        return result;
    }

    protected double dist(Point a, Point b) {
        return Math.sqrt((a.y - b.y) * (a.y - b.y) + (a.x - b.x) * (a.x - b.x));
    }

    protected abstract List<Element> sort(List<Element> var1);

    public VectorPart optimize(VectorPart vp) {
        List<Element> opt = this.sort(this.divide(vp));
        LaserProperty cp = opt.isEmpty() ? vp.getCurrentCuttingProperty() : opt.get((int)0).prop;
        VectorPart result = new VectorPart(cp, vp.getDPI());
        for (Element e : opt) {
            if (!e.prop.equals(cp)) {
                result.setProperty(e.prop);
                cp = e.prop;
            }
            result.moveto(e.start.x, e.start.y);
            for (Point p : e.moves) {
                result.lineto(p.x, p.y);
            }
        }
        return result;
    }

    protected class Element {
        LaserProperty prop;
        Point start;
        List<Point> moves = new LinkedList<Point>();

        protected Element() {
        }

        void invert() {
            if (!this.moves.isEmpty()) {
                this.moves.add(0, this.start);
                this.start = this.moves.remove(this.moves.size() - 1);
                LinkedList<Point> inv = new LinkedList<Point>();
                while (!this.moves.isEmpty()) {
                    inv.add(this.moves.remove(this.moves.size() - 1));
                }
                this.moves = inv;
            }
        }

        Point getEnd() {
            return this.moves.isEmpty() ? this.start : this.moves.get(this.moves.size() - 1);
        }

        Rectangle boundingBox() {
            if (this.start == null) {
                return null;
            }
            Rectangle bb = new Rectangle(this.start.x, this.start.y, this.start.x, this.start.y);
            for (Point p : this.moves) {
                bb.add(p);
            }
            return bb;
        }

        boolean isClosedPath() {
            if (this.start == null || this.moves.isEmpty()) {
                return false;
            }
            return this.getEnd().equals(this.start);
        }
    }

    public static enum OrderStrategy {
        FILE,
        NEAREST,
        INNER_FIRST,
        SMALLEST_FIRST;

    }
}

