/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.vectoroptimizers;

import com.t_oster.liblasercut.vectoroptimizers.VectorOptimizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class SmallestFirstVectorOptimizer
extends VectorOptimizer {
    @Override
    protected List<VectorOptimizer.Element> sort(List<VectorOptimizer.Element> e) {
        LinkedList<VectorOptimizer.Element> result = new LinkedList<VectorOptimizer.Element>();
        if (e.isEmpty()) {
            return result;
        }
        result.addAll(e);
        Collections.sort(result, new SmallerComparator());
        return result;
    }

    class SmallerComparator
    implements Comparator<VectorOptimizer.Element> {
        SmallerComparator() {
        }

        @Override
        public int compare(VectorOptimizer.Element a, VectorOptimizer.Element b) {
            Integer av = new Integer(this.getValue(a));
            Integer bv = new Integer(this.getValue(b));
            return av.compareTo(bv);
        }

        int getValue(VectorOptimizer.Element e) {
            return (e.boundingBox().getXMax() - e.boundingBox().getXMin()) * (e.boundingBox().getYMax() - e.boundingBox().getYMin());
        }
    }
}

