/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.vectoroptimizers;

import com.t_oster.liblasercut.platform.Point;
import com.t_oster.liblasercut.vectoroptimizers.VectorOptimizer;
import java.util.LinkedList;
import java.util.List;

public class NearestVectorOptimizer
extends VectorOptimizer {
    @Override
    protected List<VectorOptimizer.Element> sort(List<VectorOptimizer.Element> e) {
        LinkedList<VectorOptimizer.Element> result = new LinkedList<VectorOptimizer.Element>();
        if (e.isEmpty()) {
            return result;
        }
        result.add(e.remove(0));
        while (!e.isEmpty()) {
            Point end = ((VectorOptimizer.Element)result.get(result.size() - 1)).getEnd();
            int next = 0;
            boolean invert = false;
            double dst = -1.0;
            for (int i = 1; i < e.size(); ++i) {
                double nd = this.dist(e.get((int)i).start, end);
                if (nd < dst || dst == -1.0) {
                    next = i;
                    dst = nd;
                    invert = false;
                }
                if (e.get((int)i).start.equals(e.get(i).getEnd()) || !((nd = this.dist(e.get(i).getEnd(), end)) < dst) && dst != -1.0) continue;
                next = i;
                dst = nd;
                invert = true;
            }
            if (invert) {
                VectorOptimizer.Element m = e.remove(next);
                m.invert();
                result.add(m);
                continue;
            }
            result.add(e.remove(next));
        }
        return result;
    }
}

