/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.vectoroptimizers;

import com.t_oster.liblasercut.vectoroptimizers.VectorOptimizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class InnerFirstVectorOptimizer
extends VectorOptimizer {
    @Override
    protected List<VectorOptimizer.Element> sort(List<VectorOptimizer.Element> e) {
        LinkedList<VectorOptimizer.Element> result = new LinkedList<VectorOptimizer.Element>();
        if (e.isEmpty()) {
            return result;
        }
        result.addAll(e);
        Collections.sort(result, new XMinComparator());
        Collections.sort(result, new YMinComparator());
        Collections.sort(result, new XMaxComparator());
        Collections.sort(result, new YMaxComparator());
        return result;
    }

    private class YMaxComparator
    extends ElementValueComparator {
        private YMaxComparator() {
        }

        @Override
        int getValue(VectorOptimizer.Element e) {
            return e.boundingBox().getYMax();
        }
    }

    private class XMaxComparator
    extends ElementValueComparator {
        private XMaxComparator() {
        }

        @Override
        int getValue(VectorOptimizer.Element e) {
            return e.boundingBox().getXMax();
        }
    }

    private class YMinComparator
    extends ElementValueComparator {
        private YMinComparator() {
        }

        @Override
        int getValue(VectorOptimizer.Element e) {
            return -e.boundingBox().getYMin();
        }
    }

    private class XMinComparator
    extends ElementValueComparator {
        private XMinComparator() {
        }

        @Override
        int getValue(VectorOptimizer.Element e) {
            return -e.boundingBox().getXMin();
        }
    }

    private abstract class ElementValueComparator
    implements Comparator<VectorOptimizer.Element> {
        private ElementValueComparator() {
        }

        abstract int getValue(VectorOptimizer.Element var1);

        @Override
        public int compare(VectorOptimizer.Element a, VectorOptimizer.Element b) {
            Integer av = new Integer(this.getValue(a));
            Integer bv = new Integer(this.getValue(b));
            return av.compareTo(bv);
        }
    }
}

