/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.laserscript;

import org.mozilla.javascript.ClassShutter;

public class ScriptingSecurity
implements ClassShutter {
    private static ScriptingSecurity instance;
    private static String[] allowedClasses;
    private boolean locked = false;

    public static ScriptingSecurity getInstance() {
        if (instance == null) {
            instance = new ScriptingSecurity();
        }
        return instance;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    private ScriptingSecurity() {
    }

    public boolean visibleToScripts(String className) {
        if (this.locked) {
            for (String prefix : allowedClasses) {
                if (!className.startsWith(prefix)) continue;
                return true;
            }
            System.err.println("ScriptingSecurity: LaserScript tried to access forbidden class: " + className);
            return false;
        }
        return true;
    }

    static {
        allowedClasses = new String[]{"adapter", "com.t_oster", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.String", "java.lang.Boolean"};
    }
}

