/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.drivers;

import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserCutter;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.PowerSpeedFocusFrequencyProperty;
import com.t_oster.liblasercut.PowerSpeedFocusProperty;
import com.t_oster.liblasercut.ProgressListener;
import com.t_oster.liblasercut.Raster3dPart;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorCommand;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.platform.Point;
import com.t_oster.liblasercut.platform.Util;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import purejavacomm.CommPort;
import purejavacomm.CommPortIdentifier;
import purejavacomm.SerialPort;

public class Lasersaur
extends LaserCutter {
    private static final String SETTING_COMPORT = "COM-Port/Device";
    private static final String SETTING_BEDWIDTH = "Laserbed width";
    private static final String SETTING_BEDHEIGHT = "Laserbed height";
    private static final String SETTING_FLIPX = "X axis goes right to left (yes/no)";
    private static final String SETTING_RASTER_WHITESPACE = "Additional space per Raster line (mm)";
    private static final String SETTING_SEEK_RATE = "Max. Seek Rate (mm/min)";
    private static final String SETTING_LASER_RATE = "Max. Laser Rate (mm/min)";
    private double addSpacePerRasterLine = 0.5;
    private double seekRate = 2000.0;
    private double laserRate = 2000.0;
    protected boolean flipXaxis = false;
    protected String comPort = "/dev/ttyUSB0";
    private int currentPower = -1;
    private int currentSpeed = -1;
    private List<Double> resolutions;
    protected double bedWidth = 250.0;
    protected double bedHeight = 280.0;
    private static String[] settingAttributes = new String[]{"Laserbed width", "Laserbed height", "X axis goes right to left (yes/no)", "COM-Port/Device", "Max. Laser Rate (mm/min)", "Max. Seek Rate (mm/min)", "Additional space per Raster line (mm)"};

    @Override
    public String getModelName() {
        return "Lasersaur";
    }

    public double getAddSpacePerRasterLine() {
        return this.addSpacePerRasterLine;
    }

    public void setAddSpacePerRasterLine(double addSpacePerRasterLine) {
        this.addSpacePerRasterLine = addSpacePerRasterLine;
    }

    public double getSeekRate() {
        return this.seekRate;
    }

    public void setSeekRate(double seekRate) {
        this.seekRate = seekRate;
    }

    public double getLaserRate() {
        return this.laserRate;
    }

    public void setLaserRate(double laserRate) {
        this.laserRate = laserRate;
    }

    public boolean isFlipXaxis() {
        return this.flipXaxis;
    }

    public void setFlipXaxis(boolean flipXaxis) {
        this.flipXaxis = flipXaxis;
    }

    public String getComPort() {
        return this.comPort;
    }

    public void setComPort(String comPort) {
        this.comPort = comPort;
    }

    private byte[] generateVectorGCode(VectorPart vp, double resolution) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        block5: for (VectorCommand cmd : vp.getCommandList()) {
            switch (cmd.getType()) {
                case MOVETO: {
                    int x = cmd.getX();
                    int y = cmd.getY();
                    this.move(out, x, y, resolution);
                    continue block5;
                }
                case LINETO: {
                    int x = cmd.getX();
                    int y = cmd.getY();
                    this.line(out, x, y, resolution);
                    continue block5;
                }
                case SETPROPERTY: {
                    PowerSpeedFocusFrequencyProperty p = (PowerSpeedFocusFrequencyProperty)cmd.getProperty();
                    this.setPower(out, p.getPower());
                    this.setSpeed(out, p.getSpeed());
                }
            }
        }
        return result.toByteArray();
    }

    private void setSpeed(PrintStream out, int speedInPercent) {
        if (speedInPercent != this.currentSpeed) {
            out.printf(Locale.US, "G1 F%i\n", (int)((double)speedInPercent * this.getLaserRate() / 100.0));
            this.currentSpeed = speedInPercent;
        }
    }

    private void setPower(PrintStream out, int powerInPercent) {
        if (powerInPercent != this.currentPower) {
            out.printf(Locale.US, "S%i\n", (int)(255.0 * (double)powerInPercent / 100.0));
            this.currentPower = powerInPercent;
        }
    }

    private void move(PrintStream out, int x, int y, double resolution) {
        out.printf(Locale.US, "G0 X%f Y%f\n", Util.px2mm(this.isFlipXaxis() ? Util.mm2px(this.bedWidth, resolution) - (double)x : (double)x, resolution), Util.px2mm(y, resolution));
    }

    private void line(PrintStream out, int x, int y, double resolution) {
        out.printf(Locale.US, "G1 X%f Y%f\n", Util.px2mm(this.isFlipXaxis() ? Util.mm2px(this.bedWidth, resolution) - (double)x : (double)x, resolution), Util.px2mm(y, resolution));
    }

    private byte[] generatePseudoRaster3dGCode(Raster3dPart rp, double resolution) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        boolean dirRight = true;
        Point rasterStart = rp.getRasterStart();
        PowerSpeedFocusProperty prop = (PowerSpeedFocusProperty)rp.getLaserProperty();
        this.setSpeed(out, prop.getSpeed());
        for (int line = 0; line < rp.getRasterHeight(); ++line) {
            Point lineStart = rasterStart.clone();
            lineStart.y += line;
            List<Byte> bytes = rp.getRasterLine(line);
            while (bytes.size() > 0 && bytes.get(0) == 0) {
                bytes.remove(0);
                ++lineStart.x;
            }
            while (bytes.size() > 0 && bytes.get(bytes.size() - 1) == 0) {
                bytes.remove(bytes.size() - 1);
            }
            if (bytes.size() > 0) {
                int pix;
                byte old;
                if (dirRight) {
                    this.move(out, lineStart.x, lineStart.y, resolution);
                    old = bytes.get(0);
                    for (pix = 0; pix < bytes.size(); ++pix) {
                        if (bytes.get(pix) == old) continue;
                        if (old == 0) {
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        } else {
                            this.setPower(out, prop.getPower() * (0xFF & old) / 255);
                            this.line(out, lineStart.x + pix - 1, lineStart.y, resolution);
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        }
                        old = bytes.get(pix);
                    }
                    this.setPower(out, prop.getPower() * (0xFF & bytes.get(bytes.size() - 1)) / 255);
                    this.line(out, lineStart.x + bytes.size() - 1, lineStart.y, resolution);
                } else {
                    this.move(out, lineStart.x + bytes.size() - 1, lineStart.y, resolution);
                    old = bytes.get(bytes.size() - 1);
                    for (pix = bytes.size() - 1; pix >= 0; --pix) {
                        if (bytes.get(pix) == old && pix != 0) continue;
                        if (old == 0) {
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        } else {
                            this.setPower(out, prop.getPower() * (0xFF & old) / 255);
                            this.line(out, lineStart.x + pix + 1, lineStart.y, resolution);
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        }
                        old = bytes.get(pix);
                    }
                    this.setPower(out, prop.getPower() * (0xFF & bytes.get(0)) / 255);
                    this.line(out, lineStart.x, lineStart.y, resolution);
                }
            }
            dirRight = !dirRight;
        }
        return result.toByteArray();
    }

    private byte[] generatePseudoRasterGCode(RasterPart rp, double resolution) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        boolean dirRight = true;
        Point rasterStart = rp.getRasterStart();
        PowerSpeedFocusProperty prop = (PowerSpeedFocusProperty)rp.getLaserProperty();
        this.setSpeed(out, prop.getSpeed());
        this.setPower(out, prop.getPower());
        for (int line = 0; line < rp.getRasterHeight(); ++line) {
            Point lineStart = rasterStart.clone();
            lineStart.y += line;
            LinkedList<Byte> bytes = new LinkedList<Byte>();
            boolean lookForStart = true;
            for (int x = 0; x < rp.getRasterWidth(); ++x) {
                if (lookForStart) {
                    if (rp.isBlack(x, line)) {
                        lookForStart = false;
                        bytes.add((byte)-1);
                        continue;
                    }
                    ++lineStart.x;
                    continue;
                }
                bytes.add(rp.isBlack(x, line) ? (byte)-1 : 0);
            }
            while (bytes.size() > 0 && (Byte)bytes.get(bytes.size() - 1) == 0) {
                bytes.remove(bytes.size() - 1);
            }
            if (bytes.size() > 0) {
                int pix;
                byte old;
                if (dirRight) {
                    this.move(out, Math.max(0, (int)((double)lineStart.x - Util.mm2px(this.addSpacePerRasterLine, resolution))), lineStart.y, resolution);
                    this.move(out, lineStart.x, lineStart.y, resolution);
                    old = (Byte)bytes.get(0);
                    for (pix = 0; pix < bytes.size(); ++pix) {
                        if ((Byte)bytes.get(pix) == old) continue;
                        if (old == 0) {
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        } else {
                            this.setPower(out, prop.getPower() * (0xFF & old) / 255);
                            this.line(out, lineStart.x + pix - 1, lineStart.y, resolution);
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        }
                        old = (Byte)bytes.get(pix);
                    }
                    this.setPower(out, prop.getPower() * (0xFF & (Byte)bytes.get(bytes.size() - 1)) / 255);
                    this.line(out, lineStart.x + bytes.size() - 1, lineStart.y, resolution);
                    this.move(out, Math.min((int)Util.mm2px(this.bedWidth, resolution), (int)((double)(lineStart.x + bytes.size() - 1) + Util.mm2px(this.addSpacePerRasterLine, resolution))), lineStart.y, resolution);
                } else {
                    this.move(out, Math.min((int)Util.mm2px(this.bedWidth, resolution), (int)((double)(lineStart.x + bytes.size() - 1) + Util.mm2px(this.addSpacePerRasterLine, resolution))), lineStart.y, resolution);
                    this.move(out, lineStart.x + bytes.size() - 1, lineStart.y, resolution);
                    old = (Byte)bytes.get(bytes.size() - 1);
                    for (pix = bytes.size() - 1; pix >= 0; --pix) {
                        if ((Byte)bytes.get(pix) == old && pix != 0) continue;
                        if (old == 0) {
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        } else {
                            this.setPower(out, prop.getPower() * (0xFF & old) / 255);
                            this.line(out, lineStart.x + pix + 1, lineStart.y, resolution);
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        }
                        old = (Byte)bytes.get(pix);
                    }
                    this.setPower(out, prop.getPower() * (0xFF & (Byte)bytes.get(0)) / 255);
                    this.line(out, lineStart.x, lineStart.y, resolution);
                    this.move(out, Math.max(0, (int)((double)lineStart.x - Util.mm2px(this.addSpacePerRasterLine, resolution))), lineStart.y, resolution);
                }
            }
            dirRight = !dirRight;
        }
        return result.toByteArray();
    }

    private byte[] generateInitializationCode() throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.print("G54\n");
        out.print("G21\n");
        out.print("G90\n");
        out.print("G0 X0 Y0\n");
        return result.toByteArray();
    }

    private byte[] generateShutdownCode() throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.print("G0 X0 Y0\n");
        return result.toByteArray();
    }

    @Override
    public void sendJob(LaserJob job, ProgressListener pl, List<String> warnings) throws IllegalJobException, Exception {
        pl.progressChanged(this, 0);
        this.currentPower = -1;
        this.currentSpeed = -1;
        pl.taskChanged(this, "checking job");
        this.checkJob(job);
        job.applyStartPoint();
        pl.taskChanged(this, "connecting");
        CommPortIdentifier cpi = null;
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (!(o instanceof CommPortIdentifier) || !((CommPortIdentifier)o).getName().equals(this.getComPort())) continue;
            cpi = (CommPortIdentifier)o;
            break;
        }
        if (cpi == null) {
            throw new Exception("Error: No such COM-Port '" + this.getComPort() + "'");
        }
        CommPort tmp = cpi.open("VisiCut", 10000);
        if (tmp == null) {
            throw new Exception("Error: Could not Open COM-Port '" + this.getComPort() + "'");
        }
        if (!(tmp instanceof SerialPort)) {
            throw new Exception("Port '" + this.getComPort() + "' is not a serial port.");
        }
        SerialPort port = (SerialPort)tmp;
        port.setFlowControlMode(0);
        port.setSerialPortParams(9600, 8, 1, 0);
        BufferedOutputStream out = new BufferedOutputStream(port.getOutputStream());
        pl.taskChanged(this, "sending");
        out.write(this.generateInitializationCode());
        pl.progressChanged(this, 20);
        int i = 0;
        int max = job.getParts().size();
        for (JobPart p : job.getParts()) {
            if (p instanceof Raster3dPart) {
                out.write(this.generatePseudoRaster3dGCode((Raster3dPart)p, p.getDPI()));
            } else if (p instanceof RasterPart) {
                out.write(this.generatePseudoRasterGCode((RasterPart)p, p.getDPI()));
            } else if (p instanceof VectorPart) {
                out.write(this.generateVectorGCode((VectorPart)p, p.getDPI()));
            }
            pl.progressChanged(this, 20 + (int)((double)(++i) * 60.0 / (double)max));
        }
        out.write(this.generateShutdownCode());
        out.close();
        port.close();
        pl.taskChanged(this, "sent.");
        pl.progressChanged(this, 100);
    }

    @Override
    public List<Double> getResolutions() {
        if (this.resolutions == null) {
            this.resolutions = Arrays.asList(500.0);
        }
        return this.resolutions;
    }

    @Override
    public double getBedWidth() {
        return this.bedWidth;
    }

    public void setBedWidth(double bedWidth) {
        this.bedWidth = bedWidth;
    }

    @Override
    public double getBedHeight() {
        return this.bedHeight;
    }

    public void setBedHeight(double bedHeight) {
        this.bedHeight = bedHeight;
    }

    @Override
    public String[] getPropertyKeys() {
        return settingAttributes;
    }

    @Override
    public Object getProperty(String attribute) {
        if (SETTING_RASTER_WHITESPACE.equals(attribute)) {
            return this.getAddSpacePerRasterLine();
        }
        if (SETTING_COMPORT.equals(attribute)) {
            return this.getComPort();
        }
        if (SETTING_FLIPX.equals(attribute)) {
            return this.isFlipXaxis();
        }
        if (SETTING_LASER_RATE.equals(attribute)) {
            return this.getLaserRate();
        }
        if (SETTING_SEEK_RATE.equals(attribute)) {
            return this.getSeekRate();
        }
        if (SETTING_BEDWIDTH.equals(attribute)) {
            return this.getBedWidth();
        }
        if (SETTING_BEDHEIGHT.equals(attribute)) {
            return this.getBedHeight();
        }
        return null;
    }

    @Override
    public void setProperty(String attribute, Object value) {
        if (SETTING_RASTER_WHITESPACE.equals(attribute)) {
            this.setAddSpacePerRasterLine((Double)value);
        } else if (SETTING_COMPORT.equals(attribute)) {
            this.setComPort((String)value);
        } else if (SETTING_LASER_RATE.equals(attribute)) {
            this.setLaserRate((Double)value);
        } else if (SETTING_SEEK_RATE.equals(attribute)) {
            this.setSeekRate((Double)value);
        } else if (SETTING_FLIPX.equals(attribute)) {
            this.setFlipXaxis((Boolean)value);
        } else if (SETTING_BEDWIDTH.equals(attribute)) {
            this.setBedWidth((Double)value);
        } else if (SETTING_BEDHEIGHT.equals(attribute)) {
            this.setBedHeight((Double)value);
        }
    }

    @Override
    public LaserCutter clone() {
        Lasersaur clone = new Lasersaur();
        clone.comPort = this.comPort;
        clone.laserRate = this.laserRate;
        clone.seekRate = this.seekRate;
        clone.bedHeight = this.bedHeight;
        clone.bedWidth = this.bedWidth;
        clone.flipXaxis = this.flipXaxis;
        clone.addSpacePerRasterLine = this.addSpacePerRasterLine;
        return clone;
    }
}

