/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.drivers;

import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserCutter;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.LaserProperty;
import com.t_oster.liblasercut.ProgressListener;
import com.t_oster.liblasercut.Raster3dPart;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorCommand;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.drivers.LaosCutterProperty;
import com.t_oster.liblasercut.drivers.LaosEngraveProperty;
import com.t_oster.liblasercut.platform.Point;
import com.t_oster.liblasercut.platform.Util;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.net.tftp.TFTPClient;

public class LaosCutter
extends LaserCutter {
    private static final String SETTING_HOSTNAME = "Hostname / IP";
    private static final String SETTING_PORT = "Port";
    private static final String SETTING_BEDWIDTH = "Laserbed width";
    private static final String SETTING_BEDHEIGHT = "Laserbed height";
    private static final String SETTING_FLIPX = "X axis goes right to left (yes/no)";
    private static final String SETTING_FLIPY = "Y axis goes bottom to top (yes/no)";
    private static final String SETTING_MMPERSTEP = "mm per Step (for SimpleMode)";
    private static final String SETTING_TFTP = "Use TFTP instead of TCP";
    private static final String SETTING_RASTER_WHITESPACE = "Additional space per Raster line";
    private static final String SETTING_DEBUGFILE = "Debug output file";
    private static final String SETTING_SUPPORTS_PURGE = "Supports purge";
    private static final String SETTING_SUPPORTS_VENTILATION = "Supports ventilation";
    private static final String SETTING_SUPPORTS_FREQUENCY = "Supports frequency";
    private static final String SETTING_SUPPORTS_FOCUS = "Supports focus (Z-axis movement)";
    private boolean supportsFrequency = false;
    private boolean supportsFocus = false;
    private boolean supportsPurge = false;
    private boolean supportsVentilation = false;
    private transient boolean unidir = false;
    private String debugFilename = "";
    private double addSpacePerRasterLine = 5.0;
    protected boolean useTftp = true;
    protected boolean flipXaxis = false;
    protected boolean flipYaxis = true;
    protected String hostname = "192.168.123.111";
    protected int port = 69;
    protected double mmPerStep = 0.001;
    private float currentPower = -1.0f;
    private float currentSpeed = -1.0f;
    private int currentFrequency = -1;
    private float currentFocus = 0.0f;
    private Boolean currentVentilation = null;
    private Boolean currentPurge = null;
    private List<Double> resolutions;
    protected double bedWidth = 300.0;
    protected double bedHeight = 210.0;
    private static String[] settingAttributes = new String[]{"Hostname / IP", "Port", "Laserbed width", "Laserbed height", "Supports ventilation", "Supports purge", "Supports focus (Z-axis movement)", "Supports frequency", "Use TFTP instead of TCP", "Additional space per Raster line", "Debug output file"};

    public boolean isSupportsFrequency() {
        return this.supportsFrequency;
    }

    public void setSupportsFrequency(boolean supportsFrequency) {
        this.supportsFrequency = supportsFrequency;
    }

    public boolean isSupportsFocus() {
        return this.supportsFocus;
    }

    public void setSupportsFocus(boolean supportsFocus) {
        this.supportsFocus = supportsFocus;
    }

    public boolean isSupportsPurge() {
        return this.supportsPurge;
    }

    public void setSupportsPurge(boolean supportsPurge) {
        this.supportsPurge = supportsPurge;
    }

    public boolean isSupportsVentilation() {
        return this.supportsVentilation;
    }

    public void setSupportsVentilation(boolean supportsVentilation) {
        this.supportsVentilation = supportsVentilation;
    }

    @Override
    public LaosCutterProperty getLaserPropertyForVectorPart() {
        return new LaosCutterProperty(!this.supportsPurge, !this.supportsVentilation, !this.supportsFocus, !this.supportsFrequency);
    }

    @Override
    public LaosEngraveProperty getLaserPropertyForRasterPart() {
        return new LaosEngraveProperty(!this.supportsPurge, !this.supportsVentilation, !this.supportsFocus, !this.supportsFrequency);
    }

    @Override
    public LaosEngraveProperty getLaserPropertyForRaster3dPart() {
        return new LaosEngraveProperty(!this.supportsPurge, !this.supportsVentilation, !this.supportsFocus, !this.supportsFrequency);
    }

    public double getAddSpacePerRasterLine() {
        return this.addSpacePerRasterLine;
    }

    public void setAddSpacePerRasterLine(double addSpacePerRasterLine) {
        this.addSpacePerRasterLine = addSpacePerRasterLine;
    }

    @Override
    public String getModelName() {
        return "LAOS";
    }

    public boolean isUseTftp() {
        return this.useTftp;
    }

    public void setUseTftp(boolean useTftp) {
        this.useTftp = useTftp;
    }

    public boolean isFlipXaxis() {
        return this.flipXaxis;
    }

    public void setFlipXaxis(boolean flipXaxis) {
        this.flipXaxis = flipXaxis;
    }

    public boolean isFlipYaxis() {
        return this.flipYaxis;
    }

    public void setFlipYaxis(boolean flipYaxis) {
        this.flipYaxis = flipYaxis;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public double getMmPerStep() {
        return this.mmPerStep;
    }

    public void setMmPerStep(double mmPerStep) {
        this.mmPerStep = mmPerStep;
    }

    private int px2steps(double px, double dpi) {
        return (int)(Util.px2mm(px, dpi) / this.mmPerStep);
    }

    private byte[] generateVectorGCode(VectorPart vp, double resolution) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        block5: for (VectorCommand cmd : vp.getCommandList()) {
            switch (cmd.getType()) {
                case MOVETO: {
                    this.move(out, cmd.getX(), cmd.getY(), resolution);
                    continue block5;
                }
                case LINETO: {
                    this.line(out, cmd.getX(), cmd.getY(), resolution);
                    continue block5;
                }
                case SETPROPERTY: {
                    this.setCurrentProperty(out, cmd.getProperty());
                }
            }
        }
        return result.toByteArray();
    }

    private void move(PrintStream out, float x, float y, double resolution) {
        out.printf("0 %d %d\n", this.px2steps(this.isFlipXaxis() ? Util.mm2px(this.bedWidth, resolution) - (double)x : (double)x, resolution), this.px2steps(this.isFlipYaxis() ? Util.mm2px(this.bedHeight, resolution) - (double)y : (double)y, resolution));
    }

    private void loadBitmapLine(PrintStream out, List<Long> dwords) {
        out.printf("9 %s %s ", "1", "" + dwords.size() * 32);
        for (Long d : dwords) {
            out.printf(" " + d, new Object[0]);
        }
        out.printf("\n", new Object[0]);
    }

    private void setPower(PrintStream out, float power) {
        if (this.currentPower != power) {
            out.printf("7 101 %d\n", (int)(power * 100.0f));
            this.currentPower = power;
        }
    }

    private void setSpeed(PrintStream out, float speed) {
        if (this.currentSpeed != speed) {
            out.printf("7 100 %d\n", (int)(speed * 100.0f));
            this.currentSpeed = speed;
        }
    }

    private void setFrequency(PrintStream out, int frequency) {
        if (this.currentFrequency != frequency) {
            out.printf("7 102 %d\n", frequency);
            this.currentFrequency = frequency;
        }
    }

    private void setFocus(PrintStream out, float focus) {
        if (this.currentFocus != focus) {
            out.printf(Locale.US, "2 %d\n", (int)((double)focus / this.mmPerStep));
            this.currentFocus = focus;
        }
    }

    private void setVentilation(PrintStream out, boolean ventilation) {
        if (this.currentVentilation == null || !this.currentVentilation.equals(ventilation)) {
            out.printf(Locale.US, "7 6 %d\n", ventilation ? 1 : 0);
            this.currentVentilation = ventilation;
        }
    }

    private void setPurge(PrintStream out, boolean purge) {
        if (this.currentPurge == null || !this.currentPurge.equals(purge)) {
            out.printf(Locale.US, "7 7 %d\n", purge ? 1 : 0);
            this.currentPurge = purge;
        }
    }

    private void setCurrentProperty(PrintStream out, LaserProperty p) {
        if (p instanceof LaosCutterProperty) {
            LaosCutterProperty prop = (LaosCutterProperty)p;
            if (this.supportsFocus) {
                this.setFocus(out, prop.getFocus());
            }
            if (this.supportsVentilation) {
                this.setVentilation(out, prop.getVentilation());
            }
            if (this.supportsPurge) {
                this.setPurge(out, prop.getPurge());
            }
            this.setSpeed(out, prop.getSpeed());
            this.setPower(out, prop.getPower());
            if (this.supportsFrequency) {
                this.setFrequency(out, prop.getFrequency());
            }
        } else {
            throw new RuntimeException("The Laos driver only accepts LaosCutter properties (was " + p.getClass().toString() + ")");
        }
    }

    private void line(PrintStream out, float x, float y, double resolution) {
        out.printf("1 %d %d\n", this.px2steps(this.isFlipXaxis() ? Util.mm2px(this.bedWidth, resolution) - (double)x : (double)x, resolution), this.px2steps(this.isFlipYaxis() ? Util.mm2px(this.bedHeight, resolution) - (double)y : (double)y, resolution));
    }

    private byte[] generatePseudoRaster3dGCode(Raster3dPart rp, double resolution) throws UnsupportedEncodingException {
        int line;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        boolean dirRight = true;
        Point rasterStart = rp.getRasterStart();
        LaosEngraveProperty prop = rp.getLaserProperty() instanceof LaosEngraveProperty ? (LaosEngraveProperty)rp.getLaserProperty() : new LaosEngraveProperty(rp.getLaserProperty());
        this.setCurrentProperty(out, prop);
        float maxPower = this.currentPower;
        boolean bu = prop.isEngraveBottomUp();
        int n = line = bu ? rp.getRasterHeight() - 1 : 0;
        while (bu ? line >= 0 : line < rp.getRasterHeight()) {
            Point lineStart = rasterStart.clone();
            lineStart.y += line;
            List<Byte> bytes = rp.getRasterLine(line);
            while (bytes.size() > 0 && bytes.get(0) == 0) {
                bytes.remove(0);
                ++lineStart.x;
            }
            while (bytes.size() > 0 && bytes.get(bytes.size() - 1) == 0) {
                bytes.remove(bytes.size() - 1);
            }
            if (bytes.size() > 0) {
                int pix;
                byte old;
                if (dirRight) {
                    this.move(out, lineStart.x, lineStart.y, resolution);
                    old = bytes.get(0);
                    for (pix = 0; pix < bytes.size(); ++pix) {
                        if (bytes.get(pix) == old) continue;
                        if (old == 0) {
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        } else {
                            this.setPower(out, maxPower * (float)(0xFF & old) / 255.0f);
                            this.line(out, lineStart.x + pix - 1, lineStart.y, resolution);
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        }
                        old = bytes.get(pix);
                    }
                    this.setPower(out, maxPower * (float)(0xFF & bytes.get(bytes.size() - 1)) / 255.0f);
                    this.line(out, lineStart.x + bytes.size() - 1, lineStart.y, resolution);
                } else {
                    this.move(out, lineStart.x + bytes.size() - 1, lineStart.y, resolution);
                    old = bytes.get(bytes.size() - 1);
                    for (pix = bytes.size() - 1; pix >= 0; --pix) {
                        if (bytes.get(pix) == old && pix != 0) continue;
                        if (old == 0) {
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        } else {
                            this.setPower(out, maxPower * (float)(0xFF & old) / 255.0f);
                            this.line(out, lineStart.x + pix + 1, lineStart.y, resolution);
                            this.move(out, lineStart.x + pix, lineStart.y, resolution);
                        }
                        old = bytes.get(pix);
                    }
                    this.setPower(out, maxPower * (float)(0xFF & bytes.get(0)) / 255.0f);
                    this.line(out, lineStart.x, lineStart.y, resolution);
                }
            }
            if (!prop.isEngraveUnidirectional()) {
                dirRight = !dirRight;
            }
            line += bu ? -1 : 1;
        }
        return result.toByteArray();
    }

    public List<Long> byteLineToDwords(List<Byte> line, boolean outputLeftToRight) {
        int i;
        ArrayList<Long> result = new ArrayList<Long>();
        int s = line.size();
        for (i = 0; i < s; ++i) {
            line.set(i, (byte)(Integer.reverse(0xFF & line.get(i)) >>> 24));
        }
        for (i = 0; i < s; i += 4) {
            result.add(((long)(i + 3 < s ? 0xFF & line.get(i + 3) : 0) << 24) + ((long)(i + 2 < s ? 0xFF & line.get(i + 2) : 0) << 16) + ((long)(i + 1 < s ? 0xFF & line.get(i + 1) : 0) << 8) + (long)(0xFF & line.get(i)));
        }
        if (!outputLeftToRight) {
            Collections.reverse(result);
            for (i = 0; i < result.size(); ++i) {
                result.set(i, Long.reverse((Long)result.get(i)) >>> 32);
            }
        }
        return result;
    }

    private byte[] generateLaosRasterCode(RasterPart rp, double resolution) throws UnsupportedEncodingException, IOException {
        int line;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        boolean dirRight = true;
        Point rasterStart = rp.getRasterStart();
        LaosEngraveProperty prop = rp.getLaserProperty() instanceof LaosEngraveProperty ? (LaosEngraveProperty)rp.getLaserProperty() : new LaosEngraveProperty(rp.getLaserProperty());
        this.setCurrentProperty(out, prop);
        boolean bu = prop.isEngraveBottomUp();
        int n = line = bu ? rp.getRasterHeight() - 1 : 0;
        while (bu ? line >= 0 : line < rp.getRasterHeight()) {
            Point lineStart = rasterStart.clone();
            lineStart.y += line;
            List<Byte> bytes = rp.getRasterLine(line);
            while (bytes.size() > 0 && bytes.get(0) == 0) {
                lineStart.x += 8;
                bytes.remove(0);
            }
            while (bytes.size() > 0 && bytes.get(bytes.size() - 1) == 0) {
                bytes.remove(bytes.size() - 1);
            }
            if (bytes.size() > 0) {
                List<Long> dwords;
                int space = (int)Util.mm2px(this.getAddSpacePerRasterLine(), resolution);
                while (space > 0 && lineStart.x >= 8) {
                    bytes.add(0, (byte)0);
                    space -= 8;
                    lineStart.x -= 8;
                }
                int max = (int)Util.mm2px(this.getBedWidth(), resolution);
                for (space = (int)Util.mm2px(this.getAddSpacePerRasterLine(), resolution); space > 0 && lineStart.x + 8 * bytes.size() < max - 8; space -= 8) {
                    bytes.add((byte)0);
                }
                if (dirRight) {
                    this.move(out, lineStart.x, lineStart.y, resolution);
                    dwords = this.byteLineToDwords(bytes, true);
                    this.loadBitmapLine(out, dwords);
                    this.line(out, lineStart.x + dwords.size() * 32, lineStart.y, resolution);
                } else {
                    dwords = this.byteLineToDwords(bytes, false);
                    this.move(out, lineStart.x + dwords.size() * 32, lineStart.y, resolution);
                    this.loadBitmapLine(out, dwords);
                    this.line(out, lineStart.x, lineStart.y, resolution);
                }
            }
            if (!prop.isEngraveUnidirectional()) {
                dirRight = !dirRight;
            }
            line += bu ? -1 : 1;
        }
        return result.toByteArray();
    }

    private byte[] generateInitializationCode() throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        return result.toByteArray();
    }

    private byte[] generateShutdownCode() throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        this.setFocus(out, 0.0f);
        this.setVentilation(out, false);
        this.setPurge(out, false);
        return result.toByteArray();
    }

    protected void writeJobCode(LaserJob job, OutputStream out, ProgressListener pl) throws UnsupportedEncodingException, IOException {
        out.write(this.generateInitializationCode());
        pl.progressChanged(this, 20);
        out.write(this.generateBoundingBoxCode(job));
        int i = 0;
        int max = job.getParts().size();
        for (JobPart p : job.getParts()) {
            if (p instanceof Raster3dPart) {
                out.write(this.generatePseudoRaster3dGCode((Raster3dPart)p, p.getDPI()));
            } else if (p instanceof RasterPart) {
                out.write(this.generateLaosRasterCode((RasterPart)p, p.getDPI()));
            } else if (p instanceof VectorPart) {
                out.write(this.generateVectorGCode((VectorPart)p, p.getDPI()));
            }
            pl.progressChanged(this, 20 + (int)((double)(++i) * 60.0 / (double)max));
        }
        out.write(this.generateShutdownCode());
        out.close();
    }

    @Override
    public void sendJob(LaserJob job, ProgressListener pl, List<String> warnings) throws IllegalJobException, Exception {
        BufferedOutputStream out;
        this.currentFrequency = -1;
        this.currentPower = -1.0f;
        this.currentSpeed = -1.0f;
        this.currentFocus = 0.0f;
        this.currentPurge = false;
        this.currentVentilation = false;
        pl.progressChanged(this, 0);
        ByteArrayOutputStream buffer = null;
        pl.taskChanged(this, "checking job");
        this.checkJob(job);
        job.applyStartPoint();
        if (!this.useTftp) {
            pl.taskChanged(this, "connecting");
            Socket connection = new Socket();
            connection.connect(new InetSocketAddress(this.hostname, this.port), 3000);
            out = new BufferedOutputStream(connection.getOutputStream());
            pl.taskChanged(this, "sending");
        } else {
            buffer = new ByteArrayOutputStream();
            out = new BufferedOutputStream(buffer);
            pl.taskChanged(this, "buffering");
        }
        this.writeJobCode(job, out, pl);
        if (this.isUseTftp()) {
            pl.taskChanged(this, "connecting");
            TFTPClient tftp = new TFTPClient();
            tftp.setDefaultTimeout(5000);
            tftp.open();
            pl.taskChanged(this, "sending");
            ByteArrayInputStream bain = new ByteArrayInputStream(buffer.toByteArray());
            tftp.sendFile(job.getName().replace(" ", "") + ".lgc", 1, (InputStream)bain, this.getHostname(), this.getPort());
            tftp.close();
            bain.close();
            if (this.debugFilename != null && !"".equals(this.debugFilename)) {
                pl.taskChanged(this, "writing " + this.debugFilename);
                FileOutputStream o = new FileOutputStream(new File(this.debugFilename));
                o.write(buffer.toByteArray());
                o.close();
            }
            pl.taskChanged(this, "sent.");
        }
        pl.progressChanged(this, 100);
    }

    @Override
    public List<Double> getResolutions() {
        if (this.resolutions == null) {
            this.resolutions = Arrays.asList(100.0, 200.0, 300.0, 500.0, 600.0, 1000.0, 1200.0);
        }
        return this.resolutions;
    }

    @Override
    public double getBedWidth() {
        return this.bedWidth;
    }

    public void setBedWidth(double bedWidth) {
        this.bedWidth = bedWidth;
    }

    @Override
    public double getBedHeight() {
        return this.bedHeight;
    }

    public void setBedHeight(double bedHeight) {
        this.bedHeight = bedHeight;
    }

    @Override
    public String[] getPropertyKeys() {
        return settingAttributes;
    }

    @Override
    public Object getProperty(String attribute) {
        if (SETTING_DEBUGFILE.equals(attribute)) {
            return this.debugFilename;
        }
        if (SETTING_RASTER_WHITESPACE.equals(attribute)) {
            return this.getAddSpacePerRasterLine();
        }
        if (SETTING_SUPPORTS_FREQUENCY.equals(attribute)) {
            return this.supportsFrequency;
        }
        if (SETTING_SUPPORTS_PURGE.equals(attribute)) {
            return this.supportsPurge;
        }
        if (SETTING_SUPPORTS_VENTILATION.equals(attribute)) {
            return this.supportsVentilation;
        }
        if (SETTING_SUPPORTS_FOCUS.equals(attribute)) {
            return this.supportsFocus;
        }
        if (SETTING_HOSTNAME.equals(attribute)) {
            return this.getHostname();
        }
        if (SETTING_FLIPX.equals(attribute)) {
            return this.isFlipXaxis();
        }
        if (SETTING_FLIPY.equals(attribute)) {
            return this.isFlipYaxis();
        }
        if (SETTING_PORT.equals(attribute)) {
            return this.getPort();
        }
        if (SETTING_BEDWIDTH.equals(attribute)) {
            return this.getBedWidth();
        }
        if (SETTING_BEDHEIGHT.equals(attribute)) {
            return this.getBedHeight();
        }
        if (SETTING_MMPERSTEP.equals(attribute)) {
            return this.getMmPerStep();
        }
        if (SETTING_TFTP.equals(attribute)) {
            return this.isUseTftp();
        }
        return null;
    }

    @Override
    public void setProperty(String attribute, Object value) {
        if (SETTING_DEBUGFILE.equals(attribute)) {
            this.debugFilename = value != null ? (String)value : "";
        } else if (SETTING_RASTER_WHITESPACE.equals(attribute)) {
            this.setAddSpacePerRasterLine((Double)value);
        } else if (SETTING_SUPPORTS_FREQUENCY.equals(attribute)) {
            this.setSupportsFrequency((Boolean)value);
        } else if (SETTING_SUPPORTS_PURGE.equals(attribute)) {
            this.setSupportsPurge((Boolean)value);
        } else if (SETTING_SUPPORTS_VENTILATION.equals(attribute)) {
            this.setSupportsVentilation((Boolean)value);
        } else if (SETTING_SUPPORTS_FOCUS.equals(attribute)) {
            this.setSupportsFocus((Boolean)value);
        } else if (SETTING_HOSTNAME.equals(attribute)) {
            this.setHostname((String)value);
        } else if (SETTING_PORT.equals(attribute)) {
            this.setPort((Integer)value);
        } else if (SETTING_FLIPX.equals(attribute)) {
            this.setFlipXaxis((Boolean)value);
        } else if (SETTING_FLIPY.equals(attribute)) {
            this.setFlipYaxis((Boolean)value);
        } else if (SETTING_BEDWIDTH.equals(attribute)) {
            this.setBedWidth((Double)value);
        } else if (SETTING_BEDHEIGHT.equals(attribute)) {
            this.setBedHeight((Double)value);
        } else if (SETTING_MMPERSTEP.equals(attribute)) {
            this.setMmPerStep((Double)value);
        } else if (SETTING_TFTP.contains(attribute)) {
            this.setUseTftp((Boolean)value);
        }
    }

    @Override
    public LaserCutter clone() {
        LaosCutter clone = new LaosCutter();
        clone.hostname = this.hostname;
        clone.port = this.port;
        clone.debugFilename = this.debugFilename;
        clone.bedHeight = this.bedHeight;
        clone.bedWidth = this.bedWidth;
        clone.flipXaxis = this.flipXaxis;
        clone.flipYaxis = this.flipYaxis;
        clone.mmPerStep = this.mmPerStep;
        clone.useTftp = this.useTftp;
        clone.addSpacePerRasterLine = this.addSpacePerRasterLine;
        clone.supportsFrequency = this.supportsFrequency;
        clone.supportsPurge = this.supportsPurge;
        clone.supportsVentilation = this.supportsVentilation;
        clone.supportsFocus = this.supportsFocus;
        return clone;
    }

    private byte[] generateBoundingBoxCode(LaserJob job) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        if (job.getParts().size() > 0) {
            JobPart p = job.getParts().get(0);
            double xMin = Util.px2mm(p.getMinX(), p.getDPI());
            double xMax = Util.px2mm(p.getMaxX(), p.getDPI());
            double yMin = Util.px2mm(p.getMinY(), p.getDPI());
            double yMax = Util.px2mm(p.getMaxY(), p.getDPI());
            double maxDPI = p.getDPI();
            for (JobPart jp : job.getParts()) {
                xMin = Math.min(xMin, Util.px2mm(jp.getMinX(), jp.getDPI()));
                xMax = Math.max(xMax, Util.px2mm(jp.getMaxX(), jp.getDPI()));
                yMin = Math.min(yMin, Util.px2mm(jp.getMinY(), jp.getDPI()));
                yMax = Math.max(yMax, Util.px2mm(jp.getMaxY(), jp.getDPI()));
                maxDPI = Math.max(maxDPI, jp.getDPI());
            }
            out.printf("201 %d %d\n", this.px2steps(Util.mm2px(this.isFlipXaxis() ? this.bedWidth - xMax : xMin, maxDPI), maxDPI));
            out.printf("202 %d %d\n", this.px2steps(Util.mm2px(this.isFlipXaxis() ? this.bedWidth - xMin : xMax, maxDPI), maxDPI));
            out.printf("203 %d %d\n", this.px2steps(Util.mm2px(this.isFlipYaxis() ? this.bedWidth - yMax : yMin, maxDPI), maxDPI));
            out.printf("204 %d %d\n", this.px2steps(Util.mm2px(this.isFlipYaxis() ? this.bedWidth - xMin : yMax, maxDPI), maxDPI));
        }
        return result.toByteArray();
    }
}

