/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.drivers;

import com.t_oster.liblasercut.IllegalJobException;
import com.t_oster.liblasercut.JobPart;
import com.t_oster.liblasercut.LaserCutter;
import com.t_oster.liblasercut.LaserJob;
import com.t_oster.liblasercut.PowerSpeedFocusFrequencyProperty;
import com.t_oster.liblasercut.PowerSpeedFocusProperty;
import com.t_oster.liblasercut.ProgressListener;
import com.t_oster.liblasercut.Raster3dPart;
import com.t_oster.liblasercut.RasterPart;
import com.t_oster.liblasercut.VectorCommand;
import com.t_oster.liblasercut.VectorPart;
import com.t_oster.liblasercut.platform.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

abstract class EpilogCutter
extends LaserCutter {
    public static boolean SIMULATE_COMMUNICATION = false;
    public static final int NETWORK_TIMEOUT = 3000;
    private static final int MINFOCUS = -500;
    private static final int MAXFOCUS = 500;
    private static final double FOCUSWIDTH = 0.0252;
    private String hostname = "10.0.0.1";
    private int port = 515;
    private boolean autofocus = false;
    private transient InputStream in;
    private transient OutputStream out;
    protected double bedWidth = 600.0;
    protected double bedHeight = 300.0;
    private static String[] attributes = new String[]{"Hostname", "Port", "BedWidth", "BedHeight", "AutoFocus"};

    private int mm2focus(float mm) {
        return (int)((double)mm / 0.0252);
    }

    private float focus2mm(int focus) {
        return (float)((double)focus * 0.0252);
    }

    public EpilogCutter() {
    }

    public EpilogCutter(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public boolean isAutoFocus() {
        return this.autofocus;
    }

    public void setAutoFocus(boolean af) {
        this.autofocus = af;
    }

    private void waitForResponse(int expected) throws IOException, Exception {
        this.waitForResponse(expected, 3);
    }

    private void waitForResponse(int expected, int timeout) throws IOException, Exception {
        if (SIMULATE_COMMUNICATION) {
            return;
        }
        this.out.flush();
        for (int i = 0; i < timeout * 10; ++i) {
            if (this.in.available() > 0) {
                int result = this.in.read();
                if (result == -1) {
                    throw new IOException("End of Stream");
                }
                if (result != expected) {
                    throw new Exception("unexpected Response: " + result);
                }
                return;
            }
            Thread.sleep(100 * timeout);
        }
        throw new Exception("Timeout");
    }

    private byte[] generatePjlHeader(LaserJob job, double resolution) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.printf("\u001b%%-12345X@PJL JOB NAME=%s\r\n", job.getTitle());
        out.printf("\u001bE@PJL ENTER LANGUAGE=PCL\r\n", new Object[0]);
        if (this.isAutoFocus()) {
            out.printf("\u001b&y1A", new Object[0]);
        } else {
            out.printf("\u001b&y0A", new Object[0]);
        }
        out.printf("\u001b&y0C", new Object[0]);
        out.printf("\u001b&y0Z", new Object[0]);
        out.printf("\u001b&l0U", new Object[0]);
        out.printf("\u001b&l0Z", new Object[0]);
        out.printf("\u001b&u%dD", (int)resolution);
        out.printf("\u001b*p0X", new Object[0]);
        out.printf("\u001b*p0Y", new Object[0]);
        return result.toByteArray();
    }

    private byte[] generatePjlFooter() throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.printf("\u001bE", new Object[0]);
        out.printf("\u001b%%-12345X", new Object[0]);
        out.printf("@PJL EOJ \r\n", new Object[0]);
        return result.toByteArray();
    }

    private void sendPjlJob(LaserJob job, byte[] pjlData) throws UnknownHostException, UnsupportedEncodingException, IOException, Exception {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            localhost = "unknown";
        }
        PrintStream out = new PrintStream(this.out, true, "US-ASCII");
        out.print("\u0002\n");
        this.waitForResponse(0);
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        PrintStream stmp = new PrintStream((OutputStream)tmp, true, "US-ASCII");
        stmp.printf("H%s\n", localhost);
        stmp.printf("P%s\n", job.getUser());
        stmp.printf("J%s\n", job.getTitle());
        stmp.printf("ldfA%s%s\n", job.getName(), localhost);
        stmp.printf("UdfA%s%s\n", job.getName(), localhost);
        stmp.printf("N%s\n", job.getTitle());
        out.printf("\u0002%d cfA%s%s\n", tmp.toByteArray().length, job.getName(), localhost);
        this.waitForResponse(0);
        out.write(tmp.toByteArray());
        out.append('\u0000');
        this.waitForResponse(0);
        out.printf("\u0003%d dfA%s%s\n", pjlData.length, job.getName(), localhost);
        this.waitForResponse(0);
        out.write(pjlData);
        this.waitForResponse(0);
    }

    private void connect() throws IOException, SocketTimeoutException {
        if (SIMULATE_COMMUNICATION) {
            this.out = System.out;
        } else {
            Socket connection = new Socket();
            connection.connect(new InetSocketAddress(this.hostname, this.port), 3000);
            this.in = new BufferedInputStream(connection.getInputStream());
            this.out = new BufferedOutputStream(connection.getOutputStream());
        }
    }

    private void disconnect() throws IOException {
        if (!SIMULATE_COMMUNICATION) {
            this.in.close();
            this.out.close();
        }
    }

    @Override
    protected void checkJob(LaserJob job) throws IllegalJobException {
        super.checkJob(job);
        for (JobPart p : job.getParts()) {
            float focus;
            JobPart rp;
            if (p instanceof VectorPart) {
                for (VectorCommand cmd : ((VectorPart)p).getCommandList()) {
                    if (cmd.getType() != VectorCommand.CmdType.SETPROPERTY) continue;
                    if (!(cmd.getProperty() instanceof PowerSpeedFocusFrequencyProperty)) {
                        throw new IllegalJobException("This driver expects Power,Speed,Frequency and Focus as settings");
                    }
                    float focus2 = ((PowerSpeedFocusFrequencyProperty)cmd.getProperty()).getFocus();
                    if (this.mm2focus(focus2) <= 500 && this.mm2focus(focus2) >= -500) continue;
                    throw new IllegalJobException("Illegal Focus value. This Lasercutter supports values between" + this.focus2mm(-500) + "mm to " + this.focus2mm(500) + "mm.");
                }
            }
            if (p instanceof RasterPart) {
                float focus3;
                rp = (RasterPart)p;
                if (((RasterPart)rp).getLaserProperty() != null && !(((RasterPart)rp).getLaserProperty() instanceof PowerSpeedFocusProperty)) {
                    throw new IllegalJobException("This driver expects Power,Speed and Focus as settings");
                }
                float f = focus3 = ((RasterPart)rp).getLaserProperty() == null ? 0.0f : ((PowerSpeedFocusProperty)((RasterPart)rp).getLaserProperty()).getFocus();
                if (this.mm2focus(focus3) > 500 || this.mm2focus(focus3) < -500) {
                    throw new IllegalJobException("Illegal Focus value. This Lasercutter supports values between" + this.focus2mm(-500) + "mm to " + this.focus2mm(500) + "mm.");
                }
            }
            if (!(p instanceof Raster3dPart)) continue;
            rp = (Raster3dPart)p;
            if (((Raster3dPart)rp).getLaserProperty() != null && !(((Raster3dPart)rp).getLaserProperty() instanceof PowerSpeedFocusProperty)) {
                throw new IllegalJobException("This driver expects Power,Speed and Focus as settings");
            }
            float f = focus = ((Raster3dPart)rp).getLaserProperty() == null ? 0.0f : ((PowerSpeedFocusProperty)((Raster3dPart)rp).getLaserProperty()).getFocus();
            if (this.mm2focus(focus) <= 500 && this.mm2focus(focus) >= -500) continue;
            throw new IllegalJobException("Illegal Focus value. This Lasercutter supports values between" + this.focus2mm(-500) + "mm to " + this.focus2mm(500) + "mm.");
        }
    }

    public void realSendJob(LaserJob job, ProgressListener pl, int number, int count) throws UnsupportedEncodingException, IOException, UnknownHostException, Exception {
        job.applyStartPoint();
        String nb = count > 1 ? "(" + number + "/" + count + ")" : "";
        pl.taskChanged(this, "generating" + nb);
        byte[] pjlData = this.generatePjlData(job);
        pl.progressChanged(this, (int)(40.0 * (double)number / (double)count));
        pl.taskChanged(this, "connecting" + nb);
        this.connect();
        pl.progressChanged(this, (int)(60.0 * (double)number / (double)count));
        pl.taskChanged(this, "sending" + nb);
        this.sendPjlJob(job, pjlData);
        pl.progressChanged(this, (int)(90.0 * (double)number / (double)count));
        this.disconnect();
    }

    @Override
    public void sendJob(LaserJob job, ProgressListener pl, List<String> warnings) throws IllegalJobException, SocketTimeoutException, UnsupportedEncodingException, IOException, UnknownHostException, Exception {
        pl.progressChanged(this, 0);
        pl.taskChanged(this, "checking job");
        this.checkJob(job);
        LinkedList jobs = new LinkedList();
        List<JobPart> toDo = job.getParts();
        while (!toDo.isEmpty()) {
            LinkedList<JobPart> currentSplit = new LinkedList<JobPart>();
            if (toDo.get(0) instanceof Raster3dPart) {
                currentSplit.add(toDo.get(0));
                toDo.remove(0);
            } else {
                double currentDpi = toDo.get(0).getDPI();
                if (toDo.get(0) instanceof RasterPart) {
                    currentSplit.add(toDo.get(0));
                    toDo.remove(0);
                }
                while (!toDo.isEmpty() && toDo.get(0) instanceof VectorPart && toDo.get(0).getDPI() == currentDpi) {
                    currentSplit.add(toDo.get(0));
                    toDo.remove(0);
                }
            }
            jobs.add(currentSplit);
        }
        int number = 0;
        int size = jobs.size();
        if (size > 1) {
            warnings.add("The job had to be split into " + size + " jobs.");
        }
        for (List list : jobs) {
            LaserJob j = new LaserJob((size > 1 ? "(" + ++number + "/" + size + ")" : "") + job.getTitle(), job.getName(), job.getUser());
            j.setStartPoint(job.getStartX(), job.getStartY());
            for (JobPart p : list) {
                j.addPart(p);
            }
            this.realSendJob(j, pl, number, size);
        }
        pl.progressChanged(this, 100);
    }

    @Override
    public abstract List<Double> getResolutions();

    public List<Byte> encode(List<Byte> line) {
        int idx = 0;
        int r = line.size();
        LinkedList<Byte> result = new LinkedList<Byte>();
        while (idx < r) {
            int p;
            for (p = idx + 1; p < r && p < idx + 128 && line.get(p) == line.get(idx); ++p) {
            }
            if (p - idx >= 2) {
                result.add((byte)(1 - (p - idx)));
                result.add((byte)line.get(idx));
                idx = p;
                continue;
            }
            for (p = idx; p < r && p < idx + 127 && (p + 1 == r || line.get(p) != line.get(p + 1)); ++p) {
            }
            result.add((byte)(p - idx - 1));
            while (idx < p) {
                result.add((byte)line.get(idx++));
            }
        }
        return result;
    }

    private byte[] generateRaster3dPCL(Raster3dPart rp) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        if (rp != null) {
            PowerSpeedFocusProperty prop = (PowerSpeedFocusProperty)rp.getLaserProperty();
            out.printf("\u001b*t%dR", (int)rp.getDPI());
            out.printf("\u001b*r0F", new Object[0]);
            out.printf("\u001b&y%dP", prop.getPower());
            out.printf("\u001b&z%dS", prop.getSpeed());
            out.printf("\u001b&y%dA", this.mm2focus(prop.getFocus()));
            out.printf("\u001b*r%dT", rp != null ? rp.getMaxY() : 10);
            out.printf("\u001b*r%dS", rp != null ? rp.getMaxX() : 10);
            out.printf("\u001b*b%dMLT", 7);
            out.printf("\u001b&y%dO", 0);
            out.printf("\u001b*r1A", new Object[0]);
            Point sp = rp.getRasterStart();
            boolean leftToRight = true;
            for (int y = 0; y < rp.getRasterHeight(); ++y) {
                List<Byte> line = rp.getInvertedRasterLine(y);
                for (int n = 0; n < line.size(); ++n) {
                    int x = line.get(n).byteValue();
                    x = x >= 0 ? x : 256 + x;
                    int scalex = x * prop.getPower() / 100;
                    byte bx = (byte)(scalex < 128 ? scalex : scalex - 256);
                    line.set(n, bx);
                }
                int jump = 0;
                while (line.size() > 0 && line.get(0) == 0) {
                    line.remove(0);
                    ++jump;
                }
                if (line.size() <= 0) continue;
                out.printf("\u001b*p%dX", sp.x + jump);
                out.printf("\u001b*p%dY", sp.y + y);
                if (leftToRight) {
                    out.printf("\u001b*b%dA", line.size());
                } else {
                    out.printf("\u001b*b%dA", -line.size());
                    Collections.reverse(line);
                }
                line = this.encode(line);
                int len = line.size();
                int pcks = len / 8;
                if (len % 8 > 0) {
                    ++pcks;
                }
                out.printf("\u001b*b%dW", pcks * 8);
                for (byte s : line) {
                    out.write(s);
                }
                for (int k = 0; k < 8 - len % 8; ++k) {
                    out.write(-128);
                }
                leftToRight = !leftToRight;
            }
            out.printf("\u001b*rC", new Object[0]);
        }
        return result.toByteArray();
    }

    private byte[] generateDummyRaster(JobPart jp) throws UnsupportedEncodingException {
        PowerSpeedFocusProperty prop = new PowerSpeedFocusProperty();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.printf("\u001b*t%dR", (int)jp.getDPI());
        out.printf("\u001b*r0F", new Object[0]);
        out.printf("\u001b&y%dP", prop.getPower());
        out.printf("\u001b&z%dS", prop.getSpeed());
        out.printf("\u001b&y%dA", this.mm2focus(prop.getFocus()));
        out.printf("\u001b*r%dT", jp.getMaxY());
        out.printf("\u001b*r%dS", jp.getMaxX());
        out.printf("\u001b*b2M", new Object[0]);
        out.printf("\u001b&y%dO", 0);
        out.printf("\u001b*r1A", new Object[0]);
        out.printf("\u001b*rC", new Object[0]);
        return result.toByteArray();
    }

    private byte[] generateRasterPCL(RasterPart rp) throws UnsupportedEncodingException, IOException {
        PowerSpeedFocusProperty prop = (PowerSpeedFocusProperty)rp.getLaserProperty();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.printf("\u001b*t%dR", (int)rp.getDPI());
        out.printf("\u001b*r0F", new Object[0]);
        out.printf("\u001b&y%dP", prop.getPower());
        out.printf("\u001b&z%dS", prop.getSpeed());
        out.printf("\u001b&y%dA", this.mm2focus(prop.getFocus()));
        out.printf("\u001b*r%dT", rp.getMaxY());
        out.printf("\u001b*r%dS", rp.getMaxX());
        out.printf("\u001b*b2M", new Object[0]);
        out.printf("\u001b&y%dO", 0);
        out.printf("\u001b*r1A", new Object[0]);
        if (rp != null) {
            Point sp = rp.getRasterStart();
            boolean leftToRight = true;
            for (int y = 0; y < rp.getRasterHeight(); ++y) {
                List<Byte> line = rp.getRasterLine(y);
                int jump = 0;
                while (line.size() > 0 && line.get(0) == 0) {
                    line.remove(0);
                    ++jump;
                }
                while (line.size() > 0 && line.get(line.size() - 1) == 0) {
                    line.remove(line.size() - 1);
                }
                if (line.size() <= 0) continue;
                out.printf("\u001b*p%dX", sp.x + jump * 8);
                out.printf("\u001b*p%dY", sp.y + y);
                if (leftToRight) {
                    out.printf("\u001b*b%dA", line.size());
                } else {
                    out.printf("\u001b*b%dA", -line.size());
                    Collections.reverse(line);
                }
                line = this.encode(line);
                int len = line.size();
                int pcks = len / 8;
                if (len % 8 > 0) {
                    ++pcks;
                }
                out.printf("\u001b*b%dW", pcks * 8);
                for (byte s : line) {
                    out.write(s);
                }
                for (int k = 0; k < 8 - len % 8; ++k) {
                    out.write(-128);
                }
                leftToRight = !leftToRight;
            }
        }
        out.printf("\u001b*rC", new Object[0]);
        return result.toByteArray();
    }

    private byte[] generateDummyVector(double dpi) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.printf("\u001b%%1B", new Object[0]);
        out.printf("IN;PU0,0;", new Object[0]);
        out.printf("WF%d;", 0);
        return result.toByteArray();
    }

    private byte[] generateVectorPCL(VectorPart vp) throws UnsupportedEncodingException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)result, true, "US-ASCII");
        out.printf("\u001b%%1B", new Object[0]);
        out.printf("IN;PU0,0;", new Object[0]);
        if (vp != null) {
            Integer currentPower = null;
            Integer currentSpeed = null;
            Integer currentFrequency = null;
            Float currentFocus = null;
            VectorCommand.CmdType lastType = null;
            for (VectorCommand cmd : vp.getCommandList()) {
                if (lastType != null && lastType == VectorCommand.CmdType.LINETO && cmd.getType() != VectorCommand.CmdType.LINETO) {
                    out.print(";");
                }
                switch (cmd.getType()) {
                    case SETPROPERTY: {
                        PowerSpeedFocusFrequencyProperty p = (PowerSpeedFocusFrequencyProperty)cmd.getProperty();
                        if (currentFocus == null || !currentFocus.equals(Float.valueOf(p.getFocus()))) {
                            out.printf("WF%d;", this.mm2focus(p.getFocus()));
                            currentFocus = Float.valueOf(p.getFocus());
                        }
                        if (currentFrequency == null || !currentFrequency.equals(p.getFrequency())) {
                            out.printf("XR%04d;", p.getFrequency());
                            currentFrequency = p.getFrequency();
                        }
                        if (currentPower == null || !currentPower.equals(p.getPower())) {
                            out.printf("YP%03d;", p.getPower());
                            currentPower = p.getPower();
                        }
                        if (currentSpeed != null && currentSpeed.equals(p.getSpeed())) break;
                        out.printf("ZS%03d;", p.getSpeed());
                        currentSpeed = p.getSpeed();
                        break;
                    }
                    case MOVETO: {
                        out.printf("PU%d,%d;", cmd.getX(), cmd.getY());
                        break;
                    }
                    case LINETO: {
                        if (lastType == null || lastType != VectorCommand.CmdType.LINETO) {
                            out.printf("PD%d,%d", cmd.getX(), cmd.getY());
                            break;
                        }
                        out.printf(",%d,%d", cmd.getX(), cmd.getY());
                    }
                }
                lastType = cmd.getType();
            }
        }
        out.printf("WF%d;", 0);
        return result.toByteArray();
    }

    private byte[] generatePjlData(LaserJob job) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream pjlJob = new ByteArrayOutputStream();
        PrintStream wrt = new PrintStream((OutputStream)pjlJob, true, "US-ASCII");
        wrt.write(this.generatePjlHeader(job, job.getParts().get(0).getDPI()));
        if (!(job.getParts().get(0) instanceof RasterPart)) {
            wrt.write(this.generateDummyRaster(job.getParts().get(0)));
        }
        for (JobPart p : job.getParts()) {
            if (p instanceof VectorPart) {
                wrt.write(this.generateVectorPCL((VectorPart)p));
                continue;
            }
            if (p instanceof RasterPart) {
                wrt.write(this.generateRasterPCL((RasterPart)p));
                continue;
            }
            if (!(p instanceof Raster3dPart)) continue;
            wrt.write(this.generateRaster3dPCL((Raster3dPart)p));
        }
        if (!(job.getParts().get(job.getParts().size() - 1) instanceof VectorPart)) {
            wrt.write(this.generateDummyVector(job.getParts().get(job.getParts().size() - 1).getDPI()));
        }
        wrt.write(this.generatePjlFooter());
        for (int i = 0; i < 4096; ++i) {
            wrt.append('\u0000');
        }
        wrt.flush();
        return pjlJob.toByteArray();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int Port) {
        this.port = Port;
    }

    @Override
    public Object getProperty(String attribute) {
        if ("Hostname".equals(attribute)) {
            return this.getHostname();
        }
        if ("AutoFocus".equals(attribute)) {
            return this.isAutoFocus();
        }
        if ("Port".equals(attribute)) {
            return this.getPort();
        }
        if ("BedWidth".equals(attribute)) {
            return this.getBedWidth();
        }
        if ("BedHeight".equals(attribute)) {
            return this.getBedHeight();
        }
        return null;
    }

    @Override
    public double getBedWidth() {
        return this.bedWidth;
    }

    public void setBedWidth(double bedWidth) {
        this.bedWidth = bedWidth;
    }

    @Override
    public double getBedHeight() {
        return this.bedHeight;
    }

    public void setBedHeight(double bedHeight) {
        this.bedHeight = bedHeight;
    }

    @Override
    public void setProperty(String attribute, Object value) {
        if ("Hostname".equals(attribute)) {
            this.setHostname((String)value);
        } else if ("AutoFocus".endsWith(attribute)) {
            this.setAutoFocus((Boolean)value);
        } else if ("Port".equals(attribute)) {
            this.setPort((Integer)value);
        } else if ("BedWidth".equals(attribute)) {
            this.setBedWidth((Double)value);
        } else if ("BedHeight".equals(attribute)) {
            this.setBedHeight((Double)value);
        }
    }

    @Override
    public String[] getPropertyKeys() {
        return attributes;
    }

    @Override
    public boolean canEstimateJobDuration() {
        return true;
    }

    @Override
    public int estimateJobDuration(LaserJob job) {
        double VECTOR_MOVESPEED_X = 4444.444444444444;
        double VECTOR_MOVESPEED_Y = 4000.0;
        double VECTOR_LINESPEED = 543.4782608695652;
        double RASTER_LINEOFFSET = 0.08;
        double RASTER_LINESPEED = 100000.0 / (5.36 - RASTER_LINEOFFSET);
        double RASTER3D_LINEOFFSET = 0.08;
        double RASTER3D_LINESPEED = 100000.0 / (5.36 - RASTER3D_LINEOFFSET);
        Point p = new Point(0, 0);
        double result = 0.0;
        for (JobPart jp : job.getParts()) {
            boolean lineEmpty;
            int y;
            double linespeed;
            Point sp;
            JobPart rp;
            if (jp instanceof RasterPart) {
                rp = (RasterPart)jp;
                sp = ((RasterPart)rp).getRasterStart();
                result += Math.max((double)(p.x - sp.x) / VECTOR_MOVESPEED_X, (double)(p.y - sp.y) / VECTOR_MOVESPEED_Y);
                linespeed = RASTER_LINESPEED * (double)((PowerSpeedFocusProperty)((RasterPart)rp).getLaserProperty()).getSpeed() / 100.0;
                for (y = 0; y < ((RasterPart)rp).getRasterHeight(); ++y) {
                    lineEmpty = true;
                    for (byte b : ((RasterPart)rp).getRasterLine(y)) {
                        if (b == 0) continue;
                        lineEmpty = false;
                        break;
                    }
                    if (!lineEmpty) {
                        int w = ((RasterPart)rp).getRasterWidth();
                        result += RASTER_LINEOFFSET + (double)w / linespeed;
                        p.x = sp.y % 2 == 0 ? sp.x + w : sp.x;
                        p.y = sp.y + y;
                        continue;
                    }
                    result += RASTER_LINEOFFSET;
                }
            }
            if (jp instanceof Raster3dPart) {
                rp = (Raster3dPart)jp;
                sp = ((Raster3dPart)rp).getRasterStart();
                result += Math.max((double)(p.x - sp.x) / VECTOR_MOVESPEED_X, (double)(p.y - sp.y) / VECTOR_MOVESPEED_Y);
                linespeed = RASTER3D_LINESPEED * (double)((PowerSpeedFocusProperty)((Raster3dPart)rp).getLaserProperty()).getSpeed() / 100.0;
                for (y = 0; y < ((Raster3dPart)rp).getRasterHeight(); ++y) {
                    lineEmpty = true;
                    for (byte b : ((Raster3dPart)rp).getRasterLine(y)) {
                        if (b == 0) continue;
                        lineEmpty = false;
                        break;
                    }
                    if (lineEmpty) continue;
                    int w = ((Raster3dPart)rp).getRasterWidth();
                    result += RASTER3D_LINEOFFSET + (double)w / linespeed;
                    p.x = sp.y % 2 == 0 ? sp.x + w : sp.x;
                    p.y = sp.y + y;
                }
            }
            if (!(jp instanceof VectorPart)) continue;
            double speed = VECTOR_LINESPEED;
            VectorPart vp = (VectorPart)jp;
            block10: for (VectorCommand cmd : vp.getCommandList()) {
                switch (cmd.getType()) {
                    case SETPROPERTY: {
                        speed = VECTOR_LINESPEED * (double)((PowerSpeedFocusFrequencyProperty)cmd.getProperty()).getSpeed() / 100.0;
                        continue block10;
                    }
                    case MOVETO: {
                        result += Math.max((double)(p.x - cmd.getX()) / VECTOR_MOVESPEED_X, (double)(p.y - cmd.getY()) / VECTOR_MOVESPEED_Y);
                        p = new Point(cmd.getX(), cmd.getY());
                        continue block10;
                    }
                    case LINETO: {
                        double dist = this.distance(cmd.getX(), cmd.getY(), p);
                        p = new Point(cmd.getX(), cmd.getY());
                        result += dist / speed;
                    }
                }
            }
        }
        return (int)result;
    }

    private double distance(int x, int y, Point p) {
        return Math.sqrt(Math.pow(p.x - x, 2.0) + Math.pow(p.y - y, 2.0));
    }
}

