/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.dithering;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.dithering.DitheringAlgorithm;

public class Ordered
extends DitheringAlgorithm {
    @Override
    protected void doDithering(GreyscaleRaster src, BlackWhiteRaster target) {
        int ydelta;
        int xdelta;
        int width = src.getWidth();
        int height = src.getHeight();
        int nPatWid = 4;
        int[][] filter = new int[][]{{16, 144, 48, 176}, {208, 80, 240, 112}, {64, 192, 32, 160}, {256, 128, 224, 96}};
        int x = 0;
        int y = 0;
        int pixelcount = 0;
        for (y = 0; y < height - nPatWid; y += nPatWid) {
            for (x = 0; x < width - nPatWid; x += nPatWid) {
                for (xdelta = 0; xdelta < nPatWid; ++xdelta) {
                    for (ydelta = 0; ydelta < nPatWid; ++ydelta) {
                        this.setBlack(src, target, x + xdelta, y + ydelta, src.getGreyScale(x + xdelta, y + ydelta) < filter[xdelta][ydelta]);
                    }
                }
            }
            for (xdelta = 0; xdelta < nPatWid; ++xdelta) {
                for (ydelta = 0; ydelta < nPatWid; ++ydelta) {
                    if (x + xdelta >= width || y + ydelta >= height) continue;
                    this.setBlack(src, target, x + xdelta, y + ydelta, src.getGreyScale(x + xdelta, y + ydelta) < filter[xdelta][ydelta]);
                }
            }
            this.setProgress(100 * pixelcount++ / height);
        }
        for (x = 0; x < width; x += nPatWid) {
            for (xdelta = 0; xdelta < nPatWid; ++xdelta) {
                for (ydelta = 0; ydelta < nPatWid; ++ydelta) {
                    if (x + xdelta >= width || y + ydelta >= height) continue;
                    this.setBlack(src, target, x + xdelta, y + ydelta, src.getGreyScale(x + xdelta, y + ydelta) < filter[xdelta][ydelta]);
                }
            }
        }
    }

    @Override
    public DitheringAlgorithm clone() {
        return new Ordered();
    }

    @Override
    public String toString() {
        return "Ordered";
    }
}

