/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.dithering;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.dithering.DitheringAlgorithm;

public class Grid
extends DitheringAlgorithm {
    private static String[] properties = new String[]{"Blocksize", "Blockdistance"};
    protected int blocksize = 10;
    protected int blockdistance = 5;

    @Override
    public String[] getPropertyKeys() {
        return properties;
    }

    @Override
    public void setProperty(String key, Object value) {
        if (properties[0].equals(key)) {
            this.blocksize = (Integer)value;
        } else if (properties[1].equals(key)) {
            this.blockdistance = (Integer)value;
        } else {
            throw new IllegalArgumentException("No such key " + key);
        }
    }

    @Override
    public Object getProperty(String key) {
        if (properties[0].equals(key)) {
            return this.blocksize;
        }
        if (properties[1].equals(key)) {
            return this.blockdistance;
        }
        throw new IllegalArgumentException("No such key " + key);
    }

    @Override
    protected void doDithering(GreyscaleRaster src, BlackWhiteRaster target) {
        long lumTotal = 0L;
        int pixelcount = 0;
        int width = src.getWidth();
        int height = src.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                lumTotal += (long)src.getGreyScale(x, y);
            }
            this.setProgress(100 * pixelcount++ / (2 * height));
        }
        int thresh = (int)(lumTotal / (long)height / (long)width);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (y % (this.blocksize + this.blockdistance) <= this.blocksize && x % (this.blocksize + this.blockdistance) <= this.blocksize && src.getGreyScale(x, y) < thresh) {
                    this.setBlack(src, target, x, y, true);
                    continue;
                }
                this.setBlack(src, target, x, y, false);
            }
            this.setProgress(100 * pixelcount++ / (2 * height));
        }
    }

    @Override
    public DitheringAlgorithm clone() {
        Grid clone = new Grid();
        clone.blockdistance = this.blockdistance;
        clone.blocksize = this.blocksize;
        return clone;
    }

    @Override
    public String toString() {
        return "Grid";
    }
}

