/*
 * Decompiled with CFR 0.152.
 */
package com.t_oster.liblasercut.dithering;

import com.t_oster.liblasercut.BlackWhiteRaster;
import com.t_oster.liblasercut.GreyscaleRaster;
import com.t_oster.liblasercut.dithering.DitheringAlgorithm;

public class FloydSteinberg
extends DitheringAlgorithm {
    @Override
    protected void doDithering(GreyscaleRaster src, BlackWhiteRaster target) {
        int pixelcount = 0;
        int[][] input = new int[src.getWidth()][2];
        for (int x = 0; x < src.getWidth(); ++x) {
            input[x][1] = src.getGreyScale(x, 0);
        }
        for (int y = 0; y < src.getHeight(); ++y) {
            int x;
            for (x = 0; x < input.length; ++x) {
                input[x][0] = input[x][1];
                if (y + 1 >= src.getHeight()) continue;
                input[x][1] = src.getGreyScale(x, y + 1);
            }
            for (x = 0; x < input.length; ++x) {
                this.setBlack(src, target, x, y, input[x][0] <= 127);
                int error = input[x][0] - (input[x][0] <= 127 ? 0 : 255);
                if (x + 1 < input.length) {
                    input[x + 1][0] = input[x + 1][0] + 7 * error / 16;
                    if (y + 1 < src.getHeight()) {
                        input[x + 1][1] = input[x + 1][1] + 1 * error / 16;
                    }
                }
                if (y + 1 >= src.getHeight()) continue;
                input[x][1] = input[x][1] + 5 * error / 16;
                if (x <= 0) continue;
                input[x - 1][1] = input[x - 1][1] + 3 * error / 16;
            }
            this.setProgress(100 * pixelcount++ / src.getHeight());
        }
    }

    @Override
    public DitheringAlgorithm clone() {
        return new FloydSteinberg();
    }

    @Override
    public String toString() {
        return "Floyd-Steinberg";
    }
}

